

#ifndef INC_CM_EVENT_EPOLL_H_
#define INC_CM_EVENT_EPOLL_H_

#include <sys/epoll.h>
#include <errno.h>
#include <cstring>
#include <map>

#include "mt_type_erasure_handler.h"
#include "mt_type_convertibility.h"
#include "mt_range.h"

namespace cm {

class Event
{
private:
    static const unsigned int MAX_NUMBER_OF_HANDLERS = 64u;

public:
    static Event& tsdInstance();

    ~Event();

    template <typename T, typename EventBaseType, typename EventType>
    void addHandlerRead(T& obj, bool (T::*Handler)(EventBaseType&), EventType& etype,
                        typename mt::EnableIf<mt::IsConvertible<EventBaseType, EventType>::value>::Result* = 0)
    {
        int read_fd = getFD(etype);

        read_map_[read_fd] = new mt::HandlerHolder1Arg<bool, EventBaseType, T>(obj, etype, Handler);

        struct epoll_event ev;
        memset(&ev, 0, sizeof(ev));
        ev.events = EPOLLIN;
        ev.data.fd = read_fd;
        if (0 != epoll_ctl(epfd_, EPOLL_CTL_ADD, read_fd, &ev)) {
            assert(false);
        }
    }

    template <typename T, typename EventBaseType, typename EventType>
    void addHandlerRead(T& obj, bool (T::*Handler)(EventBaseType&) const, EventType& etype,
                        typename mt::EnableIf<mt::IsConvertible<EventBaseType, EventType>::value>::Result* = 0)
    {
        int read_fd = getFD(etype);

        read_map_[read_fd] = new mt::HandlerConstHolder1Arg<bool, EventBaseType, T>(obj, etype, Handler);

        struct epoll_event ev;
        memset(&ev, 0, sizeof(ev));
        ev.events = EPOLLIN;
        ev.data.fd = read_fd;
        if (0 != epoll_ctl(epfd_, EPOLL_CTL_ADD, read_fd, &ev)) {
            assert(false);
        }
    }

    template <typename EventType>
    void delHandlerRead(EventType& etype)
    {
        int read_fd = getFD(etype);

        if (0 != epoll_ctl(epfd_, EPOLL_CTL_DEL, read_fd, NULL)) {
            assert(false);
        }

        HandlerMap::iterator it = read_map_.find(read_fd);
        assert(it != mt::end(read_map_));

        delete (*it).second;
        read_map_.erase(it);
    }

    void pend();

private:
    Event();

    // Non-copyable
    Event(const Event& rhs);
    Event& operator=(const Event& rhs);

    int epfd_;
    struct epoll_event epevent[MAX_NUMBER_OF_HANDLERS*2];

    typedef std::map< int, mt::HandlerBase<bool>* > HandlerMap;
    std::map< int, mt::HandlerBase<bool>* > read_map_;
};

} // namespace cm

#endif // INC_CM_EVENT_EPOLL_H_

