
#include <pthread.h>
#include <iostream>
#include <sstream>
#include "gmock/gmock.h"

#include "cm_thread.h"
#include "cm_thread_specific_data.h"

namespace cm {
class ThreadSpecificDataTest : public ::testing::Test
{
protected:
    virtual void SetUp()
    {}

    virtual void TearDown()
    {}
};

static unsigned int count = 0u;

class StringWrapper : public std::string
{
public:
    StringWrapper(const std::string& str) : std::string(str)
    {}

    ~StringWrapper()
    {
        std::cout << "Dtor ! " << *this << std::endl;
    }
};

struct TestThread
{
    TestThread()
    {}

    void run()
    {
        std::cout << "Thread id = [" << pthread_self() << "]" << std::endl;
        ++count;
        std::ostringstream oss;
        oss << count;
    
        StringWrapper* ptr(new StringWrapper(oss.str()));

        ThreadSpecificData<StringWrapper>::set(ptr);
        StringWrapper& tsd_data = ThreadSpecificData<StringWrapper>::get();

        EXPECT_EQ(ptr, &tsd_data);

        sleep(count);
        std::cout << "exiting run()" << std::endl;
    }
};

TEST_F(ThreadSpecificDataTest, simple)
{
    std::cout << "Main-Thread id = [" << pthread_self() << "]" << std::endl;
    std::cout << "Process Id = [" << getpid() << "]" << std::endl;

    Thread<TestThread> thread1("thread_test1"),
                       thread2("thread_test2"),
                       thread3("thread_test3");

    thread1.create();
    thread2.create();
    thread3.create();

    thread1.join();
    thread2.join();
    thread3.join();
}

} // namespace cm
