
#include <sys/socket.h>
#include <utility>
#include <arpa/inet.h>

#include "cm_socket_server.h"
#include "cm_socket_setter.h"
#include "cm_socket.h"
#include "mt_typelist_algo_find_if.h"
#include "mt_shim_clear_memory.h"

namespace cm {

SocketServer::SocketServer(SocketType type, const char* server_name, unsigned short port)
    : fd_(-1), socket_type_(type)
{
    std::pair<int, int> domain_proto_pair;

    bool ret = mt::FindIf<SocketSetterTypes>()(domain_proto_pair, type);
    assert(ret);

    fd_ = socket(domain_proto_pair.first, domain_proto_pair.second, 0);
    assert(fd_ >= 0);

    std::pair<SocketAddress, socklen_t> address_length_pair;
    ret = mt::FindIf<SocketAddressSetterTypes>(server_name, port)(address_length_pair, domain_proto_pair.first);
    assert(ret == true);

    int flag = 1;
    ret = setsockopt(fd_, SOL_SOCKET, SO_REUSEADDR, &flag, sizeof(flag));
    assert(ret == 0);

    ret = bind(fd_, reinterpret_cast<struct sockaddr*>(&address_length_pair.first), address_length_pair.second);
    assert(ret == 0);

    ret = listen(fd_, 5);
    assert(ret == 0);
}

SocketServer::~SocketServer()
{
    if (fd_ >= 0) {
        close(fd_);
        fd_ = -1;
    }
}

SocketIf* SocketServer::doAccept()
{
    assert(fd_ >= 0);

    SocketAddress sock_addr;
    mt::clearMemory(sock_addr);
    socklen_t addr_len = sizeof(sock_addr);
    int new_fd = ::accept(fd_, reinterpret_cast<struct sockaddr*>(&sock_addr), &addr_len);
    return new Socket(new_fd);
}

} // namespace cm

