
#include <sys/socket.h>
#include <utility>
#include <fcntl.h>
#include <errno.h>
#include <iostream>
#include <string.h>

#include "cm_socket.h"
#include "cm_socket_client.h"
#include "cm_socket_setter.h"
#include "mt_unuse.h"
#include "mt_typelist_algo_find_if.h"

namespace cm {

SocketClient::SocketClient(SocketType type, bool is_nonblock)
    : fd_(-1), is_nonblock_(is_nonblock), socket_type_(type)
{
}

SocketClient::~SocketClient()
{}

SocketIf* SocketClient::doConnect(const char* server_name, unsigned short port)
{
    std::pair<int, int> domain_proto_pair;
    bool ret = mt::FindIf<SocketSetterTypes>()(domain_proto_pair, socket_type_);
    assert(ret);

    fd_ = socket(domain_proto_pair.first, domain_proto_pair.second, 0);
    assert(fd_ >= 0);

    std::pair<SocketAddress, socklen_t> address_length_pair;
    ret = mt::FindIf<SocketAddressSetterTypes>(server_name, port)(address_length_pair, domain_proto_pair.first);
    assert(ret == true);

    if (is_nonblock_) {
        fcntl(fd_, F_SETFD, O_NONBLOCK);
    }

    int retval = ::connect(fd_, reinterpret_cast<struct sockaddr*>(&address_length_pair.first),
                         address_length_pair.second);

    if (retval < 0) {
        if (errno == EWOULDBLOCK || errno == EAGAIN) {
            return 0;
        }
        std::cout << strerror(errno) << std::endl;
        assert(false);
    }
        
    return new Socket(fd_);
}

} // namespace cm
