/*
 * CAN/LIN Checker for RL78/F13,F14
 *
 * Target: QB-R5F10PPJ-TB (RL78/F14, 100pin, 256KB ROM, 20KB RAM)
 * Author: Yasushi Tanaka
 *
 * [ OhCo ]
 */

#ifndef LOG_H
#define LOG_H

/*
 * O
 * UART`l`
 */
#define LOG_UART_CH				((u1)(0x01))
									/* Oo͂UART`l(0 or 1) */

/*
 * O
 * obt@TCY`
 */
#define LOG_BUFFER_SIZE			((u2)(0x0200))
									/* Oobt@̃TCY(ꕔDTCACgpA0x0200ȏƂ) */

/*
 * O
 * 
 */
void log_init(void);

/*
 * O
 * obt@ݒ
 */
void log_set_buf(u1* buf, u2 size);

/*
 * O
 * o͋֎~
 */
void log_disable(void);

/*
 * O
 * o͋
 */
void log_enable(void);

/*
 * O
 * o͋Ԏ擾
 */
u1 log_is_enabled(void);

/*
 * O
 * o(^CX^vAsȂ)
 */
void log_output(u1* msg);

/*
 * O
 * o
 */
void log_msg(char* msg);

/*
 * O
 * o(u1l)
 */
void log_u1(char* msg, u1 value);

/*
 * O
 * o(u2l)
 */
void log_u2(char* msg, u2 value);

/*
 * O
 * 16i4ݒ
 */
void log_u2_4hex(u1* buf, u2 value);

/*
 * O
 * M
 *
 * 荞݋֎~ԂŌĂ΂
 */
void log_isr(u1 ch);

#endif /* LOG_H */
