/*
 * CAN/LIN/UART/PORT Checker for RL78/F14
 *
 * Target: QB-R5F10PPJ-TB (RL78/F14, 100pin, 256KB ROM, 20KB RAM)
 * Author: Yasushi Tanaka
 *
 * [ CvO ]
 */

#include "common.h"
#include "cpu.h"
#include "clock.h"
#include "timer.h"
#include "uart.h"
#include "dtc.h"
#include "log.h"
#include "led.h"
#include "can.h"
#include "can_tja.h"
#include "debug.h"

/*
 * C
 * RtBOݒ(荞݋֎~)
 */
static void config(void)
{
	/* hCow(KvȃW[̂) */
	can_config();
}

/*
 * C
 * (荞݋֎~)
 */
static void init(void)
{
	/* hCow */
	clock_init();
	timer_init();
	uart_init(0, 1200);
	uart_init(1, 1200);
	log_init();
	dtc_init();
	led_init();
	can_init();
	can_tja_init();

	/* W[w */
	debug_init();
}

/*
 * C
 * Jn(荞݋)
 */
static void start(void)
{
	/* hCow */
	timer_start();
	uart_rx_start(0);
	uart_rx_start(1);
	can_test(CAN_TEST_INT_LOOP_BACK);
	can_start();

	/* 荞݋ */
	cpu_ei(CPU_FORCE_EI);
}

#define SCHEDULE_MS				((u2)(0x00C8))
									/* XPW[Tick */

/*
 * XPW[pGA
 */
static SADDR u2 next_ms;
									/* ̎s */
static SADDR u1 sch_count;
									/* XPW[JE^ */

/*
 * CANMt[
 */
static can_frame can_tx_frame;
									/* CANMt[ */

/*
 * ̃XPW[ɂȂĂ邩`FbN
 */
static u1 is_next_schedule(void)
{
	timer_info info;
	u1 ret;

	/* ߂l */
	ret = U1_FALSE;

	/* ݂̃^C}擾 */
	timer_getinfo(&info);

	/* next_ms1000ȏォǂŕ */
	if (next_ms >= 1000)
	{
		/* ݂ms500ȉ */
		if (info.ms <= 500)
		{
			/* info.ms1000ZĔr */
			info.ms += 1000;
			if (info.ms >= next_ms)
			{
				/* OKAɐi */
				next_ms -= 1000;
				next_ms += SCHEDULE_MS;
				ret = U1_TRUE;
			}
		}
	}
	else
	{
		/* Pr */
		if (info.ms >= next_ms)
		{
			/* OKAɐi */
			next_ms += SCHEDULE_MS;
			ret = U1_TRUE;
		}
	}

	/* U1_TRUȄꍇ̓O */
	if (U1_TRUE == ret)
	{
		log_u2("MAIN:schedule start. next=", next_ms);
	}

	return ret;
}

/*
 * s
 */
static void exec(void)
{
	/* LED݂ɓ_ */
	if (0 == (sch_count & 1))
	{
		led_on(0);
	}
	else
	{
		led_off(0);
	}

	/* CAN̑Mt[쐬 */
	can_tx_frame.id_l = 0x5a;
	can_tx_frame.id_h = 0x07;
	can_tx_frame.dlc = 8;

	can_tx_enque(&can_tx_frame);
}

/*
 * ACh
 */
static void idle(void)
{
	/* hCow */
	uart_idle(0);
	uart_idle(1);
	can_idle();

	/* W[w */
	debug_idle();
}

/*
 * CvO
 */
void main(void)
{
	u1 elapsed;

	/* 荞݋֎~ */
	(void)cpu_di();

	/* RtBOݒ */
	config();

	/*  */
	init();

	/* Jn */
	start();

	/* [NGA */
	next_ms = 0;
	sch_count = 0;

	/* [v */
	for (;;)
	{
		/* XPW[`FbN */
		elapsed = is_next_schedule();
		if (U1_TRUE == elapsed)
		{
			/* sƃJEgAbv */
			exec();
			sch_count++;
		}

		/* ACh */
		idle();

		/* CANMf[^̂Ă */
		if (0 != can_rx_get())
		{
			can_rx_deque(&can_tx_frame);
		}
	}
}
