/***************************************************************************/
/** @file       mm_vector.cpp
    @brief      Zp֐
    @author     shom
****************************************************************************/

#include "pch_util.h"

#include "mm.h"


/***************************************************************************
	mm( namespace )
****************************************************************************/

void	mm::zero_v( vec2f& v )
{
	v = vec2f( 0.0f, 0.0f );
}
void	mm::zero_v( vec3f& v )
{
	v = vec3f( 0.0f, 0.0f, 0.0f );
}
void	mm::zero_v( vec4f& v )
{
	v = vec4f( 0.0f, 0.0f, 0.0f, 0.0f );
}
vec2f	mm::zero_v2()
{
	return vec2f( 0.0f, 0.0f );
}
vec3f	mm::zero_v3()
{
	return vec3f( 0.0f, 0.0f, 0.0f );
}
vec4f	mm::zero_v4()
{
	return vec4f( 0.0f, 0.0f, 0.0f, 0.0f );
}

void	mm::half_v( vec2f& v )
{
	v = vec2f( 0.5f, 0.5f );
}
void	mm::half_v( vec3f& v )
{
	v = vec3f( 0.5f, 0.5f, 0.5f );
}
void	mm::half_v( vec4f& v )
{
	v = vec4f( 0.5f, 0.5f, 0.5f, 0.5f );
}
vec2f	mm::half_v2()
{
	return vec2f( 0.5f, 0.5f );
}
vec3f	mm::half_v3()
{
	return vec3f( 0.5f, 0.5f, 0.5f );
}
vec4f	mm::half_v4()
{
	return vec4f( 0.5f, 0.5f, 0.5f, 0.5f );
}

void	mm::one_v( vec2f& v )
{
	v = vec2f( 1.0f, 1.0f );
}
void	mm::one_v( vec3f& v )
{
	v = vec3f( 1.0f, 1.0f, 1.0f );
}
void	mm::one_v( vec4f& v )
{
	v = vec4f( 1.0f, 1.0f, 1.0f, 1.0f );
}
vec2f	mm::one_v2()
{
	return vec2f( 1.0f, 1.0f );
}
vec3f	mm::one_v3()
{
	return vec3f( 1.0f, 1.0f, 1.0f );
}
vec4f	mm::one_v4()
{
	return vec4f( 1.0f, 1.0f, 1.0f, 1.0f );
}

void	mm::neg_v( vec2f& v )
{
	v = vec2f( -1.0f, -1.0f );
}
void	mm::neg_v( vec3f& v )
{
	v = vec3f( -1.0f, -1.0f, -1.0f );
}
void	mm::neg_v( vec4f& v )
{
	v = vec4f( -1.0f, -1.0f, -1.0f, -1.0f );
}
vec2f	mm::neg_v2()
{
	return vec2f( -1.0f, -1.0f );
}
vec3f	mm::neg_v3()
{
	return vec3f( -1.0f, -1.0f, -1.0f );
}
vec4f	mm::neg_v4()
{
	return vec4f( -1.0f, -1.0f, -1.0f, -1.0f );
}

vec2f mm::get_v( f32 x, f32 y )
{
	return vec2f( x, y );
}

vec3f mm::get_v( f32 x, f32 y, f32 z )
{
	return vec3f( x, y, z );
}

vec4f mm::get_v( f32 x, f32 y, f32 z, f32 w )
{
	return vec4f( x, y, z, w );
}

vec2f	mm::get_v2_all( f32 in_val )
{
	return get_v( in_val, in_val );
}

vec3f	mm::get_v3_all( f32 in_val )
{
	return get_v( in_val, in_val, in_val );
}

vec4f	mm::get_v4_all( f32 in_val )
{
	return get_v( in_val, in_val, in_val, in_val );
}

vec3f	mm::v2_to_v3( const vec2f& in_v2, f32 in_z )
{
	return vec3f( in_v2.x, in_v2.y, in_z );
}

vec4f	mm::v3_to_v4( const vec3f& in_v3, f32 in_w )
{
	return vec4f( in_v3.x, in_v3.y, in_v3.z, in_w );
}

vec2f	mm::v3_to_v2( const vec3f& in_v3 )
{
	return vec2f( in_v3.x, in_v3.y );
}

vec3f	mm::v4_to_v3( const vec4f& in_v4 )
{
	return vec3f( in_v4.x, in_v4.y, in_v4.z );
}

vec2f	mm::add_v( const vec2f& in_v2_1, const vec2f& in_v2_2 )
{
	const f32 x = in_v2_1.x + in_v2_2.x;
	const f32 y = in_v2_1.y + in_v2_2.y;

	return vec2f( x, y );
}

vec3f	mm::add_v( const vec3f& in_v3_1, const vec3f& in_v3_2 )
{
	const f32 x = in_v3_1.x + in_v3_2.x;
	const f32 y = in_v3_1.y + in_v3_2.y;
	const f32 z = in_v3_1.z + in_v3_2.z;

	return vec3f( x, y, z );
}

vec4f	mm::add_v( const vec4f& in_v4_1, const vec4f& in_v4_2 )
{
	const f32 x = in_v4_1.x + in_v4_2.x;
	const f32 y = in_v4_1.y + in_v4_2.y;
	const f32 z = in_v4_1.z + in_v4_2.z;
	const f32 w = in_v4_1.w + in_v4_2.w;

	return vec4f( x, y, z, w );
}

vec2f	mm::add_x_v( const vec2f& in_v2_1, f32 in_x )
{
	const f32 x = in_v2_1.x + in_x;

	return vec2f( x, in_v2_1.y );
}

vec3f	mm::add_x_v( const vec3f& in_v3_1, f32 in_x )
{
	const f32 x = in_v3_1.x + in_x;

	return vec3f( x, in_v3_1.y, in_v3_1.z );
}

vec4f	mm::add_x_v( const vec4f& in_v4_1, f32 in_x )
{
	const f32 x = in_v4_1.x + in_x;

	return vec4f( x, in_v4_1.y, in_v4_1.z, in_v4_1.w );
}

vec2f	mm::add_y_v( const vec2f& in_v2_1, f32 in_y )
{
	const f32 y = in_v2_1.y + in_y;

	return vec2f( in_v2_1.x, y );
}

vec3f	mm::add_y_v( const vec3f& in_v3_1, f32 in_y )
{
	const f32 y = in_v3_1.y + in_y;

	return vec3f( in_v3_1.x, y, in_v3_1.z );
}

vec4f	mm::add_y_v( const vec4f& in_v4_1, f32 in_y )
{
	const f32 y = in_v4_1.y + in_y;

	return vec4f( in_v4_1.x, y, in_v4_1.z, in_v4_1.w );
}

vec3f	mm::add_z_v( const vec3f& in_v3_1, f32 in_z )
{
	const f32 z = in_v3_1.z + in_z;

	return vec3f( in_v3_1.x, in_v3_1.y, z );
}

vec4f	mm::add_z_v( const vec4f& in_v4_1, f32 in_z )
{
	const f32 z = in_v4_1.z + in_z;

	return vec4f( in_v4_1.x, in_v4_1.y, z, in_v4_1.w );
}

vec4f	mm::add_w_v( const vec4f& in_v4_1, f32 in_w )
{
	const f32 w = in_v4_1.w + in_w;

	return vec4f( in_v4_1.x, in_v4_1.y, in_v4_1.z, w );
}

vec2f	mm::sub_v( const vec2f& in_v2_1, const vec2f& in_v2_2 )
{
	const f32 x = in_v2_1.x - in_v2_2.x;
	const f32 y = in_v2_1.y - in_v2_2.y;

	return vec2f( x, y );
}

vec3f	mm::sub_v( const vec3f& in_v3_1, const vec3f& in_v3_2 )
{
	const f32 x = in_v3_1.x - in_v3_2.x;
	const f32 y = in_v3_1.y - in_v3_2.y;
	const f32 z = in_v3_1.z - in_v3_2.z;

	return vec3f( x, y, z );
}

vec4f	mm::sub_v( const vec4f& in_v4_1, const vec4f& in_v4_2 )
{
	const f32 x = in_v4_1.x - in_v4_2.x;
	const f32 y = in_v4_1.y - in_v4_2.y;
	const f32 z = in_v4_1.z - in_v4_2.z;
	const f32 w = in_v4_1.w - in_v4_2.w;

	return vec4f( x, y, z, w );
}

vec2f	mm::sub_x_v( const vec2f& in_v2_1, f32 in_x )
{
	const f32 x = in_v2_1.x - in_x;

	return vec2f( x, in_v2_1.y );
}

vec3f	mm::sub_x_v( const vec3f& in_v3_1, f32 in_x )
{
	const f32 x = in_v3_1.x - in_x;

	return vec3f( x, in_v3_1.y, in_v3_1.z );
}

vec4f	mm::sub_x_v( const vec4f& in_v4_1, f32 in_x )
{
	const f32 x = in_v4_1.x - in_x;

	return vec4f( x, in_v4_1.y, in_v4_1.z, in_v4_1.w );
}

vec2f	mm::sub_y_v( const vec2f& in_v2_1, f32 in_y )
{
	const f32 y = in_v2_1.y - in_y;

	return vec2f( in_v2_1.x, y );
}

vec3f	mm::sub_y_v( const vec3f& in_v3_1, f32 in_y )
{
	const f32 y = in_v3_1.y - in_y;

	return vec3f( in_v3_1.x, y, in_v3_1.z );
}

vec4f	mm::sub_y_v( const vec4f& in_v4_1, f32 in_y )
{
	const f32 y = in_v4_1.y - in_y;

	return vec4f( in_v4_1.x, y, in_v4_1.z, in_v4_1.w );
}

vec3f	mm::sub_z_v( const vec3f& in_v3_1, f32 in_z )
{
	const f32 z = in_v3_1.z - in_z;

	return vec3f( in_v3_1.x, in_v3_1.y, z );
}

vec4f	mm::sub_z_v( const vec4f& in_v4_1, f32 in_z )
{
	const f32 z = in_v4_1.z - in_z;

	return vec4f( in_v4_1.x, in_v4_1.y, z, in_v4_1.w );
}

vec4f	mm::sub_w_v( const vec4f& in_v4_1, f32 in_w )
{
	const f32 w = in_v4_1.w - in_w;

	return vec4f( in_v4_1.x, in_v4_1.y, in_v4_1.z, w );
}

vec2f	mm::mul_v( const vec2f& in_v2_1, const f32 in_val )
{
	const f32 x = in_v2_1.x * in_val;
	const f32 y = in_v2_1.y * in_val;

	return vec2f( x, y );
}

vec3f	mm::mul_v( const vec3f& in_v3_1, const f32 in_val )
{
	const f32 x = in_v3_1.x * in_val;
	const f32 y = in_v3_1.y * in_val;
	const f32 z = in_v3_1.z * in_val;

	return vec3f( x, y, z );
}

vec4f	mm::mul_v( const vec4f& in_v4_1, const f32 in_val )
{
	const f32 x = in_v4_1.x * in_val;
	const f32 y = in_v4_1.y * in_val;
	const f32 z = in_v4_1.z * in_val;
	const f32 w = in_v4_1.w * in_val;

	return vec4f( x, y, z, w );
}

#define MM_ASSERT( expr ) if( !expr ){ DebugBreak(); }

vec2f	mm::div_v( const vec2f& in_v2_1, const f32 in_val )
{
	MM_ASSERT( !( mm::is_equal_zero_f( in_val ) ) );

	const f32 x = in_v2_1.x / in_val;
	const f32 y = in_v2_1.y / in_val;

	return vec2f( x, y );
}

vec3f	mm::div_v( const vec3f& in_v3_1, const f32 in_val )
{
	MM_ASSERT( !( mm::is_equal_zero_f( in_val ) ) );

	const f32 x = in_v3_1.x / in_val;
	const f32 y = in_v3_1.y / in_val;
	const f32 z = in_v3_1.z / in_val;

	return vec3f( x, y, z );
}

vec4f	mm::div_v( const vec4f& in_v4_1, const f32 in_val )
{
	MM_ASSERT( !( mm::is_equal_zero_f( in_val ) ) );

	const f32 x = in_v4_1.x / in_val;
	const f32 y = in_v4_1.y / in_val;
	const f32 z = in_v4_1.z / in_val;
	const f32 w = in_v4_1.w / in_val;

	return vec4f( x, y, z, w );
}

f32		mm::length( const vec2f& v )
{
	return D3DXVec2Length( &v );
}
f32 	mm::length( const vec3f& v )
{
	return D3DXVec3Length( &v );
}
f32 	mm::length( const vec4f& v )
{
	return D3DXVec4Length( &v );
}

f32 	mm::length_sq( const vec2f& v )
{
	return D3DXVec2LengthSq( &v );
}
f32 	mm::length_sq( const vec3f& v )
{
	return D3DXVec3LengthSq( &v );
}
f32 	mm::length_sq( const vec4f& v )
{
	return D3DXVec4LengthSq( &v );
}

f32		mm::dot( const vec2f& v1, const vec2f& v2 )
{
	return ( v1.x * v2.x ) + ( v1.y * v2.y );
}

vec2f	mm::normalize( const vec2f& v_in )
{
	vec2f v_out;

	D3DXVec2Normalize( &v_out, &v_in );

	return v_out;
}

vec2f	mm::mid_point( const vec2f& v1, const vec2f& v2 )
{
	return ( ( v1 + v2 ) / 2.0f );
}

vec2f	mm::translate( const vec2f& v, const vec2f& v_move )
{
	return ( v + v_move );
}

vec2f	mm::rotate( const vec2f& v, f32 rad )
{
	vec2f v_out;

	v_out.x = v.x * cos( rad ) - v.y * sin( rad );
	v_out.y = v.x * sin( rad ) + v.y * cos( rad );

	return v_out;
}

vec2f	mm::rotate_on_pivot(
	const vec2f& v, f32 rad,
	const vec2f& v_pos_pivot
	)
{
	const vec2f v_temp1 = mm::translate( v, -v_pos_pivot );
	const vec2f v_temp2 = mm::rotate( v_temp1, rad );
	return ( mm::translate( v_temp2, +v_pos_pivot ) );
}

vec2f	mm::bezier(
	const vec2f& v1, const vec2f& v2, const vec2f& v3, const vec2f& v4,
	f32 t
	)
{
	const f32 inv_t = ( 1.0f - t );

	return (
		mm::pow( inv_t, 3 ) * v1 +
		3.0f * mm::sq( inv_t ) * t * v2 +
		3.0f * inv_t * mm::sq( t ) * v3 +
		mm::pow( t, 3 ) * v4
		);
}

f32		mm::distance( const vec2f& v_pos_1, const vec2f& v_pos_2 )
{
	const vec2f v_pos_dif = v_pos_1 - v_pos_2;

	return ( pythagorean( v_pos_dif.x, v_pos_dif.y ) );
}

f32		mm::dist( const vec2f& v_pos_1, const vec2f& v_pos_2 )
{
	return ( mm::distance( v_pos_1, v_pos_2 ) );
}

vec2f	mm::direction( const vec2f& v_pos_src, const vec2f& v_pos_dest )
{
	return ( mm::normalize( v_pos_dest - v_pos_src ) );
}

vec2f	mm::dir( const vec2f& v_pos_src, const vec2f& v_pos_dest )
{
	return ( mm::direction( v_pos_src, v_pos_dest ) );
}


