/***************************************************************************/
/** @file       mm_shape.h
    @brief      Zp֐
    @author     shom
****************************************************************************/

#pragma once


namespace mm
{
	///--	"ellipse"
	class ellipse_t
	{
	public:
		__declspec( dllexport )	ellipse_t();

		__declspec( dllexport )	void	SetPos( const vec2f& v2_pos );
		__declspec( dllexport )	void	SetDir( const vec2f& v2_dir );
		__declspec( dllexport )	void	SetLengthOfMajorAxis( f32 length );
		__declspec( dllexport )	void	SetAngleOfSpread( f32 degree );

		__declspec( dllexport )	void	GetFocusPoint( vec2f& v2_out, b32 b_near )	const;
		__declspec( dllexport )	f32		GetLengthOfMinorAxis()	const;

		__declspec( dllexport )	b32		IsIncluded( const vec2f& v2_pos )	const;

	private:
		vec2f m_v_pos;
		vec2f m_v_dir;
		f32	m_half_length_of_major_axis;
		f32 m_dist_center_to_focus;

		vec2f m_v2_pos_focus_tbl[2];

		f32 m_degree_of_spread;
	};
	///--
}


