/***************************************************************************/
/** @file       mm_shape.cpp
    @brief      Zp֐
    @author     shom
****************************************************************************/

#include "pch_util.h"

#include "mm.h"


/***************************************************************************
	mm::ellipse_t
****************************************************************************/

mm::ellipse_t::ellipse_t()
:
m_v_pos( mm::zero_v2() ),
m_v_dir( mm::zero_v2() ),
m_half_length_of_major_axis( 0.0f ),
m_dist_center_to_focus( 0.0f ),

m_v2_pos_focus_tbl(),

m_degree_of_spread( 0.0f )
{
	for( u32 i=0; i<ELEMENTSOF( m_v2_pos_focus_tbl ); ++i )
	{
		mm::zero_v( m_v2_pos_focus_tbl[i] );
	}
}

void	mm::ellipse_t::SetPos( const vec2f& v2_pos )
{
	m_v_pos = v2_pos;
}

void	mm::ellipse_t::SetDir( const vec2f& v2_dir )
{
	m_v_dir = v2_dir;
}

void	mm::ellipse_t::SetLengthOfMajorAxis( f32 length )
{
	m_half_length_of_major_axis = length / 2.0f;

	SetAngleOfSpread( m_degree_of_spread );
}

void	mm::ellipse_t::SetAngleOfSpread( f32 degree )
{
	m_degree_of_spread = degree;

	const f32 rad = mm::degree_to_radian( degree );

	m_dist_center_to_focus =
		m_half_length_of_major_axis *
		mm::sqrt( 1.0f - mm::square( tan( rad ) ) );
}

void	mm::ellipse_t::GetFocusPoint( vec2f& v2_out, b32 b_near )	const
{
	const f32 scale_dir =
		m_half_length_of_major_axis +
		m_dist_center_to_focus * ( b_near ? -1.0f : 1.0f );

	v2_out = m_v_pos + m_v_dir * scale_dir;
}

f32		mm::ellipse_t::GetLengthOfMinorAxis()	const
{
	const f32 length_of_minor_axis_sq =
		mm::square( m_half_length_of_major_axis ) -
		mm::square( m_dist_center_to_focus );

	return ( mm::sqrt( length_of_minor_axis_sq ) * 2.0f );
}

b32		mm::ellipse_t::IsIncluded( const vec2f& v2_pos )	const
{
	vec2f v_focus_near, v_focus_far;
	GetFocusPoint( v_focus_near, TRUE );
	GetFocusPoint( v_focus_far, FALSE );

	const f32 dist_to_focus_near = mm::length( v2_pos - v_focus_near );
	const f32 dist_to_focus_far  = mm::length( v2_pos - v_focus_far );
	const f32 dist_sum = dist_to_focus_near + dist_to_focus_far;

	return ( dist_sum <= m_half_length_of_major_axis * 2.0f );
}

