/***************************************************************************/
/** @file       Sound.cpp
    @brief      
    @author     shom
    @internal
****************************************************************************/

#include "pch_core.h"
#include "Sound.h"


/***************************************************************************
	Sound
****************************************************************************/

CSound::CSound()
:
wvfile(),

m_pDSound(0),

m_p3DListener(0),
m_3DListenerParams()
{
}


CSound::~CSound()
{
	my_safe_rel( m_pDSound );
}


/**
 * DirectSound̏
 * iIDS̎擾, x̐ݒ,
 *   vC}obt@̐ݒ, I3DXi̎擾j
 * 
 * @param HWnd
 * 
 * @return 
 */
HRESULT CSound::Initialize(
	HWND HWnd
	)
{
	my_safe_rel( m_pDSound );	   // 

	///IDirectSound̎擾
	if( FAILED( DirectSoundCreate8(
					NULL,		   // ftHgfoCXI
					&m_pDSound,  // i[
					NULL ) ) )
	{
		return DXTRACE_ERR( _T(""), GetLastError() );
	}

	///x̐ݒ
	if( FAILED( m_pDSound->SetCooperativeLevel(
					HWnd,
					DSSCL_PRIORITY	// D拭xɐݒ
					) ) )
	{
		return DXTRACE_ERR( _T(""), GetLastError() );
	}

	///vC}obt@̃tH[}bg̐ݒ
	if( FAILED( SetPrimaryBufFormat( m_pDSound ) ) )
	{
		return DXTRACE_ERR( _T(""), E_FAIL );
	}

	///I3DXi̎擾
	//C^tF[X擾
	if( FAILED( GetI3DListener( &m_p3DListener ) ) )
	{
		return DXTRACE_ERR( _T(""), GetLastError() );
	}

	//p[^擾
	m_3DListenerParams.dwSize = sizeof( DS3DLISTENER );
	m_p3DListener->GetAllParameters( &m_3DListenerParams ); 

	return S_OK;
}


/**
 * InitDSound̓֐
 * vC}obt@̃tH[}bg̐ݒ
 * 
 * @param pDSound
 * 
 * @return 
 */
HRESULT CSound::SetPrimaryBufFormat(
	LPDIRECTSOUND8 pDSound
	)
{
	// === vC}obt@̎擾 ===
	// - obt@Lqq쐬 -
	DSBUFFERDESC BufDesc;
	ZeroMemory( &BufDesc, sizeof(DSBUFFERDESC) );

	// TCY
	BufDesc.dwSize   = sizeof(DSBUFFERDESC);  // Ksizeof(DSBUFFERDESC)
	// \͂w肷tO
	BufDesc.dwFlags   = DSBCAPS_PRIMARYBUFFER;	// vC}obt@w
	// 傫
	BufDesc.dwBufferBytes  = 0;							// TEhfoCXɈˑ
	// tH[}bg
	BufDesc.lpwfxFormat = NULL;				  // vC}obt@ł͎włȂ

	// - obt@LqqgāAobt@擾 -
	LPDIRECTSOUNDBUFFER   pPrimaryBuf = NULL;

	if( FAILED( pDSound->CreateSoundBuffer( &BufDesc, &pPrimaryBuf, NULL ) ) )
	{
		return DXTRACE_ERR( _T(""), GetLastError() );
	}


	// === tH[}bgݒ ===
	// - tH[}bg쐬 -
	WAVEFORMATEX pcmwf;
	ZeroMemory( &pcmwf, sizeof(WAVEFORMATEX) );

	// WAVEtH[}bg̎
	pcmwf.wFormatTag = WAVE_FORMAT_PCM;
	// `l
	pcmwf.nChannels = kPRM_BUF_CHANNELS;
	// TvO[gigj
	pcmwf.nSamplesPerSec = kPRM_BUF_FREQ;
	// rbg[g: 1Tṽrbg
	pcmwf.wBitsPerSample = kPRM_BUF_BITRATE;
	// ubNACg
	pcmwf.nBlockAlign = (pcmwf.wBitsPerSample / 8 * pcmwf.nChannels);
	// 1bԂɓ]oCg
	pcmwf.nAvgBytesPerSec = (pcmwf.nSamplesPerSec * pcmwf.nBlockAlign);

	// - tH[}bgZbg -
	HRESULT hr;
	if( FAILED( hr = pPrimaryBuf->SetFormat( &pcmwf ) ) )
	{
		my_safe_rel( pPrimaryBuf );
		return DXTRACE_ERR( _T(""), E_FAIL );
	}

	// - vC}obt@ւ̃|C^ -
	my_safe_rel( pPrimaryBuf );

	return S_OK;
}


/**
 * InitDSound̓֐
 * I3DXi̎擾
 * 
 * @param pp3DListener
 * 
 * @return 
 */
HRESULT CSound::GetI3DListener(
	LPDIRECTSOUND3DLISTENER* pp3DListener
	)
{
	// === DirectSoundĂȂAȂG[ ===
	if( ( pp3DListener == NULL ) || ( m_pDSound == NULL ) )
	{
		return DXTRACE_ERR( _T(""), E_FAIL );
	}


	// === vC}obt@擾A3DRg[\ł邩mF ===
	// - obt@Lqqݒ肷 -
	DSBUFFERDESC BufDesc;
	ZeroMemory( &BufDesc, sizeof(DSBUFFERDESC) );

	// TCY
	BufDesc.dwSize     = sizeof(DSBUFFERDESC);
	// \͂w肷tO
	BufDesc.dwFlags = DSBCAPS_PRIMARYBUFFER	 // vC}obt@w
					  | DSBCAPS_CTRL3D;					// 3DRg[\


	// - obt@擾A܂3DRg[͉\m߂ -
	LPDIRECTSOUNDBUFFER   pPrimaryBuf = NULL;
	if( FAILED( m_pDSound->CreateSoundBuffer( &BufDesc, &pPrimaryBuf, NULL ) ) )
	{
		return DXTRACE_ERR( _T(""), GetLastError() );
	}


	// === I3DXi̎擾 ===
	*pp3DListener = NULL;
	if( FAILED( pPrimaryBuf->QueryInterface(
			IID_IDirectSound3DListener,
			(void**)pp3DListener
			) ) )
	{
		my_safe_rel( pPrimaryBuf );
		return DXTRACE_ERR( _T(""), GetLastError() );
	}

	// - vC}obt@ւ̃|C^ -
	my_safe_rel( pPrimaryBuf );

	return S_OK;
}


/**
 * Wavet@CɁAZJ_obt@쐬
 * 
 * @param WvName
 * @param Flags
 * @param dwNofBufs
 * @param pSnd
 */
void CSound::LoadFile(
	LPCWSTR  WvName,
	u32     Flags,
	u32     dwNofBufs,
	theSound* pSnd
	)
{
	// === Jn ===
	// - G[`FbN -
	ASSERT( WvName );
	ASSERT( dwNofBufs > 0 );

	// -  -
	InitTheSound( pSnd );

	// === Wavet@C̓ǂݍ ===
	// - pX̐ -
#if 0
	std::string PathWv;
	std::string tmp1( ".\\" ), tmp2( kWV_PATH ), tmp3( "\\" ), tmp4( WvName );
	PathWv = tmp1 + tmp2 + tmp3 + tmp4;
#endif

	// - ǂݍ -
	if( FAILED( wvfile.Open( CCAST< LPWSTR >( WvName ), &pSnd->WvData ) ) )
	{
#if 0
		std::string MsgErr;
		std::string tmp1( "Wavet@Cw" ), tmp2( WvName ),
		tmp3( "x܂ł" );
		MsgErr = tmp1 + tmp2 + tmp3;
		MessageBox( NULL, (LPWSTR)MsgErr.c_str(), _T("Error"), MB_OK );
#endif
		return;
	}

	// === ZJ_obt@̍쐬 ===
	// - obt@Lqq̍쐬 -
	DSBUFFERDESC BufDesc;
	ZeroMemory( &BufDesc, sizeof(DSBUFFERDESC) );

	// TCY
	BufDesc.dwSize  = sizeof(DSBUFFERDESC);
	// tO
	BufDesc.dwFlags = Flags;
	// obt@TCY
	BufDesc.dwBufferBytes = pSnd->WvData.DataInfo.cksize;  // Wavet@C̃f[^Ɠ
	// RIFFt@CɓĂPCMtH[}bg
	BufDesc.lpwfxFormat = &(pSnd->WvData.WvFormatEx);

	// - i[obt@̊m -
	std::vector<LPDIRECTSOUNDBUFFER> DSBufs(dwNofBufs);

	// - obt@̍쐬 -
	HRESULT hr;
	if( FAILED( hr = m_pDSound->CreateSoundBuffer( &BufDesc,
												   (LPDIRECTSOUNDBUFFER* )&(DSBufs.at(0)), NULL ) ) )
	{
		DEBUG_BREAK();
	}

	// - obt@̕ -
	std::vector<LPDIRECTSOUNDBUFFER>::iterator it = DSBufs.begin();
	for( ; it != DSBufs.end() ; ++it )
	{
		if( FAILED( m_pDSound->DuplicateSoundBuffer( DSBufs.at(0), &(*it) ) ) )
		{
			DEBUG_BREAK();
		}
	}

	// - obt@̐theSound\̂ɋL^ -
	pSnd->WvData.dwNofBufs = dwNofBufs;

	// - i[obt@̏theSound\̂ɋL^ -
	// ̈m
	pSnd->ppDSBuf = new LPDIRECTSOUNDBUFFER[dwNofBufs];
	// Rs[
	for( u32 i=0; i<dwNofBufs; ++i )
	{
		pSnd->ppDSBuf[i] = DSBufs.at(i);
	}

	// - obt@ɃTEhf[^o -
	fillup_sound_buffer( pSnd, 0 );
}


/**
 * CreateSoundData̓֐
 * pSndNumBufԖڂDSobt@ɔg`f[^ǂݍ
 * 
 * @param pSnd
 * @param NumBuf
 * 
 * @return 
 */
HRESULT CSound::fillup_sound_buffer(
	theSound* pSnd,
	u32     NumBuf
	)
{
	// === G[`FbN ===
	if( pSnd->ppDSBuf[NumBuf] == NULL )
	{
		return E_FAIL;
	}


	// === obt@mFAΕ݂ ===
	if( FAILED( restore_ds_buffer( pSnd->ppDSBuf[NumBuf], NULL ) ) )
	{
		return DXTRACE_ERR( _T("FAIL:RestoreBuffer"), GetLastError() );
	}


	// === obt@bN ===
	VOID* pLockBuf = NULL;
	DWORD LockSz   = 0;

	if( FAILED( pSnd->ppDSBuf[NumBuf]->Lock( 0, pSnd->WvData.DataInfo.cksize,
											 &pLockBuf, &LockSz, NULL, NULL, 0L ) ) )
	{
		return DXTRACE_ERR( _T("FAIL:Lock"), GetLastError() );
	}


	// === Wavet@C̓o ===
	if( FAILED( wvfile.Rewind( &pSnd->WvData ) ) )
	{
		return DXTRACE_ERR( _T("FAIL:Rewind"), GetLastError() );
	}


	// === Wavet@C̃TEhf[^DSobt@ɓǂݏo ===
	u32 ReadedSz = 0;

	if( FAILED( wvfile.Read( &pSnd->WvData, LockSz,
							 (BYTE*)pLockBuf, &ReadedSz ) ) )
	{
		return DXTRACE_ERR( _T("FAIL:Read"), GetLastError() );
	}

	// - g`f[^ -
	if( ReadedSz == 0 )
	{
		// Ŗ߂
		FillMemory( (BYTE*) pLockBuf, LockSz, 
					(BYTE)( pSnd->WvData.WvFormatEx.wBitsPerSample == 8 ? 128 : 0 )
					);
	}
	// - g`f[^Z -
	else if( ReadedSz < LockSz )
	{
		// c𖳉Ŗ߂
		FillMemory( (BYTE*) pLockBuf + ReadedSz, LockSz - ReadedSz, 
					(BYTE)( pSnd->WvData.WvFormatEx.wBitsPerSample == 8 ? 128 : 0 )
					);
	}


	// === obt@AbN ===
	if( FAILED( pSnd->ppDSBuf[NumBuf]->Unlock( pLockBuf, LockSz, NULL, 0 ) ) )
	{
		return DXTRACE_ERR( _T("FAIL:Unlock"), GetLastError() );
	}


	return S_OK;
}


/**
 * fillup_sound_buffer̓֐
 * DSobt@ĂȂmFAĂ畜
 * 
 * @param pDSBuf
 * @param pDone
 * 
 * @return 
 */
HRESULT CSound::restore_ds_buffer(
	LPDIRECTSOUNDBUFFER pDSBuf,
	bool*               pDone
	)
{
	// === Jn ===
	// - G[`FbN -
	ASSERT( pDSBuf );

	// - itO΁jZbg -
	if( pDone != NULL )
	{
		*pDone = false;
	}

	// === obt@̏ԂmF ===
	DWORD stat;
	if( FAILED( pDSBuf->GetStatus( &stat ) ) )
	{
		return DXTRACE_ERR( _T("FAIL:GetStatus"), GetLastError() );
	}

	// === XgĂA݂ ===
	if( stat & DSBSTATUS_BUFFERLOST )
	{
		while( pDSBuf->Restore() == DSERR_BUFFERLOST )
		{
			Sleep(10);
		}

		// - ̂ŁAtOtrue -
		if( pDone != NULL )
		{
			*pDone = true;
		}
	}


	return S_OK;
}


/**
 * TEhĐ
 * 
 * @return 
 */
HRESULT CSound::PlaySound(
	theSound*	p_snd,
	u32		prio,
	u32		flag,
	BOOL		b_override
	)
{
	//if( !IsDebugSwitch( eDEBUG_SWITCH_MUTE_SE ) )
	{
		///gpłȂobt@T
		u32 NumFreeBuf;
		if( FAILED( SelectFreeBuffer( p_snd, b_override, &NumFreeBuf ) ) )
		{
			return DXTRACE_ERR( _T("FAIL:SelectFreeBuffer"), E_FAIL );
		}
	
		//gpłȂobt@Ȃ珈I
		if( NumFreeBuf == -1 )
		{
			return S_FALSE;
		}
	
		///obt@ĂȂmF
		bool bRestored;
	
		ASSERT( p_snd->ppDSBuf[ NumFreeBuf ] );
		if( FAILED( restore_ds_buffer( p_snd->ppDSBuf[NumFreeBuf], &bRestored ) ) )
		{
			return DXTRACE_ERR( _T("FAIL:RestoreDSBuf"), GetLastError() );
		}
	
		//Ăꍇ͕݂
		if( bRestored )
		{
			if( FAILED( fillup_sound_buffer( p_snd, NumFreeBuf ) ) )
			{
				return DXTRACE_ERR( _T("FAIL:FillupSoundBuffer"), GetLastError() );
			}
		}
	
		///obt@̃TEhĐ
		if( FAILED( p_snd->ppDSBuf[NumFreeBuf]->Play( 0, prio, flag ) ) )
		{
			return DXTRACE_ERR( _T("FAIL:Play"), GetLastError() );
		}
	}

	return S_OK;
}


/**
 * PlaySounds̓֐
 * ĐłȂobt@
 * 
 * @param pSnd
 * @param Override
 * @param pNumFreeBuf
 * 
 * @return 
 */
HRESULT CSound::SelectFreeBuffer(
	theSound*	pSnd,
	BOOL		Override,
	u32*		pNumFreeBuf
	)
{
	// === G[`FbN ===
	ASSERT( pSnd->ppDSBuf[0] );	//wavt@C̃TCY傫邩

	// === ĐłȂobt@T ===
	for( u32 i=0; i< pSnd->WvData.dwNofBufs; i++ )
	{
		if( pSnd->ppDSBuf[i] != NULL )
		{
			DWORD stat;

			if( FAILED( pSnd->ppDSBuf[i]->GetStatus( &stat ) ) )
			{
				return DXTRACE_ERR( _T("GetStatus"), GetLastError() );
			}

			if( ( stat & DSBSTATUS_PLAYING ) == 0 )
			{
				*pNumFreeBuf = i;  return S_OK;
			}
		}
	}

	// === ĐłȂobt@Ȃ ===
	// - ㏑tOĂ΁A_őI -
	if( Override )
	{
		*pNumFreeBuf = rand() % ( pSnd->WvData.dwNofBufs );

		// I񂾃obt@~A߂
		pSnd->ppDSBuf[*pNumFreeBuf]->Stop();
		pSnd->ppDSBuf[*pNumFreeBuf]->SetCurrentPosition(0);

		return S_OK;
	}

	// - i[āA֐o -
	*pNumFreeBuf = (u32)-1;  return S_FALSE;
}


/**
 * TEh~
 * 
 * @param pSnd
 * 
 * @return 
 */
HRESULT CSound::StopSound(
	theSound *pSnd
	)
{
	ASSERT( pSnd );

	// === Đ̃obt@TāA~A߂ ===
	bool boDone = false;
	u32 dwNofBufs = pSnd->WvData.dwNofBufs;
	LPDIRECTSOUNDBUFFER* ppDSBuf = pSnd->ppDSBuf;

	for( UINT iNumBuf=0; iNumBuf< dwNofBufs; iNumBuf++ )
	{
		if( ppDSBuf[iNumBuf] != NULL )
		{
			DWORD stat;

			if( FAILED( ppDSBuf[iNumBuf]->GetStatus( &stat ) ) )
			{
				return DXTRACE_ERR( _T("GetStatus"), GetLastError() );
			}

			if( (stat & DSBSTATUS_PLAYING) != 0 )
			{
				ppDSBuf[iNumBuf]->Stop();
				ppDSBuf[iNumBuf]->SetCurrentPosition(0);
				boDone = true;
			}
		}
	}

	// === lԂ ===
	return boDone? S_OK: S_FALSE;
}


/**
 * theSound\̂̏
 * 
 * @param pSnd
 */
void CSound::InitTheSound(
	theSound*	pSnd
	)
{
	ASSERT( pSnd );
	
	// ===  ===
	pSnd->WvData.dwCreatFlag	= 0;
	pSnd->WvData.dwNofBufs		= (u32)-1;

	pSnd->ppDSBuf	= NULL;

	pSnd->pp3DBuf		= NULL;
	pSnd->p3DBufParams	= NULL;
}


/**
 * theSound\̂̃[Zbg
 * 
 * @param pSnd
 */
void CSound::ZeroTheSound(
	theSound*	pSnd
	)
{
	// === G[`FbN@--- */
	ASSERT( pSnd );

	// === [Zbg ===
	pSnd->WvData.dwCreatFlag	= 0;
	pSnd->WvData.dwNofBufs		= 0;

	pSnd->ppDSBuf	= NULL;

	pSnd->pp3DBuf		= NULL;
	pSnd->p3DBufParams	= NULL;
}


/**
 * theSound\̂̉
 * 
 * @param pSnd
 */
void	CSound::ReleaseTheSound(
	theSound*	pSnd
	)
{
	ASSERT( pSnd );

	delete[] pSnd->ppDSBuf;
	delete[] pSnd->pp3DBuf;
	delete[] pSnd->p3DBufParams;

	///t@C
	if( FAILED( wvfile.Close( &pSnd->WvData ) ) )
	{
		DEBUG_BREAK();
	}
}
