/***************************************************************************/
/** @file       input_raw_keyboard.h
	@brief      L[{[h͎tNX̐錾
	@author     shom
	@internal
****************************************************************************/

#ifdef DIK_KEY__INPUT_RAW_KEYBOARD

DIK_KEY__INPUT_RAW_KEYBOARD( 0xc8,	DIR_UP		)
DIK_KEY__INPUT_RAW_KEYBOARD( 0x48,	DIR_UP		)
DIK_KEY__INPUT_RAW_KEYBOARD( 0xd0,	DIR_DOWN	)
DIK_KEY__INPUT_RAW_KEYBOARD( 0x50,	DIR_DOWN	)
DIK_KEY__INPUT_RAW_KEYBOARD( 0xcb,	DIR_LEFT	)
DIK_KEY__INPUT_RAW_KEYBOARD( 0x4b,	DIR_LEFT	)
DIK_KEY__INPUT_RAW_KEYBOARD( 0xcd,	DIR_RIGHT	)
DIK_KEY__INPUT_RAW_KEYBOARD( 0x4d,	DIR_RIGHT	)
DIK_KEY__INPUT_RAW_KEYBOARD( 0x2a,	SHIFT		)
DIK_KEY__INPUT_RAW_KEYBOARD( 0x36,	SHIFT		)

#endif	//DIK_KEY__INPUT_RAW_KEYBOARD

#ifdef DIK__INPUT_RAW_KEYBOARD

DIK__INPUT_RAW_KEYBOARD( W	)
DIK__INPUT_RAW_KEYBOARD( S	)
DIK__INPUT_RAW_KEYBOARD( A	)
DIK__INPUT_RAW_KEYBOARD( D	)
DIK__INPUT_RAW_KEYBOARD( Z	)
DIK__INPUT_RAW_KEYBOARD( X	)
DIK__INPUT_RAW_KEYBOARD( C	)
DIK__INPUT_RAW_KEYBOARD( V	)
DIK__INPUT_RAW_KEYBOARD( RETURN	)
DIK__INPUT_RAW_KEYBOARD( SPACE	)

#endif	//DIK__INPUT_RAW_KEYBOARD


#ifndef __INPUT_RAW_KEYBOARD_H__
#define __INPUT_RAW_KEYBOARD_H__


#include "input_raw_base.h"


class cinput_raw_keyboard
:
public cinput_raw_base
{
public:
#ifdef DX
	cinput_raw_keyboard( LPDIRECTINPUT8 p_dinput );
#else	//if GL		
	cinput_raw_keyboard();
#endif

#ifdef DX
	virtual b32 Initialize( HWND h_wnd );
#else	//if GL
	virtual b32 Initialize();
#endif

	virtual void Finalize();

	u32	GetState()	const;
};

#endif	//__INPUT_RAW_KEYBOARD_H__
