/***************************************************************************/
/** @file       mm_shape.cpp
    @brief      Zp֐
    @author     shom
****************************************************************************/

#include "pch.h"

#include "mm_shape.h"


/***************************************************************************
	mm::ellipse_t
****************************************************************************/

mm::ellipse_t::ellipse_t()
:
m_v_pos( mm::zero_v2() ),
m_v_dir( mm::zero_v2() ),
m_half_length_of_major_axis( 0.0f ),
m_dist_center_to_focus( 0.0f ),

m_v2_pos_focus_tbl(),

m_degree_of_spread( 0.0f )

#ifdef _DEBUG
,m_p_buf_vertex( NULL )//,
#endif
{
	for( u32 i=0; i<ELEMENTSOF( m_v2_pos_focus_tbl ); ++i )
	{
		mm::zero_v( m_v2_pos_focus_tbl[i] );
	}
}

#ifdef _DEBUG
mm::ellipse_t::~ellipse_t()
{
	my_safe_rel( m_p_buf_vertex );
}
#endif

void	mm::ellipse_t::SetPos( const vec2f& v2_pos )
{
	m_v_pos = v2_pos;
}

void	mm::ellipse_t::SetDir( const vec2f& v2_dir )
{
	m_v_dir = v2_dir;
}

void	mm::ellipse_t::SetLengthOfMajorAxis( f32 length )
{
	m_half_length_of_major_axis = length / 2.0f;

	SetAngleOfSpread( m_degree_of_spread );
}

void	mm::ellipse_t::SetAngleOfSpread( f32 degree )
{
	m_degree_of_spread = degree;

	const f32 rad = mm::degree_to_radian( degree );

	m_dist_center_to_focus =
		m_half_length_of_major_axis *
		mm::sqrt( 1.0f - mm::square( tan( rad ) ) );
}

void	mm::ellipse_t::GetFocusPoint( vec2f& v2_out, b32 b_near )	const
{
	const f32 scale_dir =
		m_half_length_of_major_axis +
		m_dist_center_to_focus * ( b_near ? -1.0f : 1.0f );

	v2_out = m_v_pos + m_v_dir * scale_dir;
}

f32		mm::ellipse_t::GetLengthOfMinorAxis()	const
{
	const f32 length_of_minor_axis_sq =
		mm::square( m_half_length_of_major_axis ) -
		mm::square( m_dist_center_to_focus );

	return ( mm::sqrt( length_of_minor_axis_sq ) * 2.0f );
}

b32		mm::ellipse_t::IsIncluded( const vec2f& v2_pos )	const
{
	vec2f v_focus_near, v_focus_far;
	GetFocusPoint( v_focus_near, TRUE );
	GetFocusPoint( v_focus_far, FALSE );

	const f32 dist_to_focus_near = mm::length( v2_pos - v_focus_near );
	const f32 dist_to_focus_far  = mm::length( v2_pos - v_focus_far );
	const f32 dist_sum = dist_to_focus_near + dist_to_focus_far;

	return ( dist_sum <= m_half_length_of_major_axis * 2.0f );
}

#ifdef _DEBUG
void	mm::ellipse_t::Draw( LPDIRECT3DDEVICE9 p_device, u32 color )
{
	if( !m_p_buf_vertex )
	{
		p_device->CreateVertexBuffer(
			sizeof( vertex_t ) * sc_length_of_vertex_list,
			D3DUSAGE_WRITEONLY, sc_fvf, D3DPOOL_MANAGED,
			&m_p_buf_vertex, NULL
			);
	}

	///--
	const vec2f v_dir_cross = mm::get_v( -m_v_dir.y, m_v_dir.x );

	const vec2f v_left_top =
		m_v_pos +
		m_v_dir * m_half_length_of_major_axis * 2.0f -
		v_dir_cross * GetLengthOfMinorAxis() / 2.0f;
	const vec2f v_right_top =
		m_v_pos +
		m_v_dir * m_half_length_of_major_axis * 2.0f +
		v_dir_cross * GetLengthOfMinorAxis() / 2.0f;
	const vec2f v_left_bottom =
		m_v_pos -
		v_dir_cross * GetLengthOfMinorAxis() / 2.0f;
	const vec2f v_right_bottom =
		m_v_pos +
		v_dir_cross * GetLengthOfMinorAxis() / 2.0f;

	const vec2f v_mid_lt_rt = mm::mid_point( v_left_top, v_right_top );
	const vec2f v_mid_rt_rb = mm::mid_point( v_right_top, v_right_bottom );
	const vec2f v_mid_rb_lb = mm::mid_point( v_right_bottom, v_left_bottom );
	const vec2f v_mid_lb_lt = mm::mid_point( v_left_bottom, v_left_top );

	const vec2f v_intpol_rt =
		mm::mid_point(
			mm::mid_point( v_mid_lt_rt, v_right_top ),
			mm::mid_point( v_mid_rt_rb, v_right_top )
			);
	const vec2f v_intpol_rb =
		mm::mid_point(
			mm::mid_point( v_mid_rt_rb, v_right_bottom ),
			mm::mid_point( v_mid_rb_lb, v_right_bottom )
			);
	const vec2f v_intpol_lb =
		mm::mid_point(
			mm::mid_point( v_mid_rb_lb, v_left_bottom ),
			mm::mid_point( v_mid_lb_lt, v_left_bottom )
			);
	const vec2f v_intpol_lt =
		mm::mid_point(
			mm::mid_point( v_mid_lb_lt, v_left_top ),
			mm::mid_point( v_mid_lt_rt, v_left_top )
			);

	const vertex_t vertex_tbl[] =
	{
		{ v_mid_lt_rt.x,	v_mid_lt_rt.y,	0.0f, 1.0f, color },
		{ v_intpol_rt.x,	v_intpol_rt.y,	0.0f, 1.0f, color },
		{ v_mid_rt_rb.x,	v_mid_rt_rb.y,	0.0f, 1.0f, color },
		{ v_intpol_rb.x,	v_intpol_rb.y,	0.0f, 1.0f, color },
		{ v_mid_rb_lb.x,	v_mid_rb_lb.y,	0.0f, 1.0f, color },
		{ v_intpol_lb.x,	v_intpol_lb.y,	0.0f, 1.0f, color },
		{ v_mid_lb_lt.x,	v_mid_lb_lt.y,	0.0f, 1.0f, color },
		{ v_intpol_lt.x,	v_intpol_lt.y,	0.0f, 1.0f, color },
		{ v_mid_lt_rt.x,	v_mid_lt_rt.y,	0.0f, 1.0f, color },
	};
	STATIC_ASSERT( ELEMENTSOF( vertex_tbl ) == sc_length_of_vertex_list );
	///--

	///--
	void *p_written = NULL;
	m_p_buf_vertex->Lock(
		0,
		sizeof( vertex_t ) * sc_length_of_vertex_list,
		SCAST< void** >( &p_written ),
		0
		);

	memcpy(
		p_written,
		vertex_tbl,
		sizeof( vertex_t ) * sc_length_of_vertex_list
		);

	m_p_buf_vertex->Unlock();
	///--

	///--
	#define STSS p_device->SetTextureStageState

	STSS( 0	, D3DTSS_COLORARG2	, D3DTA_DIFFUSE		);
	STSS( 0	, D3DTSS_COLOROP	, D3DTOP_SELECTARG2	);
	STSS( 0	, D3DTSS_ALPHAARG2	, D3DTA_DIFFUSE		);
	STSS( 0	, D3DTSS_ALPHAOP	, D3DTOP_SELECTARG2	);

	#undef STSS

	#define SRS p_device->SetRenderState

	SRS( D3DRS_ALPHABLENDENABLE	, FALSE	);

	#undef SRS
	///--

	///--
	p_device->SetStreamSource( 0, m_p_buf_vertex, 0, sizeof( vertex_t ) );
	p_device->SetFVF( sc_fvf );

	p_device->
		DrawPrimitive( D3DPT_LINESTRIP, 0, sc_length_of_vertex_list - 1 );
	///--
}
#endif

