/***************************************************************************/
/** @file       input_raw_mouse.cpp
	@brief      L[{[ht
	@author     shom
	@internal
****************************************************************************/

#include "pch_core.h"

#include "input_raw_mouse.h"

#include "core/input/input_mouse_def.h"


using namespace input_mouse_def;


/***************************************************************************
	cinput_raw_mouse
****************************************************************************/

cinput_raw_mouse::cinput_raw_mouse( LPDIRECTINPUT8 p_dinput )
:
cinput_raw_base( p_dinput ),

m_h_wnd()//,
{
}

/**
 * NX̊Jn
 */
b32		cinput_raw_mouse::Initialize( HWND h_wnd )
{
	m_h_wnd = h_wnd;

	///--	foCX
	const HRESULT hr =
		m_p_dinput->CreateDevice( GUID_SysMouse, &m_p_device, NULL );
	if( FAILED( hr ) || !m_p_device )
	{
		DEBUG_BREAK();
		return FALSE;
	}
	///--

	///--	󂯎f[^tH[}bgݒ
	if( FAILED( m_p_device->SetDataFormat( &c_dfDIMouse ) ) )
	{
		DEBUG_BREAK();
		return FALSE;
	}
	///--

	///--	[hݒ
	if( FAILED( m_p_device->SetCooperativeLevel(
					h_wnd,
					DISCL_NONEXCLUSIVE	// tHAOEh[h
					| DISCL_FOREGROUND	// r[h
					) ) )
	{
		DEBUG_BREAK();
		return FALSE;
	}
	///--

#if !1
	///--
	DIPROPDWORD diprop;
	my_memzero( &diprop, sizeof( diprop ) );
	diprop.diph.dwSize		 = sizeof( diprop );
	diprop.diph.dwHeaderSize = sizeof( diprop.diph );
	diprop.diph.dwObj		 = 0;
	diprop.diph.dwHow		 = DIPH_DEVICE;
	diprop.dwData			 = DIPROPAXISMODE_ABS;

	if( FAILED( m_p_device->SetProperty( DIPROP_AXISMODE, &diprop.diph ) ) )
	{
		DEBUG_BREAK();
		return FALSE;
	}
	///--
#endif

	return ( cinput_raw_base::Initialize( h_wnd ) );
}

void	cinput_raw_mouse::Finalize()
{
}

/**
 * }EX̏Ԃ擾
 * ͂F
 */
b32		cinput_raw_mouse::GetState( vec2f& out_pos, u32& out_state )
{
#if 0
	if( !window::IsWindowActive() || window::IsMessageBoxAppearing() )
	{
		return FALSE;
	}
#endif

	if( !m_p_device )
	{
		return FALSE;
	}

	///--
	DIMOUSESTATE dims;
	my_memzero( &dims, sizeof( DIMOUSESTATE ) );

	if( FAILED( m_p_device->GetDeviceState( sizeof(dims), &dims ) ) )
	{
		// ͂ĂꍇAmۂAێ݂B
		while( true )
		{
			const HRESULT hr = m_p_device->Acquire();
			if( hr != DIERR_INPUTLOST )
			{
				if( FAILED( hr ) )
				{
					return FALSE;
				}

				break;
			}
		}
	}
	///--

	///--
	POINT	pos_client;
	GetCursorPos( &pos_client );
	ScreenToClient( m_h_wnd, &pos_client );
	///--

	///--
	out_pos.x = SCAST< f32 >( pos_client.x );
	out_pos.y = SCAST< f32 >( pos_client.y );;

	out_state = MOUSE_BUTTON_NONE;
	if( dims.rgbButtons[0] != 0 ) { out_state |= MOUSE_BUTTON_LEFT; }
	if( dims.rgbButtons[1] != 0 ) { out_state |= MOUSE_BUTTON_RIGHT; }
	if( dims.rgbButtons[2] != 0 ) { out_state |= MOUSE_BUTTON_CENTER; }
	///--

	return TRUE;
}

