/***************************************************************************/
/** @file       input_raw_base.cpp
	@brief      L[{[ht
	@author     shom
	@internal
****************************************************************************/

#include "pch_core.h"

#include "input_raw_base.h"


/***************************************************************************
	cinput_raw_base
****************************************************************************/

cinput_raw_base::cinput_raw_base(
#ifdef DX
	LPDIRECTINPUT8 p_dinput
#endif
	)
#ifdef DX
:
m_p_dinput( p_dinput ),

m_p_device( NULL )//,
#endif
{
}

cinput_raw_base::~cinput_raw_base()
{
	release_all();
}

/**
 * NX̊Jn
 */
b32		cinput_raw_base::Initialize(
#ifdef DX
	HWND h_wnd
#endif
	)
{
#ifdef DX
	UNUSED( h_wnd );
#endif

	RestartDevice();

	return TRUE;
}

/**
 * foCXɂȂĂ΁AA
 */
void	cinput_raw_base::RestartDevice()
{
#ifdef DX
	///foCXL
	if( m_p_device )
	{
		m_p_device->Acquire();
	}
#endif
}

/**
 * IuWFNg̉
 */
void	cinput_raw_base::release_all()
{
#ifdef DX
	if( m_p_device )
	{
		m_p_device->Unacquire();
	}
	my_safe_rel( m_p_device );
#endif
}

