/***************************************************************************/
/** @file       input_mouse.h
    @brief      
    @author     shom
    @internal
----------------------------------------------------------------------------
    $id
****************************************************************************/

#pragma once

#include "input_base.h"

#include "input_mouse_def.h"


class cinput_mouse
:
public cinput_base
{
///--	methods
public:
	cinput_mouse(
#ifdef DX
		LPDIRECTINPUT8 p_dinput
#endif
		);

	void	Update();
	
	b32		IsPush( input_mouse_def::eMOUSE_BUTTON e_button )		const;
	b32		IsPull( input_mouse_def::eMOUSE_BUTTON e_button )		const;
private:	//--	inner function
	b32		is_prev_on( input_mouse_def::eMOUSE_BUTTON e_button )	const;
	b32		is_prev_off( input_mouse_def::eMOUSE_BUTTON e_button )	const;
public:		//--
	b32		IsPushing( input_mouse_def::eMOUSE_BUTTON e_button )	const;

	const vec2f&	GetPos()	const;
	b32		IsOnTheArea(
		const vec2f& v2_pos_area,
		const vec2f& v2_size_area
		)	const;
///--

///--	variables
private:
	b32		m_state_prev;
	b32		m_state_cur;

	vec2f	m_v2_pos_cur;
///--
};


