/***************************************************************************/
/** @file       input_keyboard_def.h
	@brief      L[{[h̏Ԃ\萔̒`
	@author     shom
	@internal
****************************************************************************/

#pragma once

///L[{[h̏
class cinput_keyboard_def
{
private:
	enum eKEY
	{
		eKEY_DIR_UP,
		eKEY_DIR_RIGHT,
		eKEY_DIR_DOWN,
		eKEY_DIR_LEFT,
	
		eKEY_W,
		eKEY_S,
		eKEY_A,
		eKEY_D,
	
		eKEY_Z,
		eKEY_X,
		eKEY_C,
		eKEY_V,
	
		eKEY_RETURN,
		eKEY_SPACE,
		eKEY_SHIFT,
		eKEY_DELBS,
	
		eNOF_KEY,
	
		eKEY_ERR,
	};

public:
	enum{ key_dir_up	= 1<<eKEY_DIR_UP };
	enum{ key_dir_right	= 1<<eKEY_DIR_RIGHT };
	enum{ key_dir_down	= 1<<eKEY_DIR_DOWN };
	enum{ key_dir_left	= 1<<eKEY_DIR_LEFT };
	
	enum{ key_w			= 1<<eKEY_W };
	enum{ key_s			= 1<<eKEY_S };
	enum{ key_a			= 1<<eKEY_A };
	enum{ key_d			= 1<<eKEY_D };
	
	enum{ key_z			= 1<<eKEY_Z };
	enum{ key_x			= 1<<eKEY_X };
	enum{ key_c			= 1<<eKEY_C };
	enum{ key_v			= 1<<eKEY_V };
	
	enum{ key_return	= 1<<eKEY_RETURN };
	enum{ key_space		= 1<<eKEY_SPACE };
	enum{ key_shift		= 1<<eKEY_SHIFT };
	enum{ key_delbs		= 1<<eKEY_DELBS };

	enum{ key_err		= 1<<eKEY_ERR };
	
	enum{ key_mask_dir	=
		key_dir_up | key_dir_right| key_dir_down | key_dir_left };
};

namespace input_keyboard_def
{
	enum{ KEY_NONE		= 0 };

	enum{ KEY_DIR_UP	= cinput_keyboard_def::key_dir_up };
	enum{ KEY_DIR_RIGHT	= cinput_keyboard_def::key_dir_right };
	enum{ KEY_DIR_DOWN	= cinput_keyboard_def::key_dir_down };
	enum{ KEY_DIR_LEFT	= cinput_keyboard_def::key_dir_left };
	
	enum{ KEY_W			= cinput_keyboard_def::key_w };
	enum{ KEY_S			= cinput_keyboard_def::key_s };
	enum{ KEY_A			= cinput_keyboard_def::key_a };
	enum{ KEY_D			= cinput_keyboard_def::key_d };
	
	enum{ KEY_Z			= cinput_keyboard_def::key_z };
	enum{ KEY_X			= cinput_keyboard_def::key_x };
	enum{ KEY_C			= cinput_keyboard_def::key_c };
	enum{ KEY_V			= cinput_keyboard_def::key_v };
	
	enum{ KEY_RETURN	= cinput_keyboard_def::key_return };
	enum{ KEY_SPACE		= cinput_keyboard_def::key_space };
	
	enum{ KEY_SHIFT		= cinput_keyboard_def::key_shift };
	enum{ KEY_DELBS		= cinput_keyboard_def::key_delbs };
	
	enum{ KEY_ERR		= cinput_keyboard_def::key_err };
	
	enum{ KEY_MASK_DIR	= cinput_keyboard_def::key_mask_dir };
}

