/***************************************************************************/
/** @file       cinput_keyboard.h
    @brief      
    @author     shom
    @internal
----------------------------------------------------------------------------
    $id
****************************************************************************/

#pragma once

#include "input_base.h"


class cinput_keyboard
:
public cinput_base
{
public:
	#ifdef DX
	cinput_keyboard( LPDIRECTINPUT8 p_dinput );
	#else	//if GL
	cinput_keyboard();
	#endif

	void	Update();
	
	b32		IsPush( u32 in_key )	const	{ return ( GetPush( in_key ) != 0 ); }
	b32		IsPull( u32 in_key )	const	{ return ( GetPull( in_key ) != 0 ); }
	b32		IsPushing( u32 in_key )	const	{ return ( GetPushing( in_key ) != 0 ); }
	
	u32		GetPush( u32 in_key )		const;
	u32		GetPull( u32 in_key )		const;
	u32		GetPushing( u32 in_key )	const;

	b32		IsRepeat( u32 in_key, f32 in_tm_repeat )	const;

	void	RestartDevice();
	
private:
	u32		m_keystate_cur;
	u32		m_keystate_req;
};

