/***************************************************************************/
/** @file       board.h
    @brief      drawing the board-polygon
    @author     shom
****************************************************************************/

#pragma once

#include "board_def.h"

class crender;

#ifdef DX
struct IDirect3DVertexBuffer9;
#endif

class cboard
{
///--	method
public:
	cboard();
	virtual ~cboard();

	virtual b32		Initialize( crender* in_p_render );
	virtual void	Finalize();

	virtual void	Update( b32 b_force = FALSE );
private:	//--	inner function
	void	update_fade();
	void	update_vertex();
public:		//--
	virtual void	Draw( crender* in_p_render );

	virtual void			SetPos( const vec3f& in_v3_pos );
	virtual void			SetPos( const vec2f& in_v2_pos );
	virtual void			SetPos( f32 in_pos_x, f32 in_pos_y );
	virtual void			GetPos( vec3f& out_v3 )	const;
	virtual void			GetPos( vec2f& out_v2 )	const;

	virtual void			SetRot( f32 in_rad );
	virtual f32				GetRot()	const;

	virtual void			SetScale( f32 in_scale );
	virtual const vec3f&	GetScale()	const;

	virtual void			SetSize( const vec2f& v2_size );
	virtual void			GetSize( vec2f& out_v2 )	const;

	virtual void			SetUv( const vec2f& v2_uv_start, const vec2f& v2_uv_end );
	virtual const vec2f&	GetUvStart()	const;
	virtual const vec2f&	GetUvEnd()	const;

	virtual void			SetInverse( b32 in_b_inverse );
	virtual b32				GetInverse()	const;

	virtual void			SetColor( u32 color );
	virtual u32				GetColor()	const;

	virtual void			SetPivot( const vec2f& in_v2 );
	virtual const vec2f&	GetPivot()	const;

	virtual void			GetPosLeftTop( vec2f& out_v2 )	const;

	virtual void			FadeOut();
	virtual void			FadeIn();
	virtual b32				IsFadeOut()	const;
	virtual b32				IsFadeIn()	const;

private:
	void	release_all();
///--

///--	variable
protected:
	board_def::board_vertex_t	m_vertex_tbl[4];

private:
#ifdef DX
	IDirect3DVertexBuffer9*	m_p_buf_vertex;
#endif

	b32		m_b_changed;
	vec3f	m_v3_pos, m_v3_size;
	f32		m_rot_rad;
	vec3f	m_v3_scale;
	vec2f	m_v2_uv_start, m_v2_uv_end;
	b32		m_b_inverse;
	u32		m_color;
	vec2f	m_v2_pivot;
	b32		m_bFadeIn, m_bFadeOut;
///--
};
