/***************************************************************************/
/** @file       font_gdi.cpp
    @brief      font rendering by gdi
    @author     shom
    @internal
****************************************************************************/

#include "pch_core.h"

#include "font_gdi.h"

#include "core/graphic/render_dx.h"


/***************************************************************************
	Font
****************************************************************************/

cfont_gdi::cfont_gdi()
:
m_font_desc()//,
{
	SetDefault();
}

void	cfont_gdi::SetDefault()
{
	m_font_desc.Height	= 24;
	m_font_desc.Width	= 0;
	m_font_desc.Italic	= false;
	m_font_desc.CharSet	= SHIFTJIS_CHARSET;	//{gp
#if !1
	strncpy_s(
			 m_font_desc.FaceName,
			 _T( "lr " ),
			 sizeof( m_font_desc.FaceName ) * sizeof( char )
			 );
#endif	
}

void	cfont_gdi::SetSize( u32 height, u32 width )
{
	m_font_desc.Height	= height;
	m_font_desc.Width	= width;
}

void	cfont_gdi::SetStyle(
	b32 b_italic,
	b32 b_weight,
	b32 b_use_anci/*
	b32 b_shadow*/
	)
{
	m_font_desc.Italic	= b_italic;
	m_font_desc.Weight	= ( b_weight ) ? 1000 : 500;
	m_font_desc.CharSet	= ( b_use_anci ) ? ANSI_CHARSET : SHIFTJIS_CHARSET;
	//b_shadow;
}

void	cfont_gdi::Create( LPD3DXFONT* pp_out, crender* in_p_render )
{
	///_tHg̍쐬
	const HRESULT	hr =
		D3DXCreateFontIndirect(
			in_p_render->GetDevice(),
			&m_font_desc,
			pp_out
			);
	DBREAK_IF_FAILED( hr );
}

void	cfont_gdi::Draw(
	const	LPD3DXFONT		p_d3dx_font,
	const	LPCWSTR			sz_msg,
			RECT			rect,
			u32				color,
			b32				b_shadow,
	const	LPD3DXSPRITE	p_sprite
	)
{
	if( p_sprite )
	{
		p_sprite->Begin( D3DXSPRITE_ALPHABLEND | D3DXSPRITE_SORT_TEXTURE );	
	}

	if( b_shadow )
	{
		RECT rect_shadow = {0};	
		rect_shadow.left = rect.left + 2;
		rect_shadow.top  = rect.top  + 2;

		const HRESULT hr_shadow =
			p_d3dx_font->DrawText(
						p_sprite,
						sz_msg,
						-1,				//B-1ŎvZB
						&rect_shadow,	//`͈
						DT_NOCLIP,		//tH[}bg
						COLOR_BLACK
						);
		DBREAK_IF_FAILED( hr_shadow );
	}
	
	const HRESULT hr =
		p_d3dx_font->DrawText(
					p_sprite,
					sz_msg,
					-1,			//B-1ŎvZB
					&rect,		//`͈
					DT_NOCLIP,	//tH[}bg
					color
					);
	DBREAK_IF_FAILED( hr );

	if( p_sprite )
	{
		p_sprite->End();
	}
}
