/***************************************************************************/
/** @file       debug_dip.cpp
    @brief      sfobOXCb`
    @author     shom
    @internal
****************************************************************************/

#include "pch_core.h"

#include "debug_dip.h"


using namespace debug_dip;


namespace
{
	///--	define
	enum eCATEGORY
	{
	/**---------------------------------------------------------------------**/
	#define DEBUG_DIP_CATEGORY( _name )	\
	\
		eCATEGORY_##_name##,
	
	#include "core/debug/debug_dip/debug_dip_def.h"
	#undef DEBUG_DIP_CATEGORY
	/**---------------------------------------------------------------------**/
	
		eNOF_CATEGORY,
		eCATEGORY_INVALID
	};

	b32 s_bDipOnOff_tbl[ eNOF_DEBUG_DIP ] = {0};
	
	TCHAR* g_szDebugDipCategoryTbl[ eNOF_CATEGORY ] =
	{
		/**-------------------------------------------------------------------**/
		#define DEBUG_DIP_CATEGORY( _name )	\
		\
		_T( #_name ),
		
		#include "core/debug/debug_dip/debug_dip_def.h"
		#undef DEBUG_DIP_CATEGORY
		/**-------------------------------------------------------------------**/
	};
}


/***************************************************************************
	debug_dip( namespace )
****************************************************************************/

b32		debug_dip::IsDip( eDEBUG_DIP e_debug_dip )
{
	return s_bDipOnOff_tbl[ e_debug_dip ];
}

void	debug_dip::SetDip( eDEBUG_DIP e_debug_dip, b32 b_set )
{
	s_bDipOnOff_tbl[ e_debug_dip ] = b_set;
}


void	debug_dip::InitDip()
{
	TCHAR sz_path[128] = {0};
	GetCurrentDirectory( 128, sz_path );
	wsprintf( sz_path, _T( "%s\\%s" ), sz_path, _T( "debug_dip.ini" ) );

	/**-------------------------------------------------------------------**/
	#define DEBUG_DIP_ITEM( _category, _name, _msg )						\
																			\
	{																		\
		const u32 ret =														\
			GetPrivateProfileInt( _T( #_category ), _T( #_name ), 0, sz_path );	\
																			\
		SetDip( eDEBUG_DIP_##_name##, ( ret != 0 ) );						\
	}

	#include "core/debug/debug_dip/debug_dip_def.h"
	#undef DEBUG_DIP_ITEM
	/**-------------------------------------------------------------------**/
};

void	debug_dip::FinDip()
{
	TCHAR sz_path[128] = {0};
	GetCurrentDirectory( 128, sz_path );
	wsprintf( sz_path, _T( "%s\\%s" ), sz_path, _T( "debug_dip.ini" ) );

	tstring	str_text[ eNOF_CATEGORY ];
	/**-------------------------------------------------------------------**/
	#define DEBUG_DIP_ITEM( _category, _name, _msg )	\
														\
	{													\
		TCHAR sz_unit[256] = {0};						\
		const b32 b_on = IsDip( eDEBUG_DIP_##_name## );	\
		wsprintf(										\
			sz_unit,									\
			_T( "%s = %d\n" ),							\
			_T( #_name ),								\
			static_cast<UINT>( b_on )					\
			);											\
														\
		str_text[ eCATEGORY_##_category ] += sz_unit;	\
														\
	}

	#include "core/debug/debug_dip/debug_dip_def.h"
	#undef DEBUG_DIP_ITEM
	/**-------------------------------------------------------------------**/

	for( u32 i=0; i<eNOF_CATEGORY; ++i )
	{
		TCHAR sz_temp[256] = {0};
		_tcsncpy_s( sz_temp, str_text[i].c_str(), 255 );
		sz_temp[ _tcscnlen( sz_temp, 256 ) - 1 ] = '\0';
		//Ō̉sNULLA

		const b32 ret =
			WritePrivateProfileSection(
				g_szDebugDipCategoryTbl[i],
				sz_temp, sz_path
				);
	
		VERIFY( ret );
	}
};

