/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package textkeymatcher.service;

import org.apache.commons.lang3.StringUtils;
import textkeymatcher.entity.Columns;
import textkeymatcher.entity.LineData;

/**
 * 既定の文字列行から行データを構築するラインデータビルダー.<br>
 * @author seraphy
 */
public class DefaultLineDataBuilder implements LineDataBuilder {

    /**
     * 列を切り出すスプリッタ
     */
    private ColumnSplitter splitter;
    
    /**
     * キーの列位置
     */
    private int keyColumn;
    
    /**
     * 値の列位置
     */
    private int valueColumn;

    
    public DefaultLineDataBuilder(ColumnSplitter splitter, int keyColumn, int valueColumn) {
        if (splitter == null) {
            throw new IllegalArgumentException();
        }
        this.splitter = splitter;
        this.keyColumn = keyColumn;
        this.valueColumn = valueColumn;
    }

    @Override
    public LineData parse(String line) {
        Columns cols = splitter.splitColumns(line);

        // キー列の取得
        String key;
        if (keyColumn >= 0) {
            key = cols.getAt(keyColumn);
        } else {
            key = line;
        }
        
        // 列数1以下でキー列が空であれば無効な行とする.
        if (cols.getSize() <= 1) {
            if (StringUtils.isBlank(key)) {
                return null;
            }
        }

        // 値
        String value;
        if (valueColumn >= 0) {
            value = cols.getAt(valueColumn);
        } else {
            value = line;
        }
        
        return new LineData(key, value);
    }
}
