/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package textkeymatcher.service;

import textkeymatcher.entity.Columns;
import textkeymatcher.entity.LineData;

/**
 *
 * @author seraphy
 */
public class DefaultLineDataBuilder implements LineDataBuilder {

    private ColumnSplitter splitter;
    
    private int keyColumn;
    
    private int valueColumn;
    
    public DefaultLineDataBuilder(ColumnSplitter splitter, int keyColumn, int valueColumn) {
        if (splitter == null) {
            throw new IllegalArgumentException();
        }
        this.splitter = splitter;
        this.keyColumn = keyColumn;
        this.valueColumn = valueColumn;
    }

    @Override
    public LineData parse(String line) {
        Columns cols = splitter.splitColumns(line);

        String key;
        if (keyColumn >= 0) {
            key = cols.getAt(keyColumn);
        } else {
            key = line;
        }
        
        String value;
        if (valueColumn >= 0) {
            value = cols.getAt(valueColumn);
        } else {
            value = line;
        }
        
        return new LineData(key, value);
    }
}
