package kisscelltopng;

import java.lang.reflect.Method;

import javax.swing.SwingUtilities;
import javax.swing.UIManager;

import kisscelltopng.ui.MainFrame;

/**
 * エントリポイント.<br>
 * @author seraphy
 */
public class Main implements Runnable {

	private boolean isMacOSX;
	
	/**
	 * UIをセットアップする.<br>
	 * 失敗しても継続する.<br>
	 */
	protected void setupLookAndFeel() {
		try {
			// Macの判定
			String lcOS = System.getProperty("os.name").toLowerCase();
			this.isMacOSX = lcOS.startsWith("mac os x");
			if (isMacOSX) {
				System.setProperty("apple.laf.useScreenMenuBar", "true");
				System.setProperty(
						"com.apple.mrj.application.apple.menu.about.name",
						"KiSSCellToPNG"); // Lionでは効かない.
			}

			// 実行プラットフォームのネイティブな外観にする.
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			
		} catch (Exception ex) {
			// UIのL&Fセットアップに失敗しても継続する
			ex.printStackTrace();
		}
	}

	/**
	 * EDTでUIの初期化とメインフレームの表示を行う.<br>
	 */
	public void run() {
		setupLookAndFeel();

		MainFrame mainFrame = new MainFrame();

		if (isMacOSX) {
			try {
				Class<?> clz = Class.forName("kisscelltopng.SetupMacScreenMenu");
				Method method = clz.getMethod("connect", MainFrame.class);
				method.invoke(null, mainFrame);

			} catch (Exception ex) {
				ex.printStackTrace();
				// 致命的とはいえないので、継続する.
			}
		}
		
		mainFrame.setVisible(true);
	}

	/**
	 * アプリケーションの開始.<br>
	 * @param args
	 * @throws Exception
	 */
	public static void main(String[] args) throws Exception {
		SwingUtilities.invokeLater(new Main());
	}
}
