package kisscelltopng.ui.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.Serializable;

public class DirChoosePanelModel implements Serializable {

	private static final long serialVersionUID = -5930969074854104899L;

	
	public static final String PROP_SOURCE_TYPE = "sourceType";
	
	public static final String PROP_LOCK = "lock";
	
	public static final String PROP_DEST_DIR = "destDir";
	
	public static final String PROP_SOURCE_FILE = "sourceFile";
	
	
	public enum SourceType {
		KISS("sourcetype.KiSS"), PNG("sourcetype.PNG");
		
		private final String resourceName;
		
		SourceType(String resourceName) {
			this.resourceName = resourceName;
		}
		
		public String getResourceName() {
			return this.resourceName;
		}
	}
	
	private SourceType sourceType = SourceType.KISS;
	
	private File sourceFile;
	
	private File destDir;
	
	private boolean lock;
	
	private PropertyChangeSupport propCngSupport = new PropertyChangeSupport(this);
	
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propCngSupport.addPropertyChangeListener(listener);
	}
	
	public void addPropertyChangeListener(String propName, PropertyChangeListener listener) {
		propCngSupport.addPropertyChangeListener(propName, listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propCngSupport.removePropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(String propName, PropertyChangeListener listener) {
		propCngSupport.removePropertyChangeListener(propName, listener);
	}
	
	public SourceType getSourceType() {
		return sourceType;
	}
	
	public void setSourceType(SourceType sourceType) {
		if (sourceType == null) {
			throw new IllegalArgumentException();
		}
		SourceType old = this.sourceType;
		this.sourceType = sourceType;
		propCngSupport.firePropertyChange(PROP_SOURCE_TYPE, old, sourceType);
	}

	public boolean isLock() {
		return lock;
	}
	
	public void setLock(boolean lock) {
		boolean old = this.lock;
		this.lock = lock;
		propCngSupport.firePropertyChange(PROP_LOCK, old, lock);
	}
	
	public File getDestDir() {
		return destDir;
	}
	
	public File getSourceFile() {
		return sourceFile;
	}
	
	public void setDestDir(File destDir) {
		File old = this.destDir;
		this.destDir = destDir;
		propCngSupport.firePropertyChange(PROP_DEST_DIR, old, destDir);
	}
	
	public void setSourceFile(File sourceFile) {
		File old = this.sourceFile;
		this.sourceFile = sourceFile;
		propCngSupport.firePropertyChange(PROP_SOURCE_FILE, old, sourceFile);
	}
}
