package charactermanaj.model.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;

/**
 * 圧縮ファイル.<br>
 * @author seraphy
 */
public interface ArchivedFile<T extends ArchivedEntry> extends Collection<T> {
	
	/**
	 * 指定された名前の LZHファイルエントリを返します.<br>
	 * 見つからない場合は、null を返します.<br> 
	 * @param name エントリ名
	 * @return エントリ
	 */
	ArchivedEntry getEntry(String name);
	
	/**
	 * 指定されたファイルエントリの内容を読み込むための入力ストリームを返します.<br>
	 * このファイルを閉じると、このメソッドの呼び出しにより返されたすべての入力ストリームが閉じられます.<br> 
	 * @param entry ファイルエントリ
	 * @return 指定されたファイルエントリの内容を読み込むための入力ストリーム
	 * @throws IOException 入出力エラーが発生した場合 
	 */
	InputStream getInputStream(ArchivedEntry entry) throws IOException;
	
	/**
	 * ファイルのパス名を返します。
	 * @return ファイルのパス名
	 */
	String getName();

	/**
	 * ファイルを閉じます.<br>
	 * ファイルを閉じると、getInputStream メソッドの呼び出しにより以前に返されたすべての入力ストリームが閉じられます.<br>
	 * @throws IOException
	 */
	void close() throws IOException;
	
	/**
	 * ファイルエントリの列挙を返します.<br>
	 * @return ファイルエントリの列挙
	 */
	Iterator<T> iterator();
	
	/**
	 * ファイル中のエントリの数を返します.<br>
	 * @return ファイル中のエントリの数 
	 */
	int size();
}
