package charactermanaj.model.io;

/**
 * 圧縮ファイルのエントリ.<br>
 * @author seraphy
 */
public interface ArchivedEntry {

	/**
	 * エントリの名前を返します.<br>
	 * @return エントリの名前
	 */
	String getName();
	
	/**
	 * エントリの修正時間を返します.<br>
	 * 指定されていない場合は -1 を返します.<br>
	 * @return エントリの修正時間.指定されていない場合は -1
	 */
	long getTime();
	
	/**
	 * これがディレクトリエントリである場合に、true を返します.<br>
	 * ディレクトリエントリは、その名前の最後に「/」を付けて定義されています.<br>
	 * @return これがディレクトリエントリである場合に、true 
	 */
	boolean isDirectory();
	
}
