package kisscelltopng.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;

import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JTextField;

import kisscelltopng.kiss.types.KiSSPalette;
import kisscelltopng.ui.model.PalettePanelModel;

public class PalettePanel extends JPanel implements PropertyChangeListener {

	private static final long serialVersionUID = 1L;

	private PalettePanelModel model;
	
	private JTextField txtFile = new JTextField();
	
	private JTextField txtInfo = new JTextField();
	
	private JPanel paletteViewPanel = new JPanel() {
		private static final long serialVersionUID = 1L;

		private int blocksize = 12;
		
		{
			setPreferredSize(new Dimension(blocksize * 17, blocksize * 17));
		}

		protected void paintComponent(Graphics g0) {
			super.paintComponent(g0);
			Graphics2D g = (Graphics2D) g0;
			
			Insets insets = getInsets();
			int offsetX = insets.left;
			int offsetY = insets.top;
			
			KiSSPalette palette = getModel().getPalette();
			if (palette == null) {
				return;
			}
			
			int oy = 0;
			for (int page = 0; page < palette.getNumOfPaletteGroups(); page++) {
				int[] pl = palette.getPaletteGroup(page);
				for (int color = 0; color < palette.getNumOfColors(); color++) {
					int x = color % 16;
					int y = color / 16;
					
					g.setColor(Color.GRAY);
					g.drawRect(offsetX + x * blocksize, offsetY + (oy + y) * blocksize, blocksize, blocksize);
					
					Color c = new Color(pl[color]);
					g.setColor(c);
					g.fillRect(offsetX + x * blocksize + 1, offsetY + (oy + y) * blocksize + 1, blocksize - 1, blocksize - 1);
				}
				oy += palette.getNumOfColors() / 16 + 1;
			}
		}
		
	};
	
	public PalettePanel() {
		this(new PalettePanelModel());
	}
	
	public PalettePanel(PalettePanelModel model) {
		initComponent();
		setModel(model);
	}
	
	private void initComponent() {
		setLayout(new BorderLayout());

		Box headPanel = Box.createVerticalBox();
		headPanel.add(txtFile);
		headPanel.add(txtInfo);
		
		add(headPanel, BorderLayout.NORTH);
		add(paletteViewPanel, BorderLayout.CENTER);
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		applyModel();
	}
	
	public final void setModel(PalettePanelModel model) {
		if (model == null) {
			throw new IllegalArgumentException();
		}
		if (this.model != null) {
			this.model.removePropertyChangeListener(this);
		}

		this.model = model;
		this.model.addPropertyChangeListener(this);
		
		applyModel();
	}
	
	public PalettePanelModel getModel() {
		return model;
	}
	
	public void applyModel() {
		File file = getModel().getPaletteFile();
		txtFile.setText(file == null ? "" : file.getPath());
		
		KiSSPalette palette = getModel().getPalette();
		txtInfo.setText(palette == null ? "" : palette.toString());
		
		paletteViewPanel.repaint();
	}
}