/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import jp.gr.java_conf.dangan.io.BitDataBrokenException;
import jp.gr.java_conf.dangan.io.Bits;
import jp.gr.java_conf.dangan.util.lha.CompressMethod;
import jp.gr.java_conf.dangan.util.lha.PreLzssDecoder;
import jp.gr.java_conf.dangan.util.lha.StaticHuffman;

public class PreLh5Decoder
implements PreLzssDecoder {
    private InputStream in;
    private byte[] cache;
    private int cacheLimit;
    private int cachePosition;
    private int bitBuffer;
    private int bitCount;
    private int blockSize;
    private int[] codeLen;
    private short[] codeTable;
    private int codeTableBits;
    private short[][] codeTree;
    private int[] offLenLen;
    private short[] offLenTable;
    private int offLenTableBits;
    private short[][] offLenTree;
    private int DictionarySize;
    private int MaxMatch;
    private int Threshold;
    private boolean markPositionIsInCache;
    private byte[] markCache;
    private int markCacheLimit;
    private int markCachePosition;
    private int markBitBuffer;
    private int markBitCount;
    private int markBlockSize;
    private int[] markCodeLen;
    private short[] markCodeTable;
    private short[][] markCodeTree;
    private int[] markOffLenLen;
    private short[] markOffLenTable;
    private short[][] markOffLenTree;

    public PreLh5Decoder(InputStream in) {
        this(in, "-lh5-", 12, 8);
    }

    public PreLh5Decoder(InputStream in, String method) {
        this(in, method, 12, 8);
    }

    public PreLh5Decoder(InputStream in, String method, int CodeTableBits, int OffLenTableBits) {
        if (null == method) {
            throw new NullPointerException("method");
        }
        if (in == null) {
            throw new NullPointerException("in");
        }
        if (CodeTableBits <= 0) {
            throw new IllegalArgumentException("CodeTableBits too small. CodeTableBits must be larger than 1.");
        }
        if (0 >= OffLenTableBits) {
            throw new IllegalArgumentException("OffHiTableBits too small. OffHiTableBits must be larger than 1.");
        }
        if (!("-lh4-".equals(method) || "-lh5-".equals(method) || "-lh6-".equals(method) || "-lh7-".equals(method))) {
            throw new IllegalArgumentException("Unknown compress method " + method);
        }
        this.DictionarySize = CompressMethod.toDictionarySize(method);
        this.MaxMatch = CompressMethod.toMaxMatch(method);
        this.Threshold = CompressMethod.toThreshold(method);
        this.in = in;
        this.cache = new byte[1024];
        this.cacheLimit = 0;
        this.cachePosition = 0;
        this.bitBuffer = 0;
        this.bitCount = 0;
        this.blockSize = 0;
        this.codeTableBits = CodeTableBits;
        this.offLenTableBits = OffLenTableBits;
        this.markPositionIsInCache = false;
        this.markCache = null;
        this.markCacheLimit = 0;
        this.markCachePosition = 0;
        this.markBitBuffer = 0;
        this.markBitCount = 0;
    }

    @Override
    public int readCode() throws IOException {
        short node;
        if (this.blockSize <= 0) {
            this.readBlockHead();
        }
        --this.blockSize;
        if (this.bitCount < 16) {
            if (2 <= this.cacheLimit - this.cachePosition) {
                this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount | (this.cache[this.cachePosition++] & 0xFF) << 16 - this.bitCount;
                this.bitCount += 16;
            } else {
                int len;
                this.fillBitBuffer();
                short node2 = this.codeTable[this.bitBuffer >>> 32 - this.codeTableBits];
                if (0 <= node2) {
                    int bits = this.bitBuffer << this.codeTableBits;
                    do {
                        node2 = this.codeTree[bits >>> 31][node2];
                        bits <<= 1;
                    } while (0 <= node2);
                }
                if ((len = this.codeLen[~node2]) <= this.bitCount) {
                    this.bitBuffer <<= len;
                    this.bitCount -= len;
                    return ~node2;
                }
                this.bitCount = 0;
                this.bitBuffer = 0;
                throw new EOFException();
            }
        }
        if (0 <= (node = this.codeTable[this.bitBuffer >>> 32 - this.codeTableBits])) {
            int bits = this.bitBuffer << this.codeTableBits;
            do {
                node = this.codeTree[bits >>> 31][node];
                bits <<= 1;
            } while (0 <= node);
        }
        int len = this.codeLen[~node];
        this.bitBuffer <<= len;
        this.bitCount -= len;
        return ~node;
    }

    @Override
    public int readOffset() throws IOException {
        short node;
        if (this.bitCount < 16) {
            if (2 <= this.cacheLimit - this.cachePosition) {
                this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount | (this.cache[this.cachePosition++] & 0xFF) << 16 - this.bitCount;
                this.bitCount += 16;
            } else {
                this.fillBitBuffer();
            }
        }
        if (0 <= (node = this.offLenTable[this.bitBuffer >>> 32 - this.offLenTableBits])) {
            int bits = this.bitBuffer << this.offLenTableBits;
            do {
                node = this.offLenTree[bits >>> 31][node];
                bits <<= 1;
            } while (0 <= node);
        }
        int offlen = ~node;
        int len = this.offLenLen[offlen];
        this.bitBuffer <<= len;
        this.bitCount -= len;
        if (0 <= --offlen) {
            return 1 << offlen | this.readBits(offlen);
        }
        return 0;
    }

    @Override
    public void mark(int readLimit) {
        if (this.blockSize < readLimit) {
            readLimit = readLimit * 16 / 8;
            readLimit += 272;
        } else {
            readLimit = readLimit * 16 / 8;
        }
        readLimit -= this.cacheLimit - this.cachePosition;
        readLimit -= this.bitCount / 8;
        readLimit += 4;
        readLimit = (readLimit + this.cache.length - 1) / this.cache.length * this.cache.length;
        this.in.mark(readLimit);
        if (this.markCache == null) {
            this.markCache = (byte[])this.cache.clone();
        } else {
            System.arraycopy(this.cache, 0, this.markCache, 0, this.cacheLimit);
        }
        this.markCacheLimit = this.cacheLimit;
        this.markCachePosition = this.cachePosition;
        this.markBitBuffer = this.bitBuffer;
        this.markBitCount = this.bitCount;
        this.markPositionIsInCache = true;
        this.markBlockSize = this.blockSize;
        this.markCodeLen = this.codeLen;
        this.markCodeTable = this.codeTable;
        this.markCodeTree = this.codeTree;
        this.markOffLenLen = this.offLenLen;
        this.markOffLenTable = this.offLenTable;
        this.markOffLenTree = this.offLenTree;
    }

    @Override
    public void reset() throws IOException {
        if (this.markPositionIsInCache) {
            this.cachePosition = this.markCachePosition;
            this.bitBuffer = this.markBitBuffer;
            this.bitCount = this.markBitCount;
            this.blockSize = this.markBlockSize;
            this.codeLen = this.markCodeLen;
            this.codeTable = this.markCodeTable;
            this.codeTree = this.markCodeTree;
            this.offLenLen = this.markOffLenLen;
            this.offLenTable = this.markOffLenTable;
            this.offLenTree = this.markOffLenTree;
        } else {
            if (!this.in.markSupported()) {
                throw new IOException("not support mark()/reset().");
            }
            if (this.markCache == null) {
                throw new IOException("not marked.");
            }
            this.in.reset();
            System.arraycopy(this.markCache, 0, this.cache, 0, this.markCacheLimit);
            this.cacheLimit = this.markCacheLimit;
            this.cachePosition = this.markCachePosition;
            this.bitBuffer = this.markBitBuffer;
            this.bitCount = this.markBitCount;
            this.blockSize = this.markBlockSize;
            this.codeLen = this.markCodeLen;
            this.codeTable = this.markCodeTable;
            this.codeTree = this.markCodeTree;
            this.offLenLen = this.markOffLenLen;
            this.offLenTable = this.markOffLenTable;
            this.offLenTree = this.markOffLenTree;
        }
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int available() throws IOException {
        int avail = this.cacheLimit - this.cachePosition + this.in.available() / this.cache.length * this.cache.length;
        avail += this.bitCount - 32;
        if (this.blockSize < (avail /= 16)) {
            avail -= 272;
        }
        return Math.max(avail, 0);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.cache = null;
        this.cacheLimit = 0;
        this.cachePosition = 0;
        this.bitBuffer = 0;
        this.bitCount = 0;
        this.markCache = null;
        this.markCacheLimit = 0;
        this.markCachePosition = 0;
        this.markBitBuffer = 0;
        this.markBitCount = 0;
        this.markPositionIsInCache = false;
        this.blockSize = 0;
        this.codeLen = null;
        this.codeTable = null;
        this.codeTree = null;
        this.offLenLen = null;
        this.offLenTable = null;
        this.offLenTree = null;
        this.markBlockSize = 0;
        this.markCodeLen = null;
        this.markCodeTable = null;
        this.markCodeTree = null;
        this.markOffLenLen = null;
        this.markOffLenTable = null;
        this.markOffLenTree = null;
    }

    @Override
    public int getDictionarySize() {
        return this.DictionarySize;
    }

    @Override
    public int getMaxMatch() {
        return this.MaxMatch;
    }

    @Override
    public int getThreshold() {
        return this.Threshold;
    }

    private void readBlockHead() throws IOException {
        int i;
        short[][] tableAndTree;
        short[] codeLenTable;
        try {
            this.blockSize = this.readBits(16);
        }
        catch (BitDataBrokenException exception) {
            if (exception.getCause() instanceof EOFException) {
                throw (EOFException)exception.getCause();
            }
            throw exception;
        }
        int[] codeLenLen = this.readCodeLenLen();
        if (null != codeLenLen) {
            codeLenTable = StaticHuffman.createTable(codeLenLen);
        } else {
            codeLenTable = new short[]{(short)this.readBits(5)};
            codeLenLen = new int[codeLenTable[0] + 1];
        }
        this.codeLen = this.readCodeLen(codeLenTable, codeLenLen);
        if (null != this.codeLen) {
            tableAndTree = StaticHuffman.createTableAndTree(this.codeLen, this.codeTableBits);
            this.codeTable = tableAndTree[0];
            this.codeTree = new short[][]{tableAndTree[1], tableAndTree[2]};
        } else {
            int code = this.readBits(9);
            this.codeLen = new int[256 + this.MaxMatch - this.Threshold + 1];
            this.codeTable = new short[1 << this.codeTableBits];
            for (i = 0; i < this.codeTable.length; ++i) {
                this.codeTable[i] = (short)(~code);
            }
            this.codeTree = new short[][]{new short[0], new short[0]};
        }
        this.offLenLen = this.readOffLenLen();
        if (null != this.offLenLen) {
            tableAndTree = StaticHuffman.createTableAndTree(this.offLenLen, this.offLenTableBits);
            this.offLenTable = tableAndTree[0];
            this.offLenTree = new short[][]{tableAndTree[1], tableAndTree[2]};
        } else {
            int offLen = this.readBits(Bits.len(Bits.len(this.DictionarySize)));
            this.offLenLen = new int[Bits.len(this.DictionarySize)];
            this.offLenTable = new short[1 << this.offLenTableBits];
            for (i = 0; i < this.offLenTable.length; ++i) {
                this.offLenTable[i] = (short)(~offLen);
            }
            this.offLenTree = new short[][]{new short[0], new short[0]};
        }
    }

    private int[] readCodeLenLen() throws IOException {
        int listlen = this.readBits(5);
        if (0 < listlen) {
            int[] codeLenLen = new int[listlen];
            int index = 0;
            while (index < listlen) {
                int codelenlen = this.readBits(3);
                if (codelenlen == 7) {
                    while (this.readBoolean()) {
                        ++codelenlen;
                    }
                }
                codeLenLen[index++] = codelenlen;
                if (index != 3) continue;
                index += this.readBits(2);
            }
            return codeLenLen;
        }
        return null;
    }

    private int[] readCodeLen(short[] codeLenTable, int[] codeLenLen) throws IOException {
        int codeLenTableBits = Bits.len(codeLenTable.length - 1);
        int listlen = this.readBits(9);
        if (0 < listlen) {
            int[] codeLen = new int[listlen];
            int index = 0;
            while (index < listlen) {
                this.fillBitBuffer();
                int bits = 0 < codeLenTableBits ? this.bitBuffer >>> 32 - codeLenTableBits : 0;
                short codelen = codeLenTable[bits];
                int len = codeLenLen[codelen];
                this.bitBuffer <<= len;
                this.bitCount -= len;
                if (codelen == 0) {
                    ++index;
                    continue;
                }
                if (codelen == 1) {
                    index += this.readBits(4) + 3;
                    continue;
                }
                if (codelen == 2) {
                    index += this.readBits(9) + 20;
                    continue;
                }
                codeLen[index++] = codelen - 2;
            }
            return codeLen;
        }
        return null;
    }

    private int[] readOffLenLen() throws IOException {
        int listlen = this.readBits(Bits.len(Bits.len(this.DictionarySize)));
        if (0 < listlen) {
            int[] offLenLen = new int[listlen];
            int index = 0;
            while (index < listlen) {
                int offlenlen = this.readBits(3);
                if (offlenlen == 7) {
                    while (this.readBoolean()) {
                        ++offlenlen;
                    }
                }
                offLenLen[index++] = offlenlen;
            }
            return offLenLen;
        }
        return null;
    }

    private boolean readBoolean() throws IOException {
        if (0 < this.bitCount) {
            boolean bool = this.bitBuffer < 0;
            this.bitBuffer <<= 1;
            --this.bitCount;
            return bool;
        }
        this.fillBitBuffer();
        boolean bool = this.bitBuffer < 0;
        this.bitBuffer <<= 1;
        --this.bitCount;
        return bool;
    }

    private int readBits(int count) throws IOException {
        if (0 < count) {
            if (count <= this.bitCount) {
                int bits = this.bitBuffer >>> 32 - count;
                this.bitBuffer <<= count;
                this.bitCount -= count;
                return bits;
            }
            int requested = count;
            int bits = 0;
            try {
                this.fillBitBuffer();
                while (this.bitCount < count) {
                    if ((count -= this.bitCount) < 32) {
                        bits |= this.bitBuffer >>> 32 - this.bitCount << count;
                    }
                    this.bitBuffer = 0;
                    this.bitCount = 0;
                    this.fillBitBuffer();
                }
                this.bitBuffer <<= count;
                this.bitCount -= count;
                return bits |= this.bitBuffer >>> 32 - count;
            }
            catch (LocalEOFException exception) {
                if (exception.thrownBy(this) && count < requested) {
                    throw new BitDataBrokenException(exception, bits >>> count, requested - count);
                }
                throw exception;
            }
        }
        return 0;
    }

    private int cachedBits() {
        return this.bitCount + (this.cacheLimit - this.cachePosition << 3);
    }

    private void fillBitBuffer() throws IOException {
        if (32 <= this.cachedBits()) {
            if (this.bitCount <= 24) {
                if (this.bitCount <= 16) {
                    if (this.bitCount <= 8) {
                        if (this.bitCount <= 0) {
                            this.bitBuffer = this.cache[this.cachePosition++] << 24;
                            this.bitCount = 8;
                        }
                        this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount;
                        this.bitCount += 8;
                    }
                    this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount;
                    this.bitCount += 8;
                }
                this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount;
                this.bitCount += 8;
            }
        } else if (this.bitCount < 25) {
            if (this.bitCount == 0) {
                this.bitBuffer = 0;
            }
            int count = Math.min(32 - this.bitCount >> 3, this.cacheLimit - this.cachePosition);
            while (0 < count--) {
                this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount;
                this.bitCount += 8;
            }
            this.fillCache();
            if (this.cachePosition < this.cacheLimit) {
                count = Math.min(32 - this.bitCount >> 3, this.cacheLimit - this.cachePosition);
                while (0 < count--) {
                    this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount;
                    this.bitCount += 8;
                }
            } else if (this.bitCount <= 0) {
                throw new LocalEOFException(this);
            }
        }
    }

    private void fillCache() throws IOException {
        this.markPositionIsInCache = false;
        this.cacheLimit = 0;
        this.cachePosition = 0;
        int read = 0;
        while (0 <= read && this.cacheLimit < this.cache.length) {
            read = this.in.read(this.cache, this.cacheLimit, this.cache.length - this.cacheLimit);
            if (0 >= read) continue;
            this.cacheLimit += read;
        }
    }

    private static class LocalEOFException
    extends EOFException {
        private static final long serialVersionUID = 3824706560448579587L;
        private Object owner;

        public LocalEOFException(Object object) {
            this.owner = object;
        }

        public boolean thrownBy(Object object) {
            return this.owner == object;
        }
    }
}

