/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.IOException;
import java.io.OutputStream;
import jp.gr.java_conf.dangan.io.BitOutputStream;
import jp.gr.java_conf.dangan.util.lha.PostLzssEncoder;
import jp.gr.java_conf.dangan.util.lha.StaticHuffman;

public class PostLh3Encoder
implements PostLzssEncoder {
    private static final int DictionarySize = 8192;
    private static final int MaxMatch = 256;
    private static final int Threshold = 3;
    private static final int[] ConstOffHiLen = PostLh3Encoder.createConstOffHiLen();
    private static final int CodeSize = 286;
    private BitOutputStream out;
    private byte[] buffer;
    private int blockSize;
    private int position;
    private int flagBit;
    private int flagPos;
    private int[] codeFreq;
    private int[] offHiFreq;

    public PostLh3Encoder(OutputStream out) {
        this(out, 16384);
    }

    public PostLh3Encoder(OutputStream out, int BufferSize) {
        if (out == null) {
            throw new NullPointerException("out");
        }
        int DictionarySizeByteLen = 2;
        int MinCapacity = 25;
        if (25 > BufferSize) {
            throw new IllegalArgumentException("BufferSize too small. BufferSize must be larger than 25");
        }
        this.out = out instanceof BitOutputStream ? (BitOutputStream)out : new BitOutputStream(out);
        this.codeFreq = new int[286];
        this.offHiFreq = new int[128];
        this.buffer = new byte[BufferSize];
        this.blockSize = 0;
        this.position = 0;
        this.flagBit = 0;
        this.flagPos = 0;
    }

    @Override
    public void writeCode(int code) throws IOException {
        int CodeMax = 285;
        int DictionarySizeByteLen = 2;
        int Capacity = 25;
        if (this.flagBit == 0) {
            if (this.buffer.length - this.position < 25 || 65528 <= this.blockSize) {
                this.writeOut();
            }
            this.flagBit = 128;
            this.flagPos = this.position++;
            this.buffer[this.flagPos] = 0;
        }
        this.buffer[this.position++] = (byte)code;
        if (256 <= code) {
            int n = this.flagPos;
            this.buffer[n] = (byte)(this.buffer[n] | this.flagBit);
        }
        this.flagBit >>= 1;
        int n = Math.min(code, 285);
        this.codeFreq[n] = this.codeFreq[n] + 1;
        ++this.blockSize;
    }

    @Override
    public void writeOffset(int offset) {
        this.buffer[this.position++] = (byte)(offset >> 8);
        this.buffer[this.position++] = (byte)offset;
        int n = offset >> 6;
        this.offHiFreq[n] = this.offHiFreq[n] + 1;
    }

    @Override
    public void flush() throws IOException {
        this.writeOut();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.writeOut();
        this.out.close();
        this.out = null;
        this.buffer = null;
        this.codeFreq = null;
        this.offHiFreq = null;
    }

    @Override
    public int getDictionarySize() {
        return 8192;
    }

    @Override
    public int getMaxMatch() {
        return 256;
    }

    @Override
    public int getThreshold() {
        return 3;
    }

    private void writeOut() throws IOException {
        int CodeMax = 285;
        if (0 < this.blockSize) {
            int i;
            this.out.writeBits(16, this.blockSize);
            int[] codeLen = StaticHuffman.FreqListToLenList(this.codeFreq);
            int[] codeCode = StaticHuffman.LenListToCodeList(codeLen);
            int[] offHiLen = PostLh3Encoder.getBetterOffHiLen(this.offHiFreq, StaticHuffman.FreqListToLenList(this.offHiFreq));
            int[] offHiCode = StaticHuffman.LenListToCodeList(offHiLen);
            if (2 <= PostLh3Encoder.countNoZeroElement(this.codeFreq)) {
                this.writeCodeLenList(codeLen);
            } else {
                this.out.writeBits(15, 16912);
                this.out.writeBits(9, PostLh3Encoder.getNoZeroElementIndex(this.codeFreq));
            }
            if (offHiLen != ConstOffHiLen) {
                this.out.writeBit(1);
                if (2 <= PostLh3Encoder.countNoZeroElement(this.offHiFreq)) {
                    this.writeOffHiLenList(offHiLen);
                } else {
                    this.out.writeBits(12, 273);
                    this.out.writeBits(7, PostLh3Encoder.getNoZeroElementIndex(this.offHiFreq));
                }
            } else {
                this.out.writeBit(0);
            }
            this.position = 0;
            this.flagBit = 0;
            for (i = 0; i < this.blockSize; ++i) {
                int code;
                if (this.flagBit == 0) {
                    this.flagBit = 128;
                    ++this.position;
                    this.flagPos = this.flagPos;
                }
                if (0 == (this.buffer[this.flagPos] & this.flagBit)) {
                    code = this.buffer[this.position++] & 0xFF;
                    this.out.writeBits(codeLen[code], codeCode[code]);
                } else {
                    code = this.buffer[this.position++] & 0xFF | 0x100;
                    int offset = (this.buffer[this.position++] & 0xFF) << 8 | this.buffer[this.position++] & 0xFF;
                    int offHi = offset >> 6;
                    if (code < 285) {
                        this.out.writeBits(codeLen[code], codeCode[code]);
                    } else {
                        this.out.writeBits(codeLen[285], codeCode[285]);
                        this.out.writeBits(8, code - 285);
                    }
                    this.out.writeBits(offHiLen[offHi], offHiCode[offHi]);
                    this.out.writeBits(6, offset);
                }
                this.flagBit >>= 1;
            }
            for (i = 0; i < this.codeFreq.length; ++i) {
                this.codeFreq[i] = 0;
            }
            for (i = 0; i < this.offHiFreq.length; ++i) {
                this.offHiFreq[i] = 0;
            }
            this.blockSize = 0;
            this.position = 0;
            this.flagBit = 0;
        }
    }

    private void writeCodeLenList(int[] codeLen) throws IOException {
        for (int i = 0; i < codeLen.length; ++i) {
            if (0 < codeLen[i]) {
                this.out.writeBits(5, 0x10 | codeLen[i] - 1);
                continue;
            }
            this.out.writeBit(0);
        }
    }

    private void writeOffHiLenList(int[] offHiLen) throws IOException {
        for (int i = 0; i < offHiLen.length; ++i) {
            this.out.writeBits(4, offHiLen[i]);
        }
    }

    private static int countNoZeroElement(int[] array) {
        int count = 0;
        for (int i = 0; i < array.length; ++i) {
            if (0 == array[i]) continue;
            ++count;
        }
        return count;
    }

    private static int getNoZeroElementIndex(int[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (0 == array[i]) continue;
            return i;
        }
        return 0;
    }

    private static int[] createConstOffHiLen() {
        int length = 128;
        int[] list = new int[]{2, 1, 1, 3, 6, 13, 31, 78, 0};
        int[] offHiLen = new int[128];
        int index = 0;
        int len = list[index++];
        for (int i = 0; i < 128; ++i) {
            while (list[index] == i) {
                ++len;
                ++index;
            }
            offHiLen[i] = len;
        }
        return offHiLen;
    }

    private static int[] getBetterOffHiLen(int[] OffHiFreq, int[] OffHiLen) {
        boolean detect = false;
        for (int i = 0; i < OffHiLen.length; ++i) {
            if (15 >= OffHiLen[i]) continue;
            detect = true;
        }
        if (!detect) {
            int origTotal = 1;
            int consTotal = 1;
            origTotal = 2 <= PostLh3Encoder.countNoZeroElement(OffHiFreq) ? (origTotal += 512) : (origTotal += 19);
            for (int i = 0; i < OffHiFreq.length; ++i) {
                origTotal += OffHiFreq[i] * OffHiLen[i];
                consTotal += OffHiFreq[i] * ConstOffHiLen[i];
            }
            if (origTotal < consTotal) {
                return OffHiLen;
            }
            return ConstOffHiLen;
        }
        return ConstOffHiLen;
    }
}

