/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.lang.reflect.InvocationTargetException;
import jp.gr.java_conf.dangan.lang.reflect.Factory;
import jp.gr.java_conf.dangan.util.lha.HashDefault;
import jp.gr.java_conf.dangan.util.lha.HashMethod;
import jp.gr.java_conf.dangan.util.lha.LzssOutputStream;
import jp.gr.java_conf.dangan.util.lha.LzssSearchMethod;

public class HashAndChainedListSearch
implements LzssSearchMethod {
    private int DictionarySize;
    private int MaxMatch;
    private int Threshold;
    private byte[] TextBuffer;
    private int DictionaryLimit;
    private HashMethod hashMethod;
    private int[] hashTable;
    private char[] tooBigFlag;
    private int[] prev;
    private int SearchLimitCount;

    public HashAndChainedListSearch(int DictionarySize, int MaxMatch, int Threshold, byte[] TextBuffer) {
        this(DictionarySize, MaxMatch, Threshold, TextBuffer, HashDefault.class.getName(), 256);
    }

    public HashAndChainedListSearch(int DictionarySize, int MaxMatch, int Threshold, byte[] TextBuffer, int SearchLimitCount) {
        this(DictionarySize, MaxMatch, Threshold, TextBuffer, HashDefault.class.getName(), SearchLimitCount);
    }

    public HashAndChainedListSearch(int DictionarySize, int MaxMatch, int Threshold, byte[] TextBuffer, String HashMethodClassName) {
        this(DictionarySize, MaxMatch, Threshold, TextBuffer, HashMethodClassName, 256);
    }

    public HashAndChainedListSearch(int DictionarySize, int MaxMatch, int Threshold, byte[] TextBuffer, String HashMethodClassName, int SearchLimitCount) {
        if (0 < SearchLimitCount) {
            int i;
            this.DictionarySize = DictionarySize;
            this.MaxMatch = MaxMatch;
            this.Threshold = Threshold;
            this.TextBuffer = TextBuffer;
            this.DictionaryLimit = this.DictionarySize;
            this.SearchLimitCount = SearchLimitCount;
            try {
                this.hashMethod = (HashMethod)Factory.createInstance(HashMethodClassName, new Object[]{TextBuffer});
            }
            catch (ClassNotFoundException exception) {
                throw new NoClassDefFoundError(exception.getMessage());
            }
            catch (InvocationTargetException exception) {
                throw new Error(exception.getTargetException().getMessage());
            }
            catch (NoSuchMethodException exception) {
                throw new NoSuchMethodError(exception.getMessage());
            }
            catch (InstantiationException exception) {
                throw new InstantiationError(exception.getMessage());
            }
            this.hashTable = new int[this.hashMethod.tableSize()];
            for (i = 0; i < this.hashTable.length; ++i) {
                this.hashTable[i] = -1;
            }
            this.prev = new int[this.DictionarySize];
            for (i = 0; i < this.prev.length; ++i) {
                this.prev[i] = -1;
            }
        } else {
            throw new IllegalArgumentException("SearchLimitCount must be 1 or more.");
        }
        this.tooBigFlag = new char[this.hashMethod.tableSize() >> 4];
    }

    @Override
    public void put(int position) {
        int hash = this.hashMethod.hash(position);
        this.prev[position & this.DictionarySize - 1] = this.hashTable[hash];
        this.hashTable[hash] = position;
    }

    @Override
    public int searchAndPut(int position) {
        int poshash;
        int matchlen = this.Threshold - 1;
        int matchpos = position;
        int maxmatch = this.MaxMatch;
        int scanlimit = Math.max(this.DictionaryLimit, position - this.DictionarySize);
        int offhash = poshash = this.hashMethod.hash(position);
        int offset = 0;
        while (this.isTooBig(offhash) && offset < this.MaxMatch - this.hashMethod.hashRequires()) {
            offhash = this.hashMethod.hash(position + ++offset);
        }
        byte[] buf = this.TextBuffer;
        int max = position + this.MaxMatch;
        int s = 0;
        int p = 0;
        int len = 0;
        while (true) {
            int scanpos = this.hashTable[offhash];
            int searchCount = this.SearchLimitCount;
            while (scanlimit <= scanpos - offset && 0 < --searchCount) {
                if (buf[scanpos + matchlen - offset] == buf[position + matchlen]) {
                    s = scanpos - offset;
                    p = position;
                    while (buf[s] == buf[p]) {
                        ++s;
                        if (max > ++p) continue;
                    }
                    if (matchlen < (len = p - position)) {
                        matchpos = scanpos - offset;
                        matchlen = len;
                        if (max <= p) break;
                    }
                }
                scanpos = this.prev[scanpos & this.DictionarySize - 1];
            }
            if (searchCount <= 0) {
                this.setTooBigFlag(offhash);
            } else if (scanpos < scanlimit) {
                this.clearTooBigFlag(offhash);
            }
            if (0 >= offset || matchlen >= this.hashMethod.hashRequires() + offset) break;
            offset = 0;
            maxmatch = this.hashMethod.hashRequires() + offset - 1;
            max = position + maxmatch;
            offhash = poshash;
        }
        this.prev[position & this.DictionarySize - 1] = this.hashTable[poshash];
        this.hashTable[poshash] = position;
        if (this.Threshold <= matchlen) {
            return LzssOutputStream.createSearchReturn(matchlen, matchpos);
        }
        return -1;
    }

    @Override
    public int search(int position, int lastPutPos) {
        int scanpos;
        int matchlen = this.Threshold - 1;
        int matchpos = position;
        int scanlimit = Math.max(this.DictionaryLimit, lastPutPos);
        byte[] buf = this.TextBuffer;
        int max = Math.min(this.TextBuffer.length, position + this.MaxMatch);
        int s = 0;
        int p = 0;
        int len = 0;
        for (scanpos = position - 1; scanlimit < scanpos; --scanpos) {
            s = scanpos;
            p = position;
            while (buf[s] == buf[p]) {
                ++s;
                if (max > ++p) continue;
            }
            if (matchlen >= len) continue;
            matchpos = scanpos;
            matchlen = len;
        }
        if (this.hashMethod.hashRequires() < this.TextBuffer.length - position) {
            int poshash;
            int maxmatch = this.MaxMatch;
            scanlimit = Math.max(this.DictionaryLimit, position - this.DictionarySize);
            int offhash = poshash = this.hashMethod.hash(position);
            int offset = 0;
            while (this.isTooBig(offhash) && offset < this.MaxMatch - this.hashMethod.hashRequires()) {
                offhash = this.hashMethod.hash(position + ++offset);
            }
            while (true) {
                int searchCount = this.SearchLimitCount;
                scanpos = this.hashTable[offhash];
                while (scanlimit <= scanpos - offset && 0 < --searchCount) {
                    if (buf[scanpos + matchlen - offset] == buf[position + matchlen]) {
                        s = scanpos - offset;
                        p = position;
                        while (buf[s] == buf[p]) {
                            ++s;
                            if (max > ++p) continue;
                        }
                        if (matchlen < (len = p - position)) {
                            matchpos = scanpos - offset;
                            matchlen = len;
                            if (max <= p) break;
                        }
                    }
                    scanpos = this.prev[scanpos & this.DictionarySize - 1];
                }
                if (searchCount <= 0) {
                    this.setTooBigFlag(offhash);
                } else if (scanpos < scanlimit) {
                    this.clearTooBigFlag(offhash);
                }
                if (0 >= offset || matchlen >= this.hashMethod.hashRequires() + offset) break;
                offset = 0;
                maxmatch = this.hashMethod.hashRequires() + offset - 1;
                max = Math.min(this.TextBuffer.length, position + maxmatch);
                offhash = poshash;
            }
        }
        if (this.Threshold <= matchlen) {
            return LzssOutputStream.createSearchReturn(matchlen, matchpos);
        }
        return -1;
    }

    @Override
    public void slide() {
        int pos;
        int i;
        this.DictionaryLimit = Math.max(0, this.DictionaryLimit - this.DictionarySize);
        for (i = 0; i < this.hashTable.length; ++i) {
            pos = this.hashTable[i] - this.DictionarySize;
            this.hashTable[i] = 0 <= pos ? pos : -1;
        }
        for (i = 0; i < this.prev.length; ++i) {
            pos = this.prev[i] - this.DictionarySize;
            this.prev[i] = 0 <= pos ? pos : -1;
        }
    }

    @Override
    public int putRequires() {
        return this.hashMethod.hashRequires();
    }

    public int searchAndPut(int position, int[] matchposs) {
        int matchlen = this.Threshold - 1;
        int matchpos = position;
        int maxmatch = this.MaxMatch;
        int scanlimit = Math.max(this.DictionaryLimit, position - this.DictionarySize);
        int searchCount = this.SearchLimitCount;
        for (int i = 0; i < matchposs.length; ++i) {
            matchposs[i] = -1;
        }
        int scanpos = this.hashTable[this.hashMethod.hash(position)];
        while (scanlimit < scanpos && 0 < searchCount--) {
            if (this.TextBuffer[scanpos + matchlen] == this.TextBuffer[position + matchlen]) {
                int len = 0;
                while (this.TextBuffer[scanpos + len] == this.TextBuffer[position + len] && maxmatch > ++len) {
                }
                if (matchlen < len) {
                    int i = matchlen + 1 - this.Threshold;
                    int end = Math.min(len + 1 - this.Threshold, matchposs.length);
                    while (i < end) {
                        matchposs[i++] = scanpos;
                    }
                    matchpos = scanpos;
                    matchlen = len;
                    if (maxmatch <= len) break;
                }
            }
            scanpos = this.prev[scanpos & this.DictionarySize - 1];
        }
        this.put(position);
        if (matchpos < position) {
            return LzssOutputStream.createSearchReturn(matchlen, matchpos);
        }
        return -1;
    }

    private boolean isTooBig(int hash) {
        return 0 != (this.tooBigFlag[hash >> 4] & 1 << (hash & 0xF));
    }

    private void setTooBigFlag(int hash) {
        int n = hash >> 4;
        this.tooBigFlag[n] = (char)(this.tooBigFlag[n] | 1 << (hash & 0xF));
    }

    private void clearTooBigFlag(int hash) {
        int n = hash >> 4;
        this.tooBigFlag[n] = (char)(this.tooBigFlag[n] & ~(1 << (hash & 0xF)));
    }
}

