/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import jp.gr.java_conf.dangan.lang.reflect.Type;

public class Factory {
    private Factory() {
    }

    public static Object createInstance(String classname, Object[] args) throws InvocationTargetException, InstantiationException, ClassNotFoundException, NoSuchMethodException {
        return Factory.createInstance(Class.forName(classname), args);
    }

    public static Object createInstance(Class<?> type, Object[] args) throws InvocationTargetException, InstantiationException, NoSuchMethodException {
        Constructor<?> constructor = Factory.getMatchFullConstructor(type, args);
        if (constructor == null && (constructor = Factory.getConstructor(type, args)) != null) {
            args = Type.parseAll(constructor.getParameterTypes(), args);
        }
        if (constructor != null) {
            try {
                return constructor.newInstance(args);
            }
            catch (IllegalAccessException exception) {
                throw new IllegalAccessError(exception.toString());
            }
        }
        throw new NoSuchMethodException();
    }

    public static Constructor<?> getConstructor(String classname, Object[] args) throws ClassNotFoundException {
        return Factory.getConstructor(Class.forName(classname), args);
    }

    public static Constructor<?> getConstructor(Class<?> type, Object[] args) {
        return Factory.getConstructor(type, args, false);
    }

    public static Constructor<?> getConstructor(String classname, Object[] args, boolean all) throws ClassNotFoundException {
        return Factory.getConstructor(Class.forName(classname), args, all);
    }

    public static Constructor<?> getConstructor(Class<?> type, Object[] args, boolean all) {
        int i;
        Constructor<?>[] constructors = all ? type.getDeclaredConstructors() : type.getConstructors();
        for (i = 0; i < constructors.length; ++i) {
            if (!Type.matchFullAll(constructors[i].getParameterTypes(), args)) continue;
            return constructors[i];
        }
        for (i = 0; i < constructors.length; ++i) {
            if (!Type.matchRestrictAll(constructors[i].getParameterTypes(), args)) continue;
            return constructors[i];
        }
        for (i = 0; i < constructors.length; ++i) {
            if (!Type.matchAll(constructors[i].getParameterTypes(), args)) continue;
            return constructors[i];
        }
        return null;
    }

    public static Constructor<?> getMatchFullConstructor(String classname, Object[] args) throws ClassNotFoundException {
        return Factory.getMatchFullConstructor(Class.forName(classname), args);
    }

    public static Constructor<?> getMatchFullConstructor(Class<?> type, Object[] args) {
        return Factory.getMatchFullConstructor(type, args, false);
    }

    public static Constructor<?> getMatchFullConstructor(String classname, Object[] args, boolean all) throws ClassNotFoundException {
        return Factory.getMatchFullConstructor(Class.forName(classname), args, all);
    }

    public static Constructor<?> getMatchFullConstructor(Class<?> type, Object[] args, boolean all) {
        Constructor<?>[] constructors = all ? type.getDeclaredConstructors() : type.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            if (!Type.matchFullAll(constructors[i].getParameterTypes(), args)) continue;
            return constructors[i];
        }
        return null;
    }
}

