/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.io.ArchivedEntry;
import charactermanaj.model.io.ArchivedFile;
import charactermanaj.model.io.JarArchivedEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractCollection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

class JarArchivedFile
extends AbstractCollection<JarArchivedEntry>
implements ArchivedFile<JarArchivedEntry> {
    protected File archivedFile;
    protected JarFile jarFile;
    protected HashMap<String, JarArchivedEntry> entries = new HashMap();

    public JarArchivedFile(File archivedFile) throws IOException {
        if (archivedFile == null) {
            throw new IllegalArgumentException();
        }
        this.archivedFile = archivedFile;
        this.jarFile = new JarFile(archivedFile);
        this.enumFiles();
    }

    protected void enumFiles() throws IOException {
        Enumeration<JarEntry> enm = this.jarFile.entries();
        while (enm.hasMoreElements()) {
            JarEntry header = enm.nextElement();
            JarArchivedEntry entry = new JarArchivedEntry(header);
            this.entries.put(entry.getName(), entry);
        }
    }

    @Override
    public String getName() {
        return this.archivedFile.getPath().replace('\\', '/');
    }

    @Override
    public ArchivedEntry getEntry(String name) {
        return this.entries.get(name);
    }

    @Override
    public InputStream getInputStream(ArchivedEntry entry) throws IOException {
        if (entry == null) {
            throw new IllegalArgumentException();
        }
        JarArchivedEntry lhaEntry = this.entries.get(entry.getName());
        if (lhaEntry == null) {
            return null;
        }
        return this.jarFile.getInputStream(lhaEntry.getJarEntry());
    }

    @Override
    public void close() throws IOException {
        this.jarFile.close();
    }

    @Override
    public Iterator<JarArchivedEntry> iterator() {
        return this.entries.values().iterator();
    }

    @Override
    public int size() {
        return this.entries.size();
    }
}

