/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.io.ArchivedEntry;
import charactermanaj.model.io.ArchivedFile;
import charactermanaj.model.io.FileArchivedEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

class DirArchivedFile
extends AbstractCollection<FileArchivedEntry>
implements ArchivedFile<FileArchivedEntry> {
    private File dirSt;
    protected HashMap<String, FileArchivedEntry> entries = new HashMap();

    public DirArchivedFile(File dir) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException("dir must none null.");
        }
        this.enumFiles(dir);
    }

    protected void enumFiles(File dirSt) throws IOException {
        LinkedList<File> stack = new LinkedList<File>();
        stack.push(dirSt);
        while (!stack.isEmpty()) {
            File dir = (File)stack.pop();
            if (dir.isDirectory()) {
                for (File file : dir.listFiles()) {
                    if (file.isDirectory()) {
                        stack.push(file);
                        continue;
                    }
                    this.addArchivedEntry(file);
                }
                continue;
            }
            this.addArchivedEntry(dir);
        }
    }

    protected void addArchivedEntry(File file) {
        FileArchivedEntry entry = new FileArchivedEntry(file);
        this.entries.put(entry.getName(), entry);
    }

    @Override
    public ArchivedEntry getEntry(String name) {
        return this.entries.get(name);
    }

    @Override
    public InputStream getInputStream(ArchivedEntry entry) throws IOException {
        if (entry == null) {
            throw new IllegalArgumentException();
        }
        String name = entry.getName();
        FileArchivedEntry fileEntry = this.entries.get(name);
        if (fileEntry == null) {
            throw new IllegalArgumentException("no entry. " + entry);
        }
        return new FileInputStream(fileEntry.getFile());
    }

    @Override
    public String getName() {
        return this.dirSt.getPath().replace('\\', '/');
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Iterator<FileArchivedEntry> iterator() {
        return this.entries.values().iterator();
    }

    @Override
    public int size() {
        return this.entries.size();
    }
}

