/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.io.ArchivedEntry;
import charactermanaj.model.io.ArchivedFile;
import charactermanaj.model.io.UnsupportedArchivedFileException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;

public abstract class ArchivedFileFactory {
    public static final String RESOURCES = "META-INF/archivedFileFactory.properties";
    public static final String TYPEKEY_DIRECTORY = "*directory";
    protected static LinkedHashMap<String, String> CONFIG;
    protected static HashMap<String, ArchivedFileFactory> caches;

    public abstract ArchivedFile<? extends ArchivedEntry> openArchive(File var1) throws IOException;

    public static ArchivedFile<? extends ArchivedEntry> getArchivedFile(File file) throws IOException {
        ArchivedFileFactory factory = ArchivedFileFactory.getFactory(file);
        return factory.openArchive(file);
    }

    public static ArchivedFileFactory getFactory(String typ) throws IOException {
        ArchivedFileFactory.initConfig();
        ArchivedFileFactory factory = null;
        String cls = CONFIG.get(typ);
        if (cls != null) {
            factory = ArchivedFileFactory.getFactoryForClass(cls);
        }
        if (factory == null) {
            throw new UnsupportedArchivedFileException(typ);
        }
        return factory;
    }

    public static boolean isSupported(String typ) {
        if (typ == null) {
            return false;
        }
        try {
            ArchivedFileFactory factory = ArchivedFileFactory.getFactory(typ);
            if (factory != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static List<String> getSupportedTypes() {
        ArrayList<String> result = new ArrayList<String>();
        for (String ext : CONFIG.keySet()) {
            if (ext.startsWith("*")) continue;
            result.add(ext);
        }
        return result;
    }

    public static boolean isSupported(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        if (file.isDirectory()) {
            return ArchivedFileFactory.isSupported(TYPEKEY_DIRECTORY);
        }
        try {
            return ArchivedFileFactory.isSupported(ArchivedFileFactory.getExtention(file));
        }
        catch (IOException ex) {
            return false;
        }
    }

    protected static ArchivedFileFactory getFactoryForClass(String className) throws IOException {
        if (!caches.containsKey(className)) {
            ClassLoader cl = ArchivedFileFactory.getClassLoader();
            try {
                Class<?> cls = cl.loadClass(className);
                ArchivedFileFactory factory = (ArchivedFileFactory)cls.newInstance();
                caches.put(className, factory);
            }
            catch (Exception ex) {
                caches.put(className, null);
                throw new UnsupportedArchivedFileException("configuration error: " + className, ex);
            }
        }
        return caches.get(className);
    }

    public static ArchivedFileFactory getFactory(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        if (file.isDirectory()) {
            return ArchivedFileFactory.getFactory(TYPEKEY_DIRECTORY);
        }
        return ArchivedFileFactory.getFactory(ArchivedFileFactory.getExtention(file));
    }

    protected static String getExtention(File file) throws UnsupportedArchivedFileException {
        String lcName = file.getName().toLowerCase();
        int pos = lcName.indexOf(46);
        if (pos < 0) {
            throw new UnsupportedArchivedFileException(lcName);
        }
        String ext = lcName.substring(pos + 1);
        return ext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void initConfig() throws IOException {
        if (CONFIG != null) {
            return;
        }
        LinkedHashMap<String, String> config = new LinkedHashMap<String, String>();
        ClassLoader cl = ArchivedFileFactory.getClassLoader();
        Enumeration<URL> resources = cl.getResources(RESOURCES);
        while (resources != null && resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            Properties prop = new Properties();
            InputStream is = resource.openStream();
            try {
                prop.load(is);
            }
            finally {
                is.close();
            }
            Enumeration<?> keys = prop.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                config.put(key, prop.getProperty(key));
            }
        }
        CONFIG = config;
    }

    protected static ClassLoader getClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = ArchivedFileFactory.class.getClassLoader();
                }
                return cl;
            }
        });
    }

    static {
        caches = new HashMap();
    }
}

