/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.twitterplugin.utils;

public class WaitForResult {

    private boolean mResult = false;

    public void waitFor(int timeout, Runnable r) {
        int timeoutValue = 0;
        while (!mResult && timeoutValue <= timeout) {
            r.run();
            try {
                Thread.sleep(200);
                timeout += 200;
            } catch (InterruptedException e) {
                return;
            }
        }
    }

    public void setResult(boolean result) {
        mResult = result;
    }

    public boolean isSuccess() {
        return mResult;
    }
}
