/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2009 Sony Ericsson Mobile Communications AB.         *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/
package com.sonyericsson.eventstream.telephonyplugin;

import com.sonyericsson.eventstream.telephonyplugin.PluginConstants.EventStream;
import com.sonyericsson.eventstream.telephonyplugin.PluginConstants.ServiceIntentCmd;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.IntentSender.SendIntentException;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.Resources.Theme;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabase.CursorFactory;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.test.InstrumentationTestCase;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class UEventStreamListener extends InstrumentationTestCase {

    private static final String FRIEND_KEY = "23";

    /**
     * Test onReceive with refresh action and correct values.
     * Expect that startService() is called with an correct intent.
     */
    public void testOnReceiveRefreshRequestCorrectValues() {
        EventStreamListener listener = new EventStreamListener();
        Intent intent = new Intent(PluginConstants.EventStream.REFRESH_REQUEST_ACTION);
        MockContext context = new MockContext();

        listener.onReceive(context, intent);

        assertNotNull("Expected startService() to be called", context.getStartServiceIntent());
        assertCorrectIntent(context, ServiceIntentCmd.SERVICE_COMMAND_KEY, ServiceIntentCmd.REFRESH_REQUEST);
    }

    /**
     * Test onReceive with register action and correct values.
     * Expect that startService() is called with an correct intent.
     */
    public void testOnReceiveRegisterPluginCorrectValues() {
        EventStreamListener listener = new EventStreamListener();
        Intent intent = new Intent(PluginConstants.EventStream.REGISTER_PLUGINS_ACTION);
        MockContext context = new MockContext();

        listener.onReceive(context, intent);

        assertNotNull("Expected startService() to be called", context.getStartServiceIntent());
        assertCorrectIntent(context, ServiceIntentCmd.SERVICE_COMMAND_KEY, ServiceIntentCmd.REGISTER_PLUGIN);
    }

    /**
     * Test onReceive with view action and correct values.
     * Expect that startService() is called with an correct intent.
     */
    public void testOnReceiveViewEventCorrectValues() {
        EventStreamListener listener = new EventStreamListener();
        Intent intent = new Intent(PluginConstants.EventStream.VIEW_EVENT_ACTION);
        intent.putExtra(EventStream.EVENTSTREAM_VIEW_INTENT_FRIEND_KEY_DATA, FRIEND_KEY);
        MockContext context = new MockContext();

        listener.onReceive(context, intent);

        assertNotNull("Expected startService() to be called", context.getStartServiceIntent());
        assertCorrectIntent(context, ServiceIntentCmd.SERVICE_COMMAND_KEY, ServiceIntentCmd.VIEW_EVENT);
        assertCorrectIntent(context, EventStream.EVENTSTREAM_VIEW_INTENT_FRIEND_KEY_DATA, FRIEND_KEY);
    }

    /**
     * Test onReceive with view action but with no friend key data.
     * Expect that startService() is not called.
     */
    public void testOnReceiveViewEventNoFriendKeyData() {
        EventStreamListener listener = new EventStreamListener();
        Intent intent = new Intent(PluginConstants.EventStream.VIEW_EVENT_ACTION);
        MockContext context = new MockContext();

        listener.onReceive(context, intent);

        assertNull("Expected startService() not to be called", context.getStartServiceIntent());
    }

    /**
     * Test onReceive with an action that is not handled by the EventStreamListener.
     * Expect that startService() is not called.
     */
    public void testOnReceiveIntentNotHandled() {
        EventStreamListener listener = new EventStreamListener();
        Intent intent = new Intent();
        MockContext context = new MockContext();

        listener.onReceive(context, intent);

        assertNull("Expected startService() not to be called", context.getStartServiceIntent());
    }

    /**
     * Test that the intent is correct.
     *
     * @param context our MockContext object
     * @param key the string to use to get the extra data
     * @param expectedValue what we expect from the extra string data.
     */
    private void assertCorrectIntent(MockContext context, String key, String expectedValue) {
        Intent startServiceIntent = context.getStartServiceIntent();
        String value = startServiceIntent.getStringExtra(key);
        assertEquals("Expected correct intent value ", expectedValue, value);
    }

    private class MockContext extends Context {
        private Intent mStartServiceIntent;

        @Override
        public boolean bindService(Intent arg0, ServiceConnection arg1, int arg2) {
            return false;
        }

        @Override
        public int checkCallingOrSelfPermission(String arg0) {
            return 0;
        }

        @Override
        public int checkCallingOrSelfUriPermission(Uri arg0, int arg1) {
            return 0;
        }

        @Override
        public int checkCallingPermission(String arg0) {
            return 0;
        }

        @Override
        public int checkCallingUriPermission(Uri arg0, int arg1) {
            return 0;
        }

        @Override
        public int checkPermission(String arg0, int arg1, int arg2) {
            return 0;
        }

        @Override
        public int checkUriPermission(Uri arg0, int arg1, int arg2, int arg3) {
            return 0;
        }

        @Override
        public int checkUriPermission(Uri arg0, String arg1, String arg2, int arg3, int arg4,
                int arg5) {
            return 0;
        }

        @Override
        public void clearWallpaper() throws IOException {
        }

        @Override
        public Context createPackageContext(String arg0, int arg1) throws NameNotFoundException {
            return null;
        }

        @Override
        public String[] databaseList() {
            return null;
        }

        @Override
        public boolean deleteDatabase(String arg0) {
            return false;
        }

        @Override
        public boolean deleteFile(String arg0) {
            return false;
        }

        @Override
        public void enforceCallingOrSelfPermission(String arg0, String arg1) {
        }

        @Override
        public void enforceCallingOrSelfUriPermission(Uri arg0, int arg1, String arg2) {
        }

        @Override
        public void enforceCallingPermission(String arg0, String arg1) {
        }

        @Override
        public void enforceCallingUriPermission(Uri arg0, int arg1, String arg2) {
        }

        @Override
        public void enforcePermission(String arg0, int arg1, int arg2, String arg3) {
        }

        @Override
        public void enforceUriPermission(Uri arg0, int arg1, int arg2, int arg3, String arg4) {
        }

        @Override
        public void enforceUriPermission(Uri arg0, String arg1, String arg2, int arg3, int arg4,
                int arg5, String arg6) {
        }

        @Override
        public String[] fileList() {
            return null;
        }

        @Override
        public Context getApplicationContext() {
            return null;
        }

        @Override
        public ApplicationInfo getApplicationInfo() {
            return null;
        }

        @Override
        public AssetManager getAssets() {
            return null;
        }

        @Override
        public File getCacheDir() {
            return null;
        }

        @Override
        public ClassLoader getClassLoader() {
            return null;
        }

        @Override
        public ContentResolver getContentResolver() {
            return null;
        }

        @Override
        public File getDatabasePath(String arg0) {
            return null;
        }

        @Override
        public File getDir(String arg0, int arg1) {
            return null;
        }

        @Override
        public File getExternalCacheDir() {
            return null;
        }

        @Override
        public File getExternalFilesDir(String arg0) {
            return null;
        }

        @Override
        public File getFileStreamPath(String arg0) {
            return null;
        }

        @Override
        public File getFilesDir() {
            return null;
        }

        @Override
        public Looper getMainLooper() {
            return null;
        }

        @Override
        public String getPackageCodePath() {
            return null;
        }

        @Override
        public PackageManager getPackageManager() {
            return null;
        }

        @Override
        public String getPackageName() {
            return null;
        }

        @Override
        public String getPackageResourcePath() {
            return null;
        }

        @Override
        public Resources getResources() {
            return null;
        }

        @Override
        public SharedPreferences getSharedPreferences(String arg0, int arg1) {
            return null;
        }

        @Override
        public Object getSystemService(String arg0) {
            return null;
        }

        @Override
        public Theme getTheme() {
            return null;
        }

        @Override
        public Drawable getWallpaper() {
            return null;
        }

        @Override
        public int getWallpaperDesiredMinimumHeight() {
            return 0;
        }

        @Override
        public int getWallpaperDesiredMinimumWidth() {
            return 0;
        }

        @Override
        public void grantUriPermission(String arg0, Uri arg1, int arg2) {
        }

        @Override
        public FileInputStream openFileInput(String arg0) throws FileNotFoundException {
            return null;
        }

        @Override
        public FileOutputStream openFileOutput(String arg0, int arg1) throws FileNotFoundException {
            return null;
        }

        @Override
        public SQLiteDatabase openOrCreateDatabase(String arg0, int arg1, CursorFactory arg2) {
            return null;
        }

        @Override
        public Drawable peekWallpaper() {
            return null;
        }

        @Override
        public Intent registerReceiver(BroadcastReceiver arg0, IntentFilter arg1) {
            return null;
        }

        @Override
        public Intent registerReceiver(BroadcastReceiver arg0, IntentFilter arg1, String arg2,
                Handler arg3) {
            return null;
        }

        @Override
        public void removeStickyBroadcast(Intent arg0) {
        }

        @Override
        public void revokeUriPermission(Uri arg0, int arg1) {
        }

        @Override
        public void sendBroadcast(Intent arg0) {
        }

        @Override
        public void sendBroadcast(Intent arg0, String arg1) {
        }

        @Override
        public void sendOrderedBroadcast(Intent arg0, String arg1) {
        }

        @Override
        public void sendOrderedBroadcast(Intent arg0, String arg1, BroadcastReceiver arg2,
                Handler arg3, int arg4, String arg5, Bundle arg6) {
        }

        @Override
        public void sendStickyBroadcast(Intent arg0) {
        }

        @Override
        public void sendStickyOrderedBroadcast(Intent arg0, BroadcastReceiver arg1, Handler arg2,
                int arg3, String arg4, Bundle arg5) {
        }

        @Override
        public void setTheme(int arg0) {
        }

        @Override
        public void setWallpaper(Bitmap arg0) throws IOException {
        }

        @Override
        public void setWallpaper(InputStream arg0) throws IOException {
        }

        @Override
        public void startActivity(Intent arg0) {
        }

        @Override
        public boolean startInstrumentation(ComponentName arg0, String arg1, Bundle arg2) {
            return false;
        }

        @Override
        public void startIntentSender(IntentSender arg0, Intent arg1, int arg2, int arg3, int arg4)
                throws SendIntentException {
        }

        @Override
        public ComponentName startService(Intent intent) {
            mStartServiceIntent = intent;
            return null;
        }

        @Override
        public boolean stopService(Intent arg0) {
            return false;
        }

        @Override
        public void unbindService(ServiceConnection arg0) {
        }

        @Override
        public void unregisterReceiver(BroadcastReceiver arg0) {
        }

        public Intent getStartServiceIntent() {
            return mStartServiceIntent;
        }
    }
}
