/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

/**
 * @file
 * @author Niklas Karlsson (niklas.karlsson@sonyericsson.com)
 */
package com.sonyericsson.eventstream.facebookplugin.util;

import com.sonyericsson.eventstream.facebookplugin.Facebook;
import com.sonyericsson.eventstream.facebookplugin.util.MockObject.FunctionCall.Result;

public class MockFacebook extends Facebook {

    public MockObject mMockObject = new MockObject();

    public MockFacebook(Settings settings) {
        super(settings);
    }

    @Override
    public void initialize() {
        mMockObject.reportFunctionCall("initialize", "");
    }

    @Override
    public synchronized boolean isLoggedIn() {
        Result returnValue = mMockObject.reportFunctionCall("isLoggedIn", "");
        if (returnValue != null) {
            return (Boolean)returnValue.mValue;
        }
        return false;
    }

    @Override
    public synchronized Facebook.ServiceState getState() {
        Result returnValue = mMockObject.reportFunctionCall("getState", "");
        if (returnValue != null) {
            return (Facebook.ServiceState)returnValue.mValue;
        }
        return Facebook.ServiceState.PASSIVE;
    }

    @Override
    public String authenticate(final String email, final String password) throws FacebookException {
        Result returnValue = mMockObject.reportFunctionCall("authenticate", email + ";" + password);
        if (returnValue != null) {
            return (String)returnValue.mValue;
        }
        return "MAGIC_STRING";
    }

    @Override
    public boolean updateStatus(String message) throws FacebookException {
        Result returnValue = mMockObject.reportFunctionCall("updateStatus", message);
        if (returnValue != null) {
            return (Boolean)returnValue.mValue;
        }
        return false;
    }

    @Override
    public boolean retrieveLatestPosts(EventStorage eventStorage, FriendStorage friendStorage) throws FacebookException {
        Result returnValue = mMockObject.reportFunctionCall("retrieveLatestPosts", String.valueOf(eventStorage));
        if (returnValue != null) {
            return (Boolean)returnValue.mValue;
        }
        return false;
    }

    @Override
    public boolean refreshFacebookFriends(FriendStorage storage) throws FacebookException {
        Result returnValue = mMockObject.reportFunctionCall("refreshFacebookFriends", String.valueOf(storage));
        if (returnValue != null) {
            return (Boolean)returnValue.mValue;
        }
        return false;
    }

    @Override
    public synchronized void setServiceStateListener(ServiceStateChangeListener callback) {
        mMockObject.reportFunctionCall("setServiceStateListener", String.valueOf(callback));
    }

    @Override
    public synchronized void removeServiceStateListener(ServiceStateChangeListener callback) {
        mMockObject.reportFunctionCall("removeServiceStateListener", String.valueOf(callback));
    }

    @Override
    public void shutdown() {
        mMockObject.reportFunctionCall("shutdown", "");
    }

    @Override
    public void close() {
        mMockObject.reportFunctionCall("close", "");
    }
}
