/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

/**
 * @file
 * @author Niklas Karlsson (niklas.karlsson@sonyericsson.com)
 */
package com.sonyericsson.eventstream.facebookplugin;

import static com.sonyericsson.eventstream.facebookplugin.Constants.API_KEY_PARAM;
import static com.sonyericsson.eventstream.facebookplugin.Constants.AUTH_LOGIN_METHOD;
import static com.sonyericsson.eventstream.facebookplugin.Constants.EMAIL_PARAM;
import static com.sonyericsson.eventstream.facebookplugin.Constants.METHOD_PARAM;
import static com.sonyericsson.eventstream.facebookplugin.Constants.PASSWORD_PARAM;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

import android.net.Uri;
import android.test.AndroidTestCase;

import java.util.ArrayList;
import java.util.List;

public class UFacebookPluginTestSecurity extends AndroidTestCase {

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGenerateAPIKey() {
        FacebookSecurity security = FacebookFactory.getFacebookSecurity();
        String key = security.generateAPIKey();

        assertNotNull("No API key!", key);
    }

    public void testSecretKey() {
        FacebookSecurity security = FacebookFactory.getFacebookSecurity();
        String key = security.generateSecretKey();

        assertNotNull("No secret key!", key);
    }

    public void testGenerateDeepLink() {
        final String USER_ID = "1111111";
        FacebookSecurity security = FacebookFactory.getFacebookSecurity();
        Uri uri = security.generateDeepLink(getContext(), USER_ID, "http://m.facebook.com");
        String uriString = uri.toString();

        assertNotNull("The URI is null", uri);
        assertNotNull("The URI doesn't contain the UID", uriString.contains(USER_ID));
    }

    public void testGenerateAuthenticationSignature() {
        FacebookSecurity security = FacebookFactory.getFacebookSecurity();
        List<NameValuePair> parameters = new ArrayList<NameValuePair>();

        parameters.add(new BasicNameValuePair(API_KEY_PARAM, "1111"));
        parameters.add(new BasicNameValuePair(EMAIL_PARAM, "test@gmail.com"));
        parameters.add(new BasicNameValuePair(METHOD_PARAM, AUTH_LOGIN_METHOD));
        parameters.add(new BasicNameValuePair(PASSWORD_PARAM, "pwd"));
        String signature = security.generateAuthenticationSignature(parameters);

        assertNotNull("No signature", signature);
    }
}