/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.calllogplugin;

import com.sonyericsson.eventstream.calllogplugin.PluginConstants.Config;
import com.sonyericsson.eventstream.calllogplugin.PluginConstants.EventStream;
import com.sonyericsson.eventstream.calllogplugin.PluginConstants.ServiceIntentCmd;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

/**
 * This BroadcastReceiver listens for incoming broadcasts from Event Stream.
 *
 * @auth Erik Hellman <erik.hellman@sonyericsson.com>
 */
public class EventStreamListener extends BroadcastReceiver {

    @Override
    public void onReceive(Context context, Intent intent) {
        launchCallLogService(context, intent);
    }

    public static void launchCallLogService(Context context, Intent intent) {
        String action = intent.getAction();
        Intent serviceIntent = new Intent();
        serviceIntent.setComponent(new ComponentName(context, CallLogPluginService.class));
        if (Config.DEBUG) {
            Log.d(Config.LOG_TAG, "got broadcast: " + action);
        }
        if (EventStream.EVENTSTREAM_REFRESH_ACTION.equals(action)) {
            if (Config.DEBUG) {
                Log.d(Config.LOG_TAG, "Recieved refresh request from Event Stream.");
            }
            serviceIntent.putExtra(ServiceIntentCmd.SERVICE_COMMAND_KEY, ServiceIntentCmd.CALLLOG_REFRESH_REQUEST);
        } else if (EventStream.EVENTSTREAM_REGISTER_ACTION.equals(action)) {
            if (Config.DEBUG) {
                Log.d(Config.LOG_TAG,
                        "Recieved plugin regsitration request from Event Stream.");
            }
            serviceIntent.putExtra(ServiceIntentCmd.SERVICE_COMMAND_KEY, ServiceIntentCmd.CALLLOG_REGISTER_PLUGIN);
        } else if (EventStream.EVENTSTREAM_VIEW_EVENT_ACTION.equals(action)) {
            if (Config.DEBUG) {
                Log.d(Config.LOG_TAG, "Recieved view event request from Event Stream.");
            }
            serviceIntent.putExtra(ServiceIntentCmd.SERVICE_COMMAND_KEY, ServiceIntentCmd.CALLLOG_VIEW_EVENT);
            String eventId = intent.getExtras().getString(EventStream.EVENTSTREAM_VIEW_EVENT_KEY_EXTRA);
            serviceIntent.putExtra(EventStream.EVENTSTREAM_VIEW_EVENT_KEY_EXTRA, eventId);
        }

        context.startService(serviceIntent);
    }
}
