/*
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __DRM_THREAD_SAFE_VECTOR_H__
#define __DRM_THREAD_SAFE_VECTOR_H__

#include <utils/threads.h>
#include <utils/Vector.h>

namespace android {

template <typename T>
class DrmThreadSafeVector {
public:
    DrmThreadSafeVector() {}

    DrmThreadSafeVector(const DrmThreadSafeVector<T>& rhs) {
        Mutex::Autolock lock(mLock);
        mVector(rhs);
    }

    inline void clear() {
         Mutex::Autolock lock(mLock);
         mVector.clear();
    }

    void push(const T& objectToPush) {
        Mutex::Autolock lock(mLock);
        mVector.push(objectToPush);
    }

    ssize_t add(const T& item) {
        Mutex::Autolock lock(mLock);
        return mVector.add(item);
    }

    inline const T& itemAt(size_t index) const {
        Mutex::Autolock lock(mLock);
        return mVector.itemAt(index);
    }

    inline size_t size() const {
        Mutex::Autolock lock(mLock);
        return mVector.size();
    }

    inline ssize_t removeAt(size_t index) {
        Mutex::Autolock lock(mLock);
        return mVector.removeAt(index);
    }

    Vector<T> getVector() const {
        // Returns a copy of the vector
        Mutex::Autolock lock(mLock);
        return mVector;
    }

    const T& operator[](size_t index) const {
        Mutex::Autolock lock(mLock);
        return mVector[index];
    }

private:
    mutable Mutex mLock;
    Vector<T> mVector;
};
}

#endif /* __DRM_THREAD_SAFE_VECTOR_H__ */
