/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import twitter4j.Annotation;
import twitter4j.Annotations;
import twitter4j.GeoLocation;
import twitter4j.internal.http.HttpParameter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatusUpdate
implements Serializable {
    private String status;
    private long inReplyToStatusId = -1L;
    private GeoLocation location = null;
    private String placeId = null;
    private boolean displayCoordinates = true;
    private Annotations annotations = null;
    private static final long serialVersionUID = -3595502688477609916L;

    public StatusUpdate(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public long getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    public void setInReplyToStatusId(long inReplyToStatusId) {
        this.inReplyToStatusId = inReplyToStatusId;
    }

    public StatusUpdate inReplyToStatusId(long inReplyToStatusId) {
        this.setInReplyToStatusId(inReplyToStatusId);
        return this;
    }

    public GeoLocation getLocation() {
        return this.location;
    }

    public void setLocation(GeoLocation location) {
        this.location = location;
    }

    public StatusUpdate location(GeoLocation location) {
        this.setLocation(location);
        return this;
    }

    public String getPlaceId() {
        return this.placeId;
    }

    public void setPlaceId(String placeId) {
        this.placeId = placeId;
    }

    public StatusUpdate placeId(String placeId) {
        this.setPlaceId(placeId);
        return this;
    }

    public boolean isDisplayCoordinates() {
        return this.displayCoordinates;
    }

    public void setDisplayCoordinates(boolean displayCoordinates) {
        this.displayCoordinates = displayCoordinates;
    }

    public StatusUpdate displayCoordinates(boolean displayCoordinates) {
        this.setDisplayCoordinates(displayCoordinates);
        return this;
    }

    public Annotations getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Annotations annotations) {
        this.annotations = annotations;
    }

    public StatusUpdate annotations(Annotations annotations) {
        this.setAnnotations(annotations);
        return this;
    }

    public void addAnnotation(Annotation annotation) {
        if (null == this.annotations) {
            this.annotations = new Annotations();
        }
        this.annotations.addAnnotation(annotation);
    }

    public StatusUpdate annotation(Annotation annotation) {
        this.addAnnotation(annotation);
        return this;
    }

    HttpParameter[] asHttpParameterArray() {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        this.appendParameter("status", this.status, params);
        if (-1L != this.inReplyToStatusId) {
            this.appendParameter("in_reply_to_status_id", this.inReplyToStatusId, (List<HttpParameter>)params);
        }
        if (null != this.location) {
            this.appendParameter("lat", this.location.getLatitude(), params);
            this.appendParameter("long", this.location.getLongitude(), params);
        }
        this.appendParameter("place_id", this.placeId, params);
        if (!this.displayCoordinates) {
            this.appendParameter("display_coordinates", "false", params);
        }
        if (null != this.annotations && !this.annotations.isEmpty()) {
            this.appendParameter("annotations", this.annotations.asParameterValue(), params);
        }
        HttpParameter[] paramArray = new HttpParameter[params.size()];
        return params.toArray(paramArray);
    }

    private void appendParameter(String name, String value, List<HttpParameter> params) {
        if (null != value) {
            params.add(new HttpParameter(name, value));
        }
    }

    private void appendParameter(String name, double value, List<HttpParameter> params) {
        params.add(new HttpParameter(name, String.valueOf(value)));
    }

    private void appendParameter(String name, long value, List<HttpParameter> params) {
        params.add(new HttpParameter(name, String.valueOf(value)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusUpdate that = (StatusUpdate)o;
        if (this.displayCoordinates != that.displayCoordinates) {
            return false;
        }
        if (this.inReplyToStatusId != that.inReplyToStatusId) {
            return false;
        }
        if (this.location != null ? !this.location.equals(that.location) : that.location != null) {
            return false;
        }
        if (this.placeId != null ? !this.placeId.equals(that.placeId) : that.placeId != null) {
            return false;
        }
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        return this.status.equals(that.status);
    }

    public int hashCode() {
        int result = this.status.hashCode();
        result = 31 * result + (int)(this.inReplyToStatusId ^ this.inReplyToStatusId >>> 32);
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + (this.placeId != null ? this.placeId.hashCode() : 0);
        result = 31 * result + (this.displayCoordinates ? 1 : 0);
        result = 31 * result + (this.annotations != null ? this.annotations.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new StringBuffer().append("StatusUpdate{status='").append(this.status).append('\'').append(", inReplyToStatusId=").append(this.inReplyToStatusId).append(", location=").append(this.location).append(", placeId='").append(this.placeId).append('\'').append(", displayCoordinates=").append(this.displayCoordinates).append(", annotations=").append(this.annotations).append('}').toString();
    }
}

