/* Copyright (c) 2010, Code Aurora Forum. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 */
#include <linux/module.h>
#include <linux/delay.h>
#include <linux/err.h>
#include <linux/platform_device.h>
#include <linux/mfd/msm-adie-codec.h>
#include <linux/mfd/marimba.h>
#include <linux/mfd/timpani-audio.h>
#include <linux/debugfs.h>
#include <linux/uaccess.h>
#include <linux/string.h>

/* Timpani codec driver is activated through Marimba core driver */

#define MAX_MDELAY_US 20000

struct adie_codec_path {
	struct adie_codec_dev_profile *profile;
	struct adie_codec_register_image img;
	u32 hwsetting_idx;
	u32 stage_idx;
	u32 curr_stage;
	u32 reg_owner;
};

enum /* regaccess blk id */
{
	RA_BLOCK_RX1 = 0,
	RA_BLOCK_RX2,
	RA_BLOCK_TX1,
	RA_BLOCK_TX2,
	RA_BLOCK_LB,
	RA_BLOCK_SHARED_RX_LB,
	RA_BLOCK_SHARED_TX,
	RA_BLOCK_TXFE1,
	RA_BLOCK_TXFE2,
	RA_BLOCK_PA_COMMON,
	RA_BLOCK_PA_EAR,
	RA_BLOCK_PA_HPH,
	RA_BLOCK_PA_LINE,
	RA_BLOCK_PA_AUX,
	RA_BLOCK_ADC,
	RA_BLOCK_DMIC,
	RA_BLOCK_TX_I2S,
	RA_BLOCK_DRV,
	RA_BLOCK_TEST,
	RA_BLOCK_RESERVED,
	RA_BLOCK_NUM,
};

enum /* regaccess onwer ID */
{
	RA_OWNER_NONE = 0,
	RA_OWNER_PATH_RX1,
	RA_OWNER_PATH_RX2,
	RA_OWNER_PATH_TX1,
	RA_OWNER_PATH_TX2,
	RA_OWNER_PATH_LB,
	RA_OWNER_DRV,
	RA_OWNER_NUM,
};

struct reg_acc_blk_cfg {
	u8 valid_owners[RA_OWNER_NUM];
};

struct timpani_regaccess {
	u8 reg_addr;
	u8 blk_mask[RA_BLOCK_NUM];
	u8 reg_mask;
	u8 reg_default;
};

struct timpani_regaccess timpani_regset[] = {
	{
		TIMPANI_A_MREF,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xFC, 0x0, 0x3},
		TIMPANI_MREF_M,
		TIMPANI_MREF_POR
	},
	{
		TIMPANI_A_CDAC_IDAC_REF_CUR,
		{0xFC, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDAC_IDAC_REF_CUR_M,
		TIMPANI_CDAC_IDAC_REF_CUR_POR
	},
	{
		TIMPANI_A_TXADC12_REF_CURR,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF},
		TIMPANI_TXADC12_REF_CURR_M,
		TIMPANI_TXADC12_REF_CURR_POR
	},
	{
		TIMPANI_A_TXADC3_EN,
		{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFE, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1},
		TIMPANI_TXADC3_EN_M,
		TIMPANI_TXADC3_EN_POR
	},
	{
		TIMPANI_A_TXADC4_EN,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFE, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1},
		TIMPANI_TXADC4_EN_M,
		TIMPANI_TXADC4_EN_POR
	},
	{
		TIMPANI_A_CODEC_TXADC_STATUS_REGISTER_1,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xC0, 0x30, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xF},
		TIMPANI_CODEC_TXADC_STATUS_REGISTER_1_M,
		TIMPANI_CODEC_TXADC_STATUS_REGISTER_1_POR
	},
	{
		TIMPANI_A_TXFE1,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_TXFE1_M,
		TIMPANI_TXFE1_POR
	},
	{
		TIMPANI_A_TXFE2,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_TXFE2_M,
		TIMPANI_TXFE2_POR
	},
	{
		TIMPANI_A_TXFE12_ATEST,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_TXFE12_ATEST_M,
		TIMPANI_TXFE12_ATEST_POR
	},
	{
		TIMPANI_A_TXFE_CLT,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xF8, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7},
		TIMPANI_TXFE_CLT_M,
		TIMPANI_TXFE_CLT_POR
	},
	{
		TIMPANI_A_TXADC1_EN,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFE, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1},
		TIMPANI_TXADC1_EN_M,
		TIMPANI_TXADC1_EN_POR
	},
	{
		TIMPANI_A_TXADC2_EN,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFE, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1},
		TIMPANI_TXADC2_EN_M,
		TIMPANI_TXADC2_EN_POR
	},
	{
		TIMPANI_A_TXADC_CTL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_TXADC_CTL_M,
		TIMPANI_TXADC_CTL_POR
	},
	{
		TIMPANI_A_TXADC_CTL2,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_TXADC_CTL2_M,
		TIMPANI_TXADC_CTL2_POR
	},
	{
		TIMPANI_A_TXADC_CTL3,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0xFE, 0x0, 0x0, 0x0, 0x0, 0x1},
		TIMPANI_TXADC_CTL3_M,
		TIMPANI_TXADC_CTL3_POR
	},
	{
		TIMPANI_A_TXADC_CHOP_CTL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0xFC, 0x0, 0x0, 0x0, 0x0, 0x3},
		TIMPANI_TXADC_CHOP_CTL_M,
		TIMPANI_TXADC_CHOP_CTL_POR
	},
	{
		TIMPANI_A_TXFE3,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xE2, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1D},
		TIMPANI_TXFE3_M,
		TIMPANI_TXFE3_POR
	},
	{
		TIMPANI_A_TXFE4,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xE2, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1D},
		TIMPANI_TXFE4_M,
		TIMPANI_TXFE4_POR
	},
	{
		TIMPANI_A_TXFE3_ATEST,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_TXFE3_ATEST_M,
		TIMPANI_TXFE3_ATEST_POR
	},
	{
		TIMPANI_A_TXFE_DIFF_SE,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xC, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xF0},
		TIMPANI_TXFE_DIFF_SE_M,
		TIMPANI_TXFE_DIFF_SE_POR
	},
	{
		TIMPANI_A_CDAC_RX_CLK_CTL,
		{0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDAC_RX_CLK_CTL_M,
		TIMPANI_CDAC_RX_CLK_CTL_POR
	},
	{
		TIMPANI_A_CDAC_BUFF_CTL,
		{0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDAC_BUFF_CTL_M,
		TIMPANI_CDAC_BUFF_CTL_POR
	},
	{
		TIMPANI_A_CDAC_REF_CTL1,
		{0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDAC_REF_CTL1_M,
		TIMPANI_CDAC_REF_CTL1_POR
	},
	{
		TIMPANI_A_IDAC_DWA_FIR_CTL,
		{0xF8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7},
		TIMPANI_IDAC_DWA_FIR_CTL_M,
		TIMPANI_IDAC_DWA_FIR_CTL_POR
	},
	{
		TIMPANI_A_CDAC_REF_CTL2,
		{0x6F, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x90},
		TIMPANI_CDAC_REF_CTL2_M,
		TIMPANI_CDAC_REF_CTL2_POR
	},
	{
		TIMPANI_A_CDAC_CTL1,
		{0x7F, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x80},
		TIMPANI_CDAC_CTL1_M,
		TIMPANI_CDAC_CTL1_POR
	},
	{
		TIMPANI_A_CDAC_CTL2,
		{0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDAC_CTL2_M,
		TIMPANI_CDAC_CTL2_POR
	},
	{
		TIMPANI_A_IDAC_L_CTL,
		{0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_IDAC_L_CTL_M,
		TIMPANI_IDAC_L_CTL_POR
	},
	{
		TIMPANI_A_IDAC_R_CTL,
		{0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_IDAC_R_CTL_M,
		TIMPANI_IDAC_R_CTL_POR
	},
	{
		TIMPANI_A_PA_MASTER_BIAS,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1F,
		0xE0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_PA_MASTER_BIAS_M,
		TIMPANI_PA_MASTER_BIAS_POR
	},
	{
		TIMPANI_A_PA_CLASSD_BIAS,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_PA_CLASSD_BIAS_M,
		TIMPANI_PA_CLASSD_BIAS_POR
	},
	{
		TIMPANI_A_AUXPGA_CUR,
		{0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_AUXPGA_CUR_M,
		TIMPANI_AUXPGA_CUR_POR
	},
	{
		TIMPANI_A_AUXPGA_CM,
		{0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_AUXPGA_CM_M,
		TIMPANI_AUXPGA_CM_POR
	},
	{
		TIMPANI_A_PA_HPH_EARPA_MSTB_EN,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0xFC,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_PA_HPH_EARPA_MSTB_EN_M,
		TIMPANI_PA_HPH_EARPA_MSTB_EN_POR
	},
	{
		TIMPANI_A_PA_LINE_AUXO_EN,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0xF8, 0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_PA_LINE_AUXO_EN_M,
		TIMPANI_PA_LINE_AUXO_EN_POR
	},
	{
		TIMPANI_A_PA_CLASSD_AUXPGA_EN,
		{0x0, 0x0, 0x0, 0x0, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xF,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xC0},
		TIMPANI_PA_CLASSD_AUXPGA_EN_M,
		TIMPANI_PA_CLASSD_AUXPGA_EN_POR
	},
	{
		TIMPANI_A_PA_LINE_L_GAIN,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xFC, 0x0, 0x3},
		TIMPANI_PA_LINE_L_GAIN_M,
		TIMPANI_PA_LINE_L_GAIN_POR
	},
	{
		TIMPANI_A_PA_LINE_R_GAIN,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xFC, 0x0, 0x3},
		TIMPANI_PA_LINE_R_GAIN_M,
		TIMPANI_PA_LINE_R_GAIN_POR
	},
	{
		TIMPANI_A_PA_HPH_L_GAIN,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xFE, 0x0, 0x1},
		TIMPANI_PA_HPH_L_GAIN_M,
		TIMPANI_PA_HPH_L_GAIN_POR
	},
	{
		TIMPANI_A_PA_HPH_R_GAIN,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xFE, 0x0, 0x1},
		TIMPANI_PA_HPH_R_GAIN_M,
		TIMPANI_PA_HPH_R_GAIN_POR
	},
	{
		TIMPANI_A_AUXPGA_LR_GAIN,
		{0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_AUXPGA_LR_GAIN_M,
		TIMPANI_AUXPGA_LR_GAIN_POR
	},
	{
		TIMPANI_A_PA_AUXO_EARPA_CONN,
		{0x21, 0x42, 0x0, 0x0, 0x84, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x18},
		TIMPANI_PA_AUXO_EARPA_CONN_M,
		TIMPANI_PA_AUXO_EARPA_CONN_POR
	},
	{
		TIMPANI_A_PA_LINE_ST_CONN,
		{0x24, 0x48, 0x0, 0x0, 0x93, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_PA_LINE_ST_CONN_M,
		TIMPANI_PA_LINE_ST_CONN_POR
	},
	{
		TIMPANI_A_PA_LINE_MONO_CONN,
		{0x24, 0x48, 0x0, 0x0, 0x93, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_PA_LINE_MONO_CONN_M,
		TIMPANI_PA_LINE_MONO_CONN_POR
	},
	{
		TIMPANI_A_PA_HPH_ST_CONN,
		{0x24, 0x48, 0x0, 0x0, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_PA_HPH_ST_CONN_M,
		TIMPANI_PA_HPH_ST_CONN_POR
	},
	{
		TIMPANI_A_PA_HPH_MONO_CONN,
		{0x24, 0x48, 0x0, 0x0, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3},
		TIMPANI_PA_HPH_MONO_CONN_M,
		TIMPANI_PA_HPH_MONO_CONN_POR
	},
	{
		TIMPANI_A_PA_CLASSD_CONN,
		{0x80, 0x40, 0x0, 0x0, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xF},
		TIMPANI_PA_CLASSD_CONN_M,
		TIMPANI_PA_CLASSD_CONN_POR
	},
	{
		TIMPANI_A_PA_CNP_CTL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xCF,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x30},
		TIMPANI_PA_CNP_CTL_M,
		TIMPANI_PA_CNP_CTL_POR
	},
	{
		TIMPANI_A_PA_CLASSD_L_CTL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3F,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xC0},
		TIMPANI_PA_CLASSD_L_CTL_M,
		TIMPANI_PA_CLASSD_L_CTL_POR
	},
	{
		TIMPANI_A_PA_CLASSD_R_CTL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3F,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xC0},
		TIMPANI_PA_CLASSD_R_CTL_M,
		TIMPANI_PA_CLASSD_R_CTL_POR
	},
	{
		TIMPANI_A_PA_CLASSD_INT2_CTL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_PA_CLASSD_INT2_CTL_M,
		TIMPANI_PA_CLASSD_INT2_CTL_POR
	},
	{
		TIMPANI_A_PA_HPH_L_OCP_CLK_CTL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_PA_HPH_L_OCP_CLK_CTL_M,
		TIMPANI_PA_HPH_L_OCP_CLK_CTL_POR
	},
	{
		TIMPANI_A_PA_CLASSD_L_SW_CTL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xF7,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8},
		TIMPANI_PA_CLASSD_L_SW_CTL_M,
		TIMPANI_PA_CLASSD_L_SW_CTL_POR
	},
	{
		TIMPANI_A_PA_CLASSD_L_OCP1,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_PA_CLASSD_L_OCP1_M,
		TIMPANI_PA_CLASSD_L_OCP1_POR
	},
	{
		TIMPANI_A_PA_CLASSD_L_OCP2,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_PA_CLASSD_L_OCP2_M,
		TIMPANI_PA_CLASSD_L_OCP2_POR
	},
	{
		TIMPANI_A_PA_HPH_R_OCP_CLK_CTL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_PA_HPH_R_OCP_CLK_CTL_M,
		TIMPANI_PA_HPH_R_OCP_CLK_CTL_POR
	},
	{
		TIMPANI_A_PA_CLASSD_R_SW_CTL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xF7,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8},
		TIMPANI_PA_CLASSD_R_SW_CTL_M,
		TIMPANI_PA_CLASSD_R_SW_CTL_POR
	},
	{
		TIMPANI_A_PA_CLASSD_R_OCP1,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_PA_CLASSD_R_OCP1_M,
		TIMPANI_PA_CLASSD_R_OCP1_POR
	},
	{
		TIMPANI_A_PA_CLASSD_R_OCP2,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_PA_CLASSD_R_OCP2_M,
		TIMPANI_PA_CLASSD_R_OCP2_POR
	},
	{
		TIMPANI_A_PA_HPH_CTL1,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF},
		TIMPANI_PA_HPH_CTL1_M,
		TIMPANI_PA_HPH_CTL1_POR
	},
	{
		TIMPANI_A_PA_HPH_CTL2,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFE,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1},
		TIMPANI_PA_HPH_CTL2_M,
		TIMPANI_PA_HPH_CTL2_POR
	},
	{
		TIMPANI_A_PA_LINE_AUXO_CTL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0xC3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x3C, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_PA_LINE_AUXO_CTL_M,
		TIMPANI_PA_LINE_AUXO_CTL_POR
	},
	{
		TIMPANI_A_PA_AUXO_EARPA_CTL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x0,
		0x0, 0x38, 0x0, 0x0, 0x0, 0x0, 0x0, 0xC0},
		TIMPANI_PA_AUXO_EARPA_CTL_M,
		TIMPANI_PA_AUXO_EARPA_CTL_POR
	},
	{
		TIMPANI_A_PA_EARO_CTL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_PA_EARO_CTL_M,
		TIMPANI_PA_EARO_CTL_POR
	},
	{
		TIMPANI_A_PA_MASTER_BIAS_CUR,
		{0x0, 0x0, 0x0, 0x0, 0x60, 0x0, 0x0, 0x0, 0x0, 0x80, 0x0, 0x18,
		0x6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1},
		TIMPANI_PA_MASTER_BIAS_CUR_M,
		TIMPANI_PA_MASTER_BIAS_CUR_POR
	},
	{
		TIMPANI_A_PA_CLASSD_SC_STATUS,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xCC,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x33},
		TIMPANI_PA_CLASSD_SC_STATUS_M,
		TIMPANI_PA_CLASSD_SC_STATUS_POR
	},
	{
		TIMPANI_A_PA_HPH_SC_STATUS,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x88,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x77},
		TIMPANI_PA_HPH_SC_STATUS_M,
		TIMPANI_PA_HPH_SC_STATUS_POR
	},
	{
		TIMPANI_A_ATEST_EN,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x80, 0x7F},
		TIMPANI_ATEST_EN_M,
		TIMPANI_ATEST_EN_POR
	},
	{
		TIMPANI_A_ATEST_TSHKADC,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xF, 0xF0},
		TIMPANI_ATEST_TSHKADC_M,
		TIMPANI_ATEST_TSHKADC_POR
	},
	{
		TIMPANI_A_ATEST_TXADC13,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7F, 0x80},
		TIMPANI_ATEST_TXADC13_M,
		TIMPANI_ATEST_TXADC13_POR
	},
	{
		TIMPANI_A_ATEST_TXADC24,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7F, 0x80},
		TIMPANI_ATEST_TXADC24_M,
		TIMPANI_ATEST_TXADC24_POR
	},
	{
		TIMPANI_A_ATEST_AUXPGA,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xF8, 0x7},
		TIMPANI_ATEST_AUXPGA_M,
		TIMPANI_ATEST_AUXPGA_POR
	},
	{
		TIMPANI_A_ATEST_CDAC,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0},
		TIMPANI_ATEST_CDAC_M,
		TIMPANI_ATEST_CDAC_POR
	},
	{
		TIMPANI_A_ATEST_IDAC,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0},
		TIMPANI_ATEST_IDAC_M,
		TIMPANI_ATEST_IDAC_POR
	},
	{
		TIMPANI_A_ATEST_PA1,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0},
		TIMPANI_ATEST_PA1_M,
		TIMPANI_ATEST_PA1_POR
	},
	{
		TIMPANI_A_ATEST_CLASSD,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0},
		TIMPANI_ATEST_CLASSD_M,
		TIMPANI_ATEST_CLASSD_POR
	},
	{
		TIMPANI_A_ATEST_LINEO_AUXO,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0},
		TIMPANI_ATEST_LINEO_AUXO_M,
		TIMPANI_ATEST_LINEO_AUXO_POR
	},
	{
		TIMPANI_A_CDC_RESET_CTL,
		{0x2, 0x8, 0x5, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xC0},
		TIMPANI_CDC_RESET_CTL_M,
		TIMPANI_CDC_RESET_CTL_POR
	},
	{
		TIMPANI_A_CDC_RX1_CTL,
		{0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_RX1_CTL_M,
		TIMPANI_CDC_RX1_CTL_POR
	},
	{
		TIMPANI_A_CDC_TX_I2S_CTL,
		{0x0, 0x0, 0x10, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0xF, 0x0, 0x0, 0xC0},
		TIMPANI_CDC_TX_I2S_CTL_M,
		TIMPANI_CDC_TX_I2S_CTL_POR
	},
	{
		TIMPANI_A_CDC_CH_CTL,
		{0x3, 0x30, 0xC, 0xC0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_CH_CTL_M,
		TIMPANI_CDC_CH_CTL_POR
	},
	{
		TIMPANI_A_CDC_RX1LG,
		{0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_RX1LG_M,
		TIMPANI_CDC_RX1LG_POR
	},
	{
		TIMPANI_A_CDC_RX1RG,
		{0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_RX1RG_M,
		TIMPANI_CDC_RX1RG_POR
	},
	{
		TIMPANI_A_CDC_TX1LG,
		{0x0, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_TX1LG_M,
		TIMPANI_CDC_TX1LG_POR
	},
	{
		TIMPANI_A_CDC_TX1RG,
		{0x0, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_TX1RG_M,
		TIMPANI_CDC_TX1RG_POR
	},
	{
		TIMPANI_A_CDC_RX_PGA_TIMER,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_RX_PGA_TIMER_M,
		TIMPANI_CDC_RX_PGA_TIMER_POR
	},
	{
		TIMPANI_A_CDC_TX_PGA_TIMER,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_TX_PGA_TIMER_M,
		TIMPANI_CDC_TX_PGA_TIMER_POR
	},
	{
		TIMPANI_A_CDC_GCTL1,
		{0xF, 0x0, 0xF0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_GCTL1_M,
		TIMPANI_CDC_GCTL1_POR
	},
	{
		TIMPANI_A_CDC_TX1L_STG,
		{0x0, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_TX1L_STG_M,
		TIMPANI_CDC_TX1L_STG_POR
	},
	{
		TIMPANI_A_CDC_ST_CTL,
		{0x0, 0xF, 0x0, 0xF0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_ST_CTL_M,
		TIMPANI_CDC_ST_CTL_POR
	},
	{
		TIMPANI_A_CDC_RX1L_DCOFFSET,
		{0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_RX1L_DCOFFSET_M,
		TIMPANI_CDC_RX1L_DCOFFSET_POR
	},
	{
		TIMPANI_A_CDC_RX1R_DCOFFSET,
		{0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_RX1R_DCOFFSET_M,
		TIMPANI_CDC_RX1R_DCOFFSET_POR
	},
	{
		TIMPANI_A_CDC_BYPASS_CTL1,
		{0xF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xF0},
		TIMPANI_CDC_BYPASS_CTL1_M,
		TIMPANI_CDC_BYPASS_CTL1_POR
	},
	{
		TIMPANI_A_CDC_PDM_CONFIG,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xF, 0xF0},
		TIMPANI_CDC_PDM_CONFIG_M,
		TIMPANI_CDC_PDM_CONFIG_POR
	},
	{
		TIMPANI_A_CDC_TESTMODE1,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3F, 0xC0},
		TIMPANI_CDC_TESTMODE1_M,
		TIMPANI_CDC_TESTMODE1_POR
	},
	{
		TIMPANI_A_CDC_DMIC_CLK_CTL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x3F, 0x0, 0x0, 0x0, 0xC0},
		TIMPANI_CDC_DMIC_CLK_CTL_M,
		TIMPANI_CDC_DMIC_CLK_CTL_POR
	},
	{
		TIMPANI_A_CDC_ADC12_CLK_CTL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_ADC12_CLK_CTL_M,
		TIMPANI_CDC_ADC12_CLK_CTL_POR
	},
	{
		TIMPANI_A_CDC_TX1_CTL,
		{0x0, 0x0, 0x3F, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xC0},
		TIMPANI_CDC_TX1_CTL_M,
		TIMPANI_CDC_TX1_CTL_POR
	},
	{
		TIMPANI_A_CDC_ADC34_CLK_CTL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_ADC34_CLK_CTL_M,
		TIMPANI_CDC_ADC34_CLK_CTL_POR
	},
	{
		TIMPANI_A_CDC_TX2_CTL,
		{0x0, 0x0, 0x0, 0x3F, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xC0},
		TIMPANI_CDC_TX2_CTL_M,
		TIMPANI_CDC_TX2_CTL_POR
	},
	{
		TIMPANI_A_CDC_RX1_CLK_CTL,
		{0x1F, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xE0},
		TIMPANI_CDC_RX1_CLK_CTL_M,
		TIMPANI_CDC_RX1_CLK_CTL_POR
	},
	{
		TIMPANI_A_CDC_RX2_CLK_CTL,
		{0x1F, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xE0},
		TIMPANI_CDC_RX2_CLK_CTL_M,
		TIMPANI_CDC_RX2_CLK_CTL_POR
	},
	{
		TIMPANI_A_CDC_DEC_ADC_SEL,
		{0x0, 0x0, 0xF, 0xF0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_DEC_ADC_SEL_M,
		TIMPANI_CDC_DEC_ADC_SEL_POR
	},
	{
		TIMPANI_A_CDC_ANC_INPUT_MUX,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x3F, 0x0, 0xC0},
		TIMPANI_CDC_ANC_INPUT_MUX_M,
		TIMPANI_CDC_ANC_INPUT_MUX_POR
	},
	{
		TIMPANI_A_CDC_ANC_RX_CLK_NS_SEL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0xFE},
		TIMPANI_CDC_ANC_RX_CLK_NS_SEL_M,
		TIMPANI_CDC_ANC_RX_CLK_NS_SEL_POR
	},
	{
		TIMPANI_A_CDC_ANC_FB_TUNE_SEL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF},
		TIMPANI_CDC_ANC_FB_TUNE_SEL_M,
		TIMPANI_CDC_ANC_FB_TUNE_SEL_POR
	},
	{
		TIMPANI_A_CLK_DIV_SYNC_CTL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0xFC},
		TIMPANI_CLK_DIV_SYNC_CTL_M,
		TIMPANI_CLK_DIV_SYNC_CTL_POR
	},
	{
		TIMPANI_A_CDC_ADC_CLK_EN,
		{0x0, 0x0, 0x3, 0xC, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xF0},
		TIMPANI_CDC_ADC_CLK_EN_M,
		TIMPANI_CDC_ADC_CLK_EN_POR
	},
	{
		TIMPANI_A_CDC_ST_MIXING,
		{0x0, 0x0, 0x3, 0xC, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xF0},
		TIMPANI_CDC_ST_MIXING_M,
		TIMPANI_CDC_ST_MIXING_POR
	},
	{
		TIMPANI_A_CDC_RX2_CTL,
		{0x0, 0x7F, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x80},
		TIMPANI_CDC_RX2_CTL_M,
		TIMPANI_CDC_RX2_CTL_POR
	},
	{
		TIMPANI_A_CDC_ARB_CLK_EN,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF},
		TIMPANI_CDC_ARB_CLK_EN_M,
		TIMPANI_CDC_ARB_CLK_EN_POR
	},
	{
		TIMPANI_A_CDC_I2S_CTL2,
		{0x2, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x39, 0x0, 0x0, 0xC0},
		TIMPANI_CDC_I2S_CTL2_M,
		TIMPANI_CDC_I2S_CTL2_POR
	},
	{
		TIMPANI_A_CDC_RX2LG,
		{0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_RX2LG_M,
		TIMPANI_CDC_RX2LG_POR
	},
	{
		TIMPANI_A_CDC_RX2RG,
		{0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_RX2RG_M,
		TIMPANI_CDC_RX2RG_POR
	},
	{
		TIMPANI_A_CDC_TX2LG,
		{0x0, 0x0, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_TX2LG_M,
		TIMPANI_CDC_TX2LG_POR
	},
	{
		TIMPANI_A_CDC_TX2RG,
		{0x0, 0x0, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_TX2RG_M,
		TIMPANI_CDC_TX2RG_POR
	},
	{
		TIMPANI_A_CDC_DMIC_MUX,
		{0x0, 0x0, 0xF, 0xF0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_DMIC_MUX_M,
		TIMPANI_CDC_DMIC_MUX_POR
	},
	{
		TIMPANI_A_CDC_ARB_CLK_CTL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0xFC},
		TIMPANI_CDC_ARB_CLK_CTL_M,
		TIMPANI_CDC_ARB_CLK_CTL_POR
	},
	{
		TIMPANI_A_CDC_GCTL2,
		{0x0, 0xF, 0x0, 0xF0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_GCTL2_M,
		TIMPANI_CDC_GCTL2_POR
	},
	{
		TIMPANI_A_CDC_BYPASS_CTL2,
		{0x0, 0x0, 0x3F, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xC0},
		TIMPANI_CDC_BYPASS_CTL2_M,
		TIMPANI_CDC_BYPASS_CTL2_POR
	},
	{
		TIMPANI_A_CDC_BYPASS_CTL3,
		{0x0, 0x0, 0x0, 0x3F, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xC0},
		TIMPANI_CDC_BYPASS_CTL3_M,
		TIMPANI_CDC_BYPASS_CTL3_POR
	},
	{
		TIMPANI_A_CDC_BYPASS_CTL4,
		{0x0, 0xF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xF0},
		TIMPANI_CDC_BYPASS_CTL4_M,
		TIMPANI_CDC_BYPASS_CTL4_POR
	},
	{
		TIMPANI_A_CDC_RX2L_DCOFFSET,
		{0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_RX2L_DCOFFSET_M,
		TIMPANI_CDC_RX2L_DCOFFSET_POR
	},
	{
		TIMPANI_A_CDC_RX2R_DCOFFSET,
		{0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_RX2R_DCOFFSET_M,
		TIMPANI_CDC_RX2R_DCOFFSET_POR
	},
	{
		TIMPANI_A_CDC_RX_MIX_CTL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0xFC},
		TIMPANI_CDC_RX_MIX_CTL_M,
		TIMPANI_CDC_RX_MIX_CTL_POR
	},
	{
		TIMPANI_A_CDC_SPARE_CTL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xFE},
		TIMPANI_CDC_SPARE_CTL_M,
		TIMPANI_CDC_SPARE_CTL_POR
	},
	{
		TIMPANI_A_CDC_TESTMODE2,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1F, 0xE0},
		TIMPANI_CDC_TESTMODE2_M,
		TIMPANI_CDC_TESTMODE2_POR
	},
	{
		TIMPANI_A_CDC_PDM_OE,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0},
		TIMPANI_CDC_PDM_OE_M,
		TIMPANI_CDC_PDM_OE_POR
	},
	{
		TIMPANI_A_CDC_TX1R_STG,
		{0x0, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_TX1R_STG_M,
		TIMPANI_CDC_TX1R_STG_POR
	},
	{
		TIMPANI_A_CDC_TX2L_STG,
		{0x0, 0x0, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_TX2L_STG_M,
		TIMPANI_CDC_TX2L_STG_POR
	},
	{
		TIMPANI_A_CDC_TX2R_STG,
		{0x0, 0x0, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
		TIMPANI_CDC_TX2R_STG_M,
		TIMPANI_CDC_TX2R_STG_POR
	},
	{
		TIMPANI_A_CDC_ARB_BYPASS_CTL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF},
		TIMPANI_CDC_ARB_BYPASS_CTL_M,
		TIMPANI_CDC_ARB_BYPASS_CTL_POR
	},
	{
		TIMPANI_A_CDC_ANC1_CTL1,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x1F, 0x0, 0xE0},
		TIMPANI_CDC_ANC1_CTL1_M,
		TIMPANI_CDC_ANC1_CTL1_POR
	},
	{
		TIMPANI_A_CDC_ANC1_CTL2,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x3F, 0x0, 0xC0},
		TIMPANI_CDC_ANC1_CTL2_M,
		TIMPANI_CDC_ANC1_CTL2_POR
	},
	{
		TIMPANI_A_CDC_ANC1_FF_FB_SHIFT,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0},
		TIMPANI_CDC_ANC1_FF_FB_SHIFT_M,
		TIMPANI_CDC_ANC1_FF_FB_SHIFT_POR
	},
	{
		TIMPANI_A_CDC_ANC1_RX_NS,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x0, 0xF8},
		TIMPANI_CDC_ANC1_RX_NS_M,
		TIMPANI_CDC_ANC1_RX_NS_POR
	},
	{
		TIMPANI_A_CDC_ANC1_SPARE,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0},
		TIMPANI_CDC_ANC1_SPARE_M,
		TIMPANI_CDC_ANC1_SPARE_POR
	},
	{
		TIMPANI_A_CDC_ANC1_IIR_COEFF_PTR,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x1F, 0x0, 0xE0},
		TIMPANI_CDC_ANC1_IIR_COEFF_PTR_M,
		TIMPANI_CDC_ANC1_IIR_COEFF_PTR_POR
	},
	{
		TIMPANI_A_CDC_ANC1_IIR_COEFF_MSB,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0xFE},
		TIMPANI_CDC_ANC1_IIR_COEFF_MSB_M,
		TIMPANI_CDC_ANC1_IIR_COEFF_MSB_POR
	},
	{
		TIMPANI_A_CDC_ANC1_IIR_COEFF_LSB,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0},
		TIMPANI_CDC_ANC1_IIR_COEFF_LSB_M,
		TIMPANI_CDC_ANC1_IIR_COEFF_LSB_POR
	},
	{
		TIMPANI_A_CDC_ANC1_IIR_COEFF_CTL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0xFC},
		TIMPANI_CDC_ANC1_IIR_COEFF_CTL_M,
		TIMPANI_CDC_ANC1_IIR_COEFF_CTL_POR
	},
	{
		TIMPANI_A_CDC_ANC1_LPF_COEFF_PTR,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xF, 0x0, 0xF0},
		TIMPANI_CDC_ANC1_LPF_COEFF_PTR_M,
		TIMPANI_CDC_ANC1_LPF_COEFF_PTR_POR
	},
	{
		TIMPANI_A_CDC_ANC1_LPF_COEFF_MSB,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xF, 0x0, 0xF0},
		TIMPANI_CDC_ANC1_LPF_COEFF_MSB_M,
		TIMPANI_CDC_ANC1_LPF_COEFF_MSB_POR
	},
	{
		TIMPANI_A_CDC_ANC1_LPF_COEFF_LSB,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0},
		TIMPANI_CDC_ANC1_LPF_COEFF_LSB_M,
		TIMPANI_CDC_ANC1_LPF_COEFF_LSB_POR
	},
	{
		TIMPANI_A_CDC_ANC1_SCALE_PTR,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0},
		TIMPANI_CDC_ANC1_SCALE_PTR_M,
		TIMPANI_CDC_ANC1_SCALE_PTR_POR
	},
	{
		TIMPANI_A_CDC_ANC1_SCALE,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0},
		TIMPANI_CDC_ANC1_SCALE_M,
		TIMPANI_CDC_ANC1_SCALE_POR
	},
	{
		TIMPANI_A_CDC_ANC1_DEBUG,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xF, 0x0, 0xF0},
		TIMPANI_CDC_ANC1_DEBUG_M,
		TIMPANI_CDC_ANC1_DEBUG_POR
	},
	{
		TIMPANI_A_CDC_ANC2_CTL1,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x1F, 0x0, 0xE0},
		TIMPANI_CDC_ANC2_CTL1_M,
		TIMPANI_CDC_ANC2_CTL1_POR
	},
	{
		TIMPANI_A_CDC_ANC2_CTL2,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x3F, 0x0, 0xC0},
		TIMPANI_CDC_ANC2_CTL2_M,
		TIMPANI_CDC_ANC2_CTL2_POR
	},
	{
		TIMPANI_A_CDC_ANC2_FF_FB_SHIFT,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0},
		TIMPANI_CDC_ANC2_FF_FB_SHIFT_M,
		TIMPANI_CDC_ANC2_FF_FB_SHIFT_POR
	},
	{
		TIMPANI_A_CDC_ANC2_RX_NS,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x0, 0xF8},
		TIMPANI_CDC_ANC2_RX_NS_M,
		TIMPANI_CDC_ANC2_RX_NS_POR
	},
	{
		TIMPANI_A_CDC_ANC2_SPARE,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0},
		TIMPANI_CDC_ANC2_SPARE_M,
		TIMPANI_CDC_ANC2_SPARE_POR
	},
	{
		TIMPANI_A_CDC_ANC2_IIR_COEFF_PTR,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xF, 0x0, 0xF0},
		TIMPANI_CDC_ANC2_IIR_COEFF_PTR_M,
		TIMPANI_CDC_ANC2_IIR_COEFF_PTR_POR
	},
	{
		TIMPANI_A_CDC_ANC2_IIR_COEFF_MSB,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0xFE},
		TIMPANI_CDC_ANC2_IIR_COEFF_MSB_M,
		TIMPANI_CDC_ANC2_IIR_COEFF_MSB_POR
	},
	{
		TIMPANI_A_CDC_ANC2_IIR_COEFF_LSB,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0},
		TIMPANI_CDC_ANC2_IIR_COEFF_LSB_M,
		TIMPANI_CDC_ANC2_IIR_COEFF_LSB_POR
	},
	{
		TIMPANI_A_CDC_ANC2_IIR_COEFF_CTL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0xFC},
		TIMPANI_CDC_ANC2_IIR_COEFF_CTL_M,
		TIMPANI_CDC_ANC2_IIR_COEFF_CTL_POR
	},
	{
		TIMPANI_A_CDC_ANC2_LPF_COEFF_PTR,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xF, 0x0, 0xF0},
		TIMPANI_CDC_ANC2_LPF_COEFF_PTR_M,
		TIMPANI_CDC_ANC2_LPF_COEFF_PTR_POR
	},
	{
		TIMPANI_A_CDC_ANC2_LPF_COEFF_MSB,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xF, 0x0, 0xF0},
		TIMPANI_CDC_ANC2_LPF_COEFF_MSB_M,
		TIMPANI_CDC_ANC2_LPF_COEFF_MSB_POR
	},
	{
		TIMPANI_A_CDC_ANC2_LPF_COEFF_LSB,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0},
		TIMPANI_CDC_ANC2_LPF_COEFF_LSB_M,
		TIMPANI_CDC_ANC2_LPF_COEFF_LSB_POR
	},
	{
		TIMPANI_A_CDC_ANC2_SCALE_PTR,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0},
		TIMPANI_CDC_ANC2_SCALE_PTR_M,
		TIMPANI_CDC_ANC2_SCALE_PTR_POR
	},
	{
		TIMPANI_A_CDC_ANC2_SCALE,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0},
		TIMPANI_CDC_ANC2_SCALE_M,
		TIMPANI_CDC_ANC2_SCALE_POR
	},
	{
		TIMPANI_A_CDC_ANC2_DEBUG,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xF, 0x0, 0xF0},
		TIMPANI_CDC_ANC2_DEBUG_M,
		TIMPANI_CDC_ANC2_DEBUG_POR
	},
	{
		TIMPANI_A_CDC_LINE_L_AVOL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0xFC, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3},
		TIMPANI_CDC_LINE_L_AVOL_M,
		TIMPANI_CDC_LINE_L_AVOL_POR
	},
	{
		TIMPANI_A_CDC_LINE_R_AVOL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0xFC, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3},
		TIMPANI_CDC_LINE_R_AVOL_M,
		TIMPANI_CDC_LINE_R_AVOL_POR
	},
	{
		TIMPANI_A_CDC_HPH_L_AVOL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFE,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1},
		TIMPANI_CDC_HPH_L_AVOL_M,
		TIMPANI_CDC_HPH_L_AVOL_POR
	},
	{
		TIMPANI_A_CDC_HPH_R_AVOL,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFE,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1},
		TIMPANI_CDC_HPH_R_AVOL_M,
		TIMPANI_CDC_HPH_R_AVOL_POR
	},
	{
		TIMPANI_A_CDC_COMP_CTL1,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x3F, 0x0, 0xC0},
		TIMPANI_CDC_COMP_CTL1_M,
		TIMPANI_CDC_COMP_CTL1_POR
	},
	{
		TIMPANI_A_CDC_COMP_CTL2,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xF, 0x0, 0xF0},
		TIMPANI_CDC_COMP_CTL2_M,
		TIMPANI_CDC_COMP_CTL2_POR
	},
	{
		TIMPANI_A_CDC_COMP_PEAK_METER,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xF, 0x0, 0xF0},
		TIMPANI_CDC_COMP_PEAK_METER_M,
		TIMPANI_CDC_COMP_PEAK_METER_POR
	},
	{
		TIMPANI_A_CDC_COMP_LEVEL_METER_CTL1,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xF, 0x0, 0xF0},
		TIMPANI_CDC_COMP_LEVEL_METER_CTL1_M,
		TIMPANI_CDC_COMP_LEVEL_METER_CTL1_POR
	},
	{
		TIMPANI_A_CDC_COMP_LEVEL_METER_CTL2,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0},
		TIMPANI_CDC_COMP_LEVEL_METER_CTL2_M,
		TIMPANI_CDC_COMP_LEVEL_METER_CTL2_POR
	},
	{
		TIMPANI_A_CDC_COMP_ZONE_SELECT,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x7F, 0x0, 0x80},
		TIMPANI_CDC_COMP_ZONE_SELECT_M,
		TIMPANI_CDC_COMP_ZONE_SELECT_POR
	},
	{
		TIMPANI_A_CDC_COMP_ZC_MSB,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0},
		TIMPANI_CDC_COMP_ZC_MSB_M,
		TIMPANI_CDC_COMP_ZC_MSB_POR
	},
	{
		TIMPANI_A_CDC_COMP_ZC_LSB,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0xFF, 0x0, 0x0},
		TIMPANI_CDC_COMP_ZC_LSB_M,
		TIMPANI_CDC_COMP_ZC_LSB_POR
	},
	{
		TIMPANI_A_CDC_COMP_SHUT_DOWN,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF},
		TIMPANI_CDC_COMP_SHUT_DOWN_M,
		TIMPANI_CDC_COMP_SHUT_DOWN_POR
	},
	{
		TIMPANI_A_CDC_COMP_SHUT_DOWN_STATUS,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF},
		TIMPANI_CDC_COMP_SHUT_DOWN_STATUS_M,
		TIMPANI_CDC_COMP_SHUT_DOWN_STATUS_POR
	},
	{
		TIMPANI_A_CDC_COMP_HALT,
		{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
		0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xFF},
		TIMPANI_CDC_COMP_HALT_M,
		TIMPANI_CDC_COMP_HALT_POR
	}
};

struct reg_acc_blk_cfg timpani_blkcfg[RA_BLOCK_NUM] = {
	{
		.valid_owners = {RA_OWNER_NONE, RA_OWNER_PATH_RX1,
		0, 0, 0, 0, RA_OWNER_DRV}
	},
	/* RA_BLOCK_RX1 */
	{
		.valid_owners = {RA_OWNER_NONE, 0, RA_OWNER_PATH_RX2,
		0, 0, 0, RA_OWNER_DRV}
	},
	/* RA_BLOCK_RX2 */
	{
		.valid_owners = {RA_OWNER_NONE, 0, 0, RA_OWNER_PATH_TX1,
		0, 0, RA_OWNER_DRV}
	},
	/* RA_BLOCK_TX1 */
	{
		.valid_owners = {RA_OWNER_NONE, 0, 0, 0, RA_OWNER_PATH_TX2,
		0, RA_OWNER_DRV}
	},
	/* RA_BLOCK_TX2 */
	{
		.valid_owners = {RA_OWNER_NONE, 0, 0, 0, 0,
		RA_OWNER_PATH_LB, RA_OWNER_DRV}
	},
	/* RA_BLOCK_LB */
	{
		.valid_owners = {RA_OWNER_NONE, RA_OWNER_PATH_RX1,
		RA_OWNER_PATH_RX2, 0, 0, RA_OWNER_PATH_LB, RA_OWNER_DRV}
	},
	/* RA_BLOCK_SHARED_RX_LB */
	{
		.valid_owners = {RA_OWNER_NONE, 0, 0, RA_OWNER_PATH_TX1,
		RA_OWNER_PATH_TX2, 0, RA_OWNER_DRV}
	},
	/* RA_BLOCK_SHARED_TX */
	{
		.valid_owners = {RA_OWNER_NONE, 0, 0, RA_OWNER_PATH_TX1,
		RA_OWNER_PATH_TX2, 0, RA_OWNER_DRV}
	},
	/* RA_BLOCK_TXFE1 */
	{
		.valid_owners = {RA_OWNER_NONE, 0, 0, RA_OWNER_PATH_TX1,
		RA_OWNER_PATH_TX2, 0, RA_OWNER_DRV}
	},
	/* RA_BLOCK_TXFE2 */
	{
		.valid_owners = {RA_OWNER_NONE, RA_OWNER_PATH_RX1,
		RA_OWNER_PATH_RX2, 0, 0, RA_OWNER_PATH_LB, RA_OWNER_DRV}
	},
	/* RA_BLOCK_PA_COMMON */
	{
		.valid_owners = {RA_OWNER_NONE, RA_OWNER_PATH_RX1,
		RA_OWNER_PATH_RX2, 0, 0, RA_OWNER_PATH_LB, RA_OWNER_DRV}
	},
	/* RA_BLOCK_PA_EAR */
	{
		.valid_owners = {RA_OWNER_NONE, RA_OWNER_PATH_RX1,
		RA_OWNER_PATH_RX2, 0, 0, RA_OWNER_PATH_LB, RA_OWNER_DRV}
	},
	/* RA_BLOCK_PA_HPH */
	{
		.valid_owners = {RA_OWNER_NONE, RA_OWNER_PATH_RX1,
		RA_OWNER_PATH_RX2, 0, 0, RA_OWNER_PATH_LB, RA_OWNER_DRV}
	},
	/* RA_BLOCK_PA_LINE */
	{
		.valid_owners = {RA_OWNER_NONE, RA_OWNER_PATH_RX1,
		RA_OWNER_PATH_RX2, 0, 0, RA_OWNER_PATH_LB, RA_OWNER_DRV}
	},
	/* RA_BLOCK_PA_AUX */
	{
		.valid_owners = {RA_OWNER_NONE, 0, 0, RA_OWNER_PATH_TX1,
		RA_OWNER_PATH_TX2, 0, RA_OWNER_DRV}
	},
	/* RA_BLOCK_ADC */
	{
		.valid_owners = {RA_OWNER_NONE, 0, 0, RA_OWNER_PATH_TX1,
		RA_OWNER_PATH_TX2, 0, RA_OWNER_DRV}
	},
	/* RA_BLOCK_DMIC */
	{
		.valid_owners = {RA_OWNER_NONE, 0, 0, RA_OWNER_PATH_TX1,
		RA_OWNER_PATH_TX2, 0, RA_OWNER_DRV}
	},
	/* RA_BLOCK_TX_I2S */
	{
		.valid_owners = {RA_OWNER_NONE, 0, 0, 0, 0, 0, RA_OWNER_DRV}
	},
	/*RA_BLOCK_DRV */
	{
		.valid_owners = {RA_OWNER_NONE, 0, 0, 0, 0, 0, RA_OWNER_DRV}
	},
	/* RA_BLOCK_TEST */
	{
		.valid_owners = {RA_OWNER_NONE, 0, 0, 0, 0, 0, RA_OWNER_DRV}
	},
	/* RA_BLOCK_RESERVED */
};

struct adie_codec_state {
	struct adie_codec_path path[ADIE_CODEC_MAX];
	u32 ref_cnt;
	struct marimba *pdrv_ptr;
	struct marimba_codec_platform_data *codec_pdata;
	struct mutex lock;
};

static struct adie_codec_state adie_codec;

static int adie_codec_write(u8 reg, u8 mask, u8 val)
{
	int rc;

	rc = marimba_write_bit_mask(adie_codec.pdrv_ptr, reg,  &val, 1, mask);
	if (IS_ERR_VALUE(rc)) {
		pr_err("%s: fail to write reg %x\n", __func__, reg);
		return -EIO;
	}

	pr_debug("%s: write reg %x val %x\n", __func__, reg, val);

	return 0;
}

static int adie_codec_read(u8 reg, u8 *val)
{
	return marimba_read(adie_codec.pdrv_ptr, reg, val, 1);
}

static int timpani_adie_codec_setpath(struct adie_codec_path *path_ptr,
					u32 freq_plan, u32 osr)
{
	int rc = 0;
	u32 i, freq_idx = 0, freq = 0;

	if (path_ptr->curr_stage != ADIE_CODEC_DIGITAL_OFF) {
		rc = -EBUSY;
		goto error;
	}

	for (i = 0; i < path_ptr->profile->setting_sz; i++) {
		if (path_ptr->profile->settings[i].osr == osr) {
			if (path_ptr->profile->settings[i].freq_plan >=
				freq_plan) {
				if (freq == 0) {
					freq = path_ptr->profile->settings[i].
								freq_plan;
					freq_idx = i;
				} else if (path_ptr->profile->settings[i].
					freq_plan < freq) {
					freq = path_ptr->profile->settings[i].
								freq_plan;
					freq_idx = i;
				}
			}
		}
	}

	if (freq_idx >= path_ptr->profile->setting_sz)
		rc = -ENODEV;
	else {
		path_ptr->hwsetting_idx = freq_idx;
		path_ptr->stage_idx = 0;
	}

error:
	return rc;
}

static u32 timpani_adie_codec_freq_supported(
				struct adie_codec_dev_profile *profile,
				u32 requested_freq)
{
	u32 i, rc = -EINVAL;

	for (i = 0; i < profile->setting_sz; i++) {
		if (profile->settings[i].freq_plan >= requested_freq) {
			rc = 0;
			break;
		}
	}
	return rc;
}

static void adie_codec_restore_regdefault(u32 blk)
{
	u32 ireg;
	u32 regset_sz =
	(sizeof(timpani_regset)/sizeof(struct timpani_regaccess));

	for (ireg = 0; ireg < regset_sz; ireg++) {
		if (timpani_regset[ireg].blk_mask[blk]) {
			/* only process register belong to the block */
			u8 reg = timpani_regset[ireg].reg_addr;
			u8 mask = timpani_regset[ireg].blk_mask[blk];
			u8 val = timpani_regset[ireg].reg_default;
			adie_codec_write(reg, mask, val);
		}
	}
}

static void adie_codec_reach_stage_action(struct adie_codec_path *path_ptr,
	u32 stage)
{
	u32 iblk, iowner; /* iterators */

	if (stage != ADIE_CODEC_FLASH_IMAGE)
		return;

	for (iblk = 0 ; iblk <= RA_BLOCK_RESERVED ; iblk++) {
		for (iowner = 0; iowner < RA_OWNER_NUM; iowner++) {
			if (timpani_blkcfg[iblk].valid_owners[iowner] ==
				path_ptr->reg_owner) {
				adie_codec_restore_regdefault(iblk);
				break; /* This path owns this block */
			}
		}
	}
}

static int timpani_adie_codec_proceed_stage(struct adie_codec_path *path_ptr,
						u32 state)
{
	int rc = 0, loop_exit = 0;
	struct adie_codec_action_unit *curr_action;
	struct adie_codec_hwsetting_entry *setting;
	u8 reg, mask, val;

	mutex_lock(&adie_codec.lock);
	setting = &path_ptr->profile->settings[path_ptr->hwsetting_idx];
	while (!loop_exit) {

		curr_action = &setting->actions[path_ptr->stage_idx];
		switch (curr_action->type) {
		case ADIE_CODEC_ACTION_ENTRY:
			ADIE_CODEC_UNPACK_ENTRY(curr_action->action,
			reg, mask, val);
			adie_codec_write(reg, mask, val);
			break;
		case ADIE_CODEC_ACTION_DELAY_WAIT:
			if (curr_action->action > MAX_MDELAY_US)
				msleep(curr_action->action/1000);
			else
				usleep_range(curr_action->action,
				curr_action->action);
			break;
		case ADIE_CODEC_ACTION_STAGE_REACHED:
			adie_codec_reach_stage_action(path_ptr,
				curr_action->action);
			if (curr_action->action == state) {
				path_ptr->curr_stage = state;
				loop_exit = 1;
			}
			break;
		default:
			BUG();
		}

		path_ptr->stage_idx++;
		if (path_ptr->stage_idx == setting->action_sz)
			path_ptr->stage_idx = 0;
	}
	mutex_unlock(&adie_codec.lock);

	return rc;
}

static void timpani_codec_bring_up(void)
{
	/* Codec power up sequence */
	adie_codec_write(0xFF, 0xFF, 0x08);
	adie_codec_write(0xFF, 0xFF, 0x0A);
	adie_codec_write(0xFF, 0xFF, 0x0E);
	adie_codec_write(0xFF, 0xFF, 0x07);
	adie_codec_write(0xFF, 0xFF, 0x17);
	adie_codec_write(TIMPANI_A_MREF, 0xFF, 0x22);
	msleep(15);
}

static void timpani_codec_bring_down(void)
{
	adie_codec_write(TIMPANI_A_MREF, 0xFF, TIMPANI_MREF_POR);
}

static int timpani_adie_codec_open(struct adie_codec_dev_profile *profile,
	struct adie_codec_path **path_pptr)
{
	int rc = 0;

	mutex_lock(&adie_codec.lock);

	if (!profile || !path_pptr) {
		rc = -EINVAL;
		goto error;
	}

	if (adie_codec.path[profile->path_type].profile) {
		rc = -EBUSY;
		goto error;
	}

	if (!adie_codec.ref_cnt) {

		if (adie_codec.codec_pdata &&
				adie_codec.codec_pdata->marimba_codec_power) {

			rc = adie_codec.codec_pdata->marimba_codec_power(1);
			if (rc) {
				pr_err("%s: could not power up timpani "
						"codec\n", __func__);
				goto error;
			}
		}
		timpani_codec_bring_up();

	}

	adie_codec.path[profile->path_type].profile = profile;
	*path_pptr = (void *) &adie_codec.path[profile->path_type];
	adie_codec.ref_cnt++;
	adie_codec.path[profile->path_type].hwsetting_idx = 0;
	adie_codec.path[profile->path_type].curr_stage = ADIE_CODEC_FLASH_IMAGE;
	adie_codec.path[profile->path_type].stage_idx = 0;


error:
	mutex_unlock(&adie_codec.lock);
	return rc;
}

static int timpani_adie_codec_close(struct adie_codec_path *path_ptr)
{
	int rc = 0;

	mutex_lock(&adie_codec.lock);

	if (!path_ptr) {
		rc = -EINVAL;
		goto error;
	}
	if (path_ptr->curr_stage != ADIE_CODEC_DIGITAL_OFF)
		adie_codec_proceed_stage(path_ptr, ADIE_CODEC_DIGITAL_OFF);

	BUG_ON(!adie_codec.ref_cnt);

	path_ptr->profile = NULL;
	adie_codec.ref_cnt--;

	if (!adie_codec.ref_cnt) {
		/* Timpani CDC power down sequence */
		timpani_codec_bring_down();

		if (adie_codec.codec_pdata &&
				adie_codec.codec_pdata->marimba_codec_power) {

			rc = adie_codec.codec_pdata->marimba_codec_power(0);
			if (rc) {
				pr_err("%s: could not power down timpani "
						"codec\n", __func__);
				goto error;
			}
		}
	}

error:
	mutex_unlock(&adie_codec.lock);
	return rc;
}

static const struct adie_codec_operations timpani_adie_ops = {
	.codec_id = TIMPANI_ID,
	.codec_open = timpani_adie_codec_open,
	.codec_close = timpani_adie_codec_close,
	.codec_setpath = timpani_adie_codec_setpath,
	.codec_proceed_stage = timpani_adie_codec_proceed_stage,
	.codec_freq_supported = timpani_adie_codec_freq_supported,
};

#ifdef CONFIG_DEBUG_FS
static struct dentry *debugfs_timpani_dent;
static struct dentry *debugfs_peek;
static struct dentry *debugfs_poke;
static struct dentry *debugfs_power;

static unsigned char read_data;

static int codec_debug_open(struct inode *inode, struct file *file)
{
	file->private_data = inode->i_private;
	return 0;
}

static int get_parameters(char *buf, long int *param1, int num_of_par)
{
	char *token;
	int base, cnt;

	token = strsep(&buf, " ");

	for (cnt = 0; cnt < num_of_par; cnt++) {
		if (token != NULL) {
			if ((token[1] == 'x') || (token[1] == 'X'))
				base = 16;
			else
				base = 10;

			if (strict_strtoul(token, base, &param1[cnt]) != 0)
				return -EINVAL;

			token = strsep(&buf, " ");
			}
		else
			return -EINVAL;
	}
	return 0;
}

static ssize_t codec_debug_read(struct file *file, char __user *ubuf,
				size_t count, loff_t *ppos)
{
	char lbuf[8];

	snprintf(lbuf, sizeof(lbuf), "0x%x\n", read_data);
	return simple_read_from_buffer(ubuf, count, ppos, lbuf, strlen(lbuf));
}

static ssize_t codec_debug_write(struct file *filp,
	const char __user *ubuf, size_t cnt, loff_t *ppos)
{
	char *access_str = filp->private_data;
	char lbuf[32];
	int rc;
	long int param[5];

	if (cnt > sizeof(lbuf) - 1)
		return -EINVAL;

	rc = copy_from_user(lbuf, ubuf, cnt);
	if (rc)
		return -EFAULT;

	lbuf[cnt] = '\0';

	if (!strcmp(access_str, "power")) {
		if (get_parameters(lbuf, param, 1) == 0) {
			switch (param[0]) {
			case 1:
				adie_codec.codec_pdata->marimba_codec_power(1);
				timpani_codec_bring_up();
				break;
			case 0:
				timpani_codec_bring_down();
				adie_codec.codec_pdata->marimba_codec_power(0);
				break;
			default:
				rc = -EINVAL;
				break;
			}
		} else
			rc = -EINVAL;
	} else if (!strcmp(access_str, "poke")) {
		/* write */
		rc = get_parameters(lbuf, param, 2);
		if ((param[0] <= 0xFF) && (param[1] <= 0xFF) &&
			(rc == 0))
			adie_codec_write(param[0], 0xFF, param[1]);
		else
			rc = -EINVAL;
	} else if (!strcmp(access_str, "peek")) {
		/* read */
		rc = get_parameters(lbuf, param, 1);
		if ((param[0] <= 0xFF) && (rc == 0))
			adie_codec_read(param[0], &read_data);
		else
			rc = -EINVAL;
	}

	if (rc == 0)
		rc = cnt;
	else
		pr_err("%s: rc = %d\n", __func__, rc);

	return rc;
}

static const struct file_operations codec_debug_ops = {
	.open = codec_debug_open,
	.write = codec_debug_write,
	.read = codec_debug_read
};
#endif

static int timpani_codec_probe(struct platform_device *pdev)
{
	int rc;

	adie_codec.pdrv_ptr = platform_get_drvdata(pdev);
	adie_codec.codec_pdata = pdev->dev.platform_data;

	if (adie_codec.codec_pdata->snddev_profile_init)
		adie_codec.codec_pdata->snddev_profile_init();

	/* Register the timpani ADIE operations */
	rc = adie_codec_register_codec_operations(&timpani_adie_ops);

#ifdef CONFIG_DEBUG_FS
	debugfs_timpani_dent = debugfs_create_dir("msm_adie_codec", 0);
	if (!IS_ERR(debugfs_timpani_dent)) {
		debugfs_peek = debugfs_create_file("peek",
		S_IFREG | S_IRUGO, debugfs_timpani_dent,
		(void *) "peek", &codec_debug_ops);

		debugfs_poke = debugfs_create_file("poke",
		S_IFREG | S_IRUGO, debugfs_timpani_dent,
		(void *) "poke", &codec_debug_ops);

		debugfs_power = debugfs_create_file("power",
		S_IFREG | S_IRUGO, debugfs_timpani_dent,
		(void *) "power", &codec_debug_ops);
	}
#endif

	return rc;
}

static struct platform_driver timpani_codec_driver = {
	.probe = timpani_codec_probe,
	.driver = {
		.name = "timpani_codec",
		.owner = THIS_MODULE,
	},
};

static int __init timpani_codec_init(void)
{
	s32 rc;

	rc = platform_driver_register(&timpani_codec_driver);
	if (IS_ERR_VALUE(rc))
		goto error;

	adie_codec.path[ADIE_CODEC_TX].reg_owner = RA_OWNER_PATH_TX1;
	adie_codec.path[ADIE_CODEC_RX].reg_owner = RA_OWNER_PATH_RX1;
	adie_codec.path[ADIE_CODEC_LB].reg_owner = RA_OWNER_PATH_LB;
	mutex_init(&adie_codec.lock);
error:
	return rc;
}

static void __exit timpani_codec_exit(void)
{
#ifdef CONFIG_DEBUG_FS
	debugfs_remove(debugfs_peek);
	debugfs_remove(debugfs_poke);
	debugfs_remove(debugfs_power);
	debugfs_remove(debugfs_timpani_dent);
#endif
	platform_driver_unregister(&timpani_codec_driver);
}

module_init(timpani_codec_init);
module_exit(timpani_codec_exit);

MODULE_DESCRIPTION("Timpani codec driver");
MODULE_VERSION("1.0");
MODULE_LICENSE("GPL v2");
