/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

/**
 * @file UnitTestRunner.java
 *
 * @author Mattias Hansson (mattias.hansson@sonyericsson.com)
 */

package com.sonyericsson.eventstream.twitterplugin.runners;

import android.test.InstrumentationTestRunner;
import android.test.InstrumentationTestSuite;

import com.sonyericsson.eventstream.twitterplugin.UApplicationTests;
import com.sonyericsson.eventstream.twitterplugin.service.UEventStreamListenerTests;
import com.sonyericsson.eventstream.twitterplugin.twitter.UCredentialHandlerTests;
import com.sonyericsson.eventstream.twitterplugin.twitter.UTwitterCommunicationTests;
import com.sonyericsson.eventstream.twitterplugin.UContactLookupHandlerTests;
import com.sonyericsson.eventstream.twitterplugin.UPreferenceHelperTests;
import com.sonyericsson.eventstream.twitterplugin.twitter.UTwitterPluginExceptionTests;

import junit.framework.TestSuite;

public class UnitTestRunner extends InstrumentationTestRunner {

    @Override
    public TestSuite getAllTests() {
        TestSuite suite = new InstrumentationTestSuite(this);
        suite.addTestSuite(UApplicationTests.class);
        suite.addTestSuite(UCredentialHandlerTests.class);
        suite.addTestSuite(UEventStreamListenerTests.class);
        suite.addTestSuite(UPreferenceHelperTests.class);
        suite.addTestSuite(UTwitterCommunicationTests.class);
        suite.addTestSuite(UTwitterPluginExceptionTests.class);
        suite.addTestSuite(UContactLookupHandlerTests.class);
        return suite;
    }

    @Override
    public ClassLoader getLoader() {
        return UnitTestRunner.class.getClassLoader();
    }
}