/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import com.sonyericsson.eventstream.twitterplugin.PluginConstants.TwitterConf;
import com.sonyericsson.eventstream.twitterplugin.utility.ContactLookupHelper;

import org.easymock.EasyMock;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

import android.content.ContentResolver;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract;
import android.provider.ContactsContract.Contacts;
import android.provider.ContactsContract.RawContacts;
import android.util.Log;

@RunWith(PowerMockRunner.class)
@PrepareForTest({ContentResolver.class, Cursor.class, Contacts.class, String.class, Log.class, Uri.class})

public class TestContactLookupHelper {    

    private static final String EMPTY_LOOKUP_STRING = "";

    private static final int TWITTER_USER_ID = 12;

    private static final long CONTACT_ID = 23;

    private static final int COLUMN_INDEX = 1;

    private static final int ITEM_COUNT_IS_ONE = 1;

    private static final int ITEM_COUNT_IS_ZERO = 0;    

    private static final int RAW_CONTACT_ID = 25;
    private static final String RAW_CONTACT_ID_STRING = "25";

    private static final String WHERE = RawContacts.ACCOUNT_TYPE
    + " like ? and " + RawContacts.SOURCE_ID + " = ?";

    private static final String[] WHERE_ARGS = {
            TwitterConf.ACCOUNT_TYPE_SEARCH,
            String.valueOf(TWITTER_USER_ID)
    };

    /**
     * Test that we return correct value when we provide correct values.
     *
     * @throws Exception
     */
    @Test
    public void testContactRawContactExistCorrectValues() throws Exception {
//        ContentResolver contentResolver = PowerMock.createMock(ContentResolver.class);
//        PowerMock.mockStatic(Uri.class);
//        Cursor cursor = PowerMock.createMock(Cursor.class);
//        Uri uri = PowerMock.createMock(Uri.class);
//
//        EasyMock.expect(
//                Uri.parse(ContactsContract.RawContacts.CONTENT_URI.toString() + "/" + RAW_CONTACT_ID_STRING)).andReturn(uri).once();
//        EasyMock.expect(
//                uri.toString()).andReturn("ContactsContract.RawContact").once();
//        EasyMock.expect(
//                contentResolver.query(EasyMock.eq(uri),
//                        EasyMock.aryEq((String[])null),
//                        EasyMock.eq((String)null),
//                        EasyMock.aryEq((String[])null),
//                        EasyMock.eq((String)null))).andReturn(cursor).once();
//
//        EasyMock.expect(cursor.getCount()).andReturn(ITEM_COUNT_IS_ONE).once();
//        PowerMock.replayAll();
//        boolean result = ContactLookupHelper.contactRawContactExist(contentResolver, ContactsContract.RawContacts.CONTENT_URI.toString() + "/" + RAW_CONTACT_ID_STRING);
//        PowerMock.verifyAll();
//        assertTrue("Expected true when providing correct inparams", result);
    }

    /**
     * Test to see that we handle getCount() when it returns zero
     *
     * @throws Exception
     */
    @Test
    public void testContactRawContactExistGetCountOnCursorReturnsZero() throws Exception {
//
//        ContentResolver contentResolver = PowerMock.createMock(ContentResolver.class);
//
//        Cursor cursor = PowerMock.createMock(Cursor.class);
//
//        EasyMock.expect(
//                contentResolver.query(EasyMock.eq(Uri.withAppendedPath(ContactsContract.RawContacts.CONTENT_URI, RAW_CONTACT_ID_STRING)),
//                        EasyMock.aryEq((String[])null),
//                        EasyMock.eq((String)null),
//                        EasyMock.aryEq((String[])null),
//                        EasyMock.eq((String)null))).andReturn(cursor).once();
//
//        EasyMock.expect(cursor.getCount()).andReturn(ITEM_COUNT_IS_ZERO).once();
//        PowerMock.replayAll();
//        boolean result = ContactLookupHelper.contactRawContactExist(contentResolver, ContactsContract.RawContacts.CONTENT_URI + "/" + RAW_CONTACT_ID);
//        PowerMock.verifyAll();
//        assertFalse("Expected false since cursor.getCount() returned 0", result);
    }

    /**
     * Test to see that we handle getCount() when it throws exception
     *
     * @throws Exception
     */
    @Test
    public void testContactRawContactExistGetCountOnCursorThrowsException() throws Exception {
//
//        ContentResolver contentResolver = PowerMock.createMock(ContentResolver.class);
//        Cursor cursor = PowerMock.createMock(Cursor.class);
//
//        PowerMock.suppress(Log.class.getMethods());
//
//        EasyMock.expect(
//                contentResolver.query(EasyMock.eq(Uri.withAppendedPath(ContactsContract.RawContacts.CONTENT_URI, RAW_CONTACT_ID_STRING)),
//                        EasyMock.aryEq((String[])null),
//                        EasyMock.eq((String)null),
//                        EasyMock.aryEq((String[])null),
//                        EasyMock.eq((String)null))).andReturn(cursor).once();
//
//        EasyMock.expect(cursor.getCount()).andThrow(new NullPointerException());
//        PowerMock.replayAll();
//        boolean result = ContactLookupHelper.contactRawContactExist(contentResolver, ContactsContract.RawContacts.CONTENT_URI + "/" + RAW_CONTACT_ID);
//        PowerMock.verifyAll();
//        assertFalse("Expected false since cursor.getCount() throwed and exception", result);
    }

    /**
     * Test to see that we handle null Cursor object correctly
     *
     * @throws Exception
     */
    @Test
    public void testContactRawContactExistCursorIsNull() throws Exception {
//        ContentResolver contentResolver = PowerMock.createMock(ContentResolver.class);
//        Cursor cursor = PowerMock.createMock(Cursor.class);
//
//        PowerMock.suppress(Log.class.getMethods());
//
//        EasyMock.expect(
//                contentResolver.query(EasyMock.eq(Uri.withAppendedPath(ContactsContract.RawContacts.CONTENT_URI, RAW_CONTACT_ID_STRING)),
//                        EasyMock.aryEq((String[])null),
//                        EasyMock.eq((String)null),
//                        EasyMock.aryEq((String[])null),
//                        EasyMock.eq((String)null))).andReturn(cursor).once();
//
//        PowerMock.replayAll();
//        boolean result = ContactLookupHelper.contactRawContactExist(contentResolver, ContactsContract.RawContacts.CONTENT_URI + "/" + RAW_CONTACT_ID);
//        PowerMock.verifyAll();
//        assertFalse("Expected false since the Cursor object is null", result);
    }

    /**
     * Test that we return correct value when we provide correct values.
     *
     * @throws Exception
     */
    @Test
    public void testGetLookupKeyInContactsCorrectValues() throws Exception {
//        PowerMock.suppress(Log.class.getMethods());
//
//        // Setup mock object
//        ContentResolver contentResolver = PowerMock.createMock(ContentResolver.class);
//        Cursor rawCursor = PowerMock.createMock(Cursor.class);
//
//        EasyMock.expect(
//                contentResolver.query(EasyMock.eq(Uri.withAppendedPath(ContactsContract.RawContacts.CONTENT_URI, RAW_CONTACT_ID_STRING)),
//                        EasyMock.aryEq((String[])null),
//                        EasyMock.eq((String)null),
//                        EasyMock.aryEq((String[])null),
//                        EasyMock.eq((String)null))).andReturn(rawCursor).once();
//
//        EasyMock.expect(rawCursor.moveToFirst()).andReturn(true).once();
//        EasyMock.expect(rawCursor.getColumnIndexOrThrow(RawContacts.CONTACT_ID)).andReturn(COLUMN_INDEX).once();
//        EasyMock.expect(rawCursor.getLong(COLUMN_INDEX)).andReturn(CONTACT_ID).once();
//
//        rawCursor.close();
//        EasyMock.expectLastCall().once();
//
//        PowerMock.replayAll();
//        String result = ContactLookupHelper.getRawContactUriInContacts(contentResolver, TWITTER_USER_ID);
//        PowerMock.verifyAll();
//        assertEquals("Expected a valid result", ContactsContract.RawContacts.CONTENT_URI + "/" + RAW_CONTACT_ID, result);
    }

    /**
     * When contentResolver.query() returns null as raw cursor we expect an
     * empty string.
     *
     * @throws Exception
     */
    @Test
    public void testGetRawContactInContactsRawCursorIsNull() throws Exception {
//        PowerMock.suppress(Log.class.getMethods());
//
//        // Setup mock object
//        ContentResolver contentResolver = PowerMock.createMock(ContentResolver.class);
//
//        EasyMock.expect(
//                contentResolver.query(EasyMock.eq(Uri.withAppendedPath(ContactsContract.RawContacts.CONTENT_URI, RAW_CONTACT_ID_STRING)),
//                        EasyMock.aryEq((String[])null),
//                        EasyMock.eq((String)null),
//                        EasyMock.aryEq((String[])null),
//                        EasyMock.eq((String)null))).andReturn(null).once();
//
//        PowerMock.replayAll();
//        String result = ContactLookupHelper.getRawContactUriInContacts(contentResolver, TWITTER_USER_ID);
//        PowerMock.verifyAll();
//        assertEquals("Expected an empty string", EMPTY_LOOKUP_STRING, result);
    }

    /**
     * When rawCursor.moveToNext() returns false we should get an empty string
     *
     * @throws Exception
     */
    @Test
    public void testGetRawContactInContactsMoveToNextOnRawCursorReturnsFalse() throws Exception {
//        PowerMock.suppress(Log.class.getMethods());
//
//        // Setup mock object
//        ContentResolver contentResolver = PowerMock.createMock(ContentResolver.class);
//        Cursor rawCursor = PowerMock.createMock(Cursor.class);
//
//        EasyMock.expect(
//                contentResolver.query(EasyMock.eq(Uri.withAppendedPath(ContactsContract.RawContacts.CONTENT_URI, RAW_CONTACT_ID_STRING)),
//                        EasyMock.aryEq((String[])null),
//                        EasyMock.eq((String)null),
//                        EasyMock.aryEq((String[])null),
//                        EasyMock.eq((String)null))).andReturn(rawCursor).once();
//
//        EasyMock.expect(rawCursor.moveToFirst()).andReturn(false).once();
//
//        rawCursor.close();
//        EasyMock.expectLastCall().once();
//
//        PowerMock.replayAll();
//        String result = ContactLookupHelper.getRawContactUriInContacts(contentResolver, TWITTER_USER_ID);
//        PowerMock.verifyAll();
//        assertEquals("Expected an empty string", EMPTY_LOOKUP_STRING, result);
    }


    /**
     * We should get an empty string if someone is throwing an exception
     *
     * @throws Exception
     */
    @Test
    public void testGetLookupKeyInContactsGetIntOnContactsCursorThrowsException() throws Exception {
//        PowerMock.suppress(Log.class.getMethods());
//
//        // Setup mock object
//        ContentResolver contentResolver = PowerMock.createMock(ContentResolver.class);
//        Cursor rawCursor = PowerMock.createMock(Cursor.class);
//
//        EasyMock.expect(
//                contentResolver.query(EasyMock.eq(Uri.withAppendedPath(ContactsContract.RawContacts.CONTENT_URI, RAW_CONTACT_ID_STRING)),
//                        EasyMock.aryEq((String[])null),
//                        EasyMock.eq((String)null),
//                        EasyMock.aryEq((String[])null),
//                        EasyMock.eq((String)null))).andReturn(rawCursor).once();
//
//        EasyMock.expect(rawCursor.getColumnIndexOrThrow(ContactsContract.RawContacts._ID)).andThrow(new NullPointerException());
//
//        rawCursor.close();
//        EasyMock.expectLastCall().once();
//
//        PowerMock.replayAll();
//        String result = ContactLookupHelper.getRawContactUriInContacts(contentResolver, TWITTER_USER_ID);
//        PowerMock.verifyAll();
//        assertEquals("Expected an empty string", EMPTY_LOOKUP_STRING, result);
    }
}
