/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.telephonyplugin;

import com.sonyericsson.eventstream.telephonyplugin.PluginConstants.Config;
import com.sonyericsson.eventstream.telephonyplugin.PluginConstants.EventStream;
import com.sonyericsson.eventstream.telephonyplugin.PluginConstants.ServiceIntentCmd;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

/**
 * @auth Erik Hellman <erik.hellman@sonyericsson.com>
 */
public class EventStreamListener extends BroadcastReceiver {

    @Override
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (Config.DEBUG) {
            Log.d(Config.LOG_TAG, "Got broadcast: " + action);
        }
        Intent serviceIntent = new Intent();
        serviceIntent.setComponent(new ComponentName(context, TelephonyPluginService.class));

        if (EventStream.REFRESH_REQUEST_ACTION.equals(action)) {
            if (Config.DEBUG) {
                Log.d(Config.LOG_TAG, "Starting event refresh for Telephony...");
            }
            serviceIntent.putExtra(ServiceIntentCmd.SERVICE_COMMAND_KEY,
                    ServiceIntentCmd.REFRESH_REQUEST);
        } else if (EventStream.REGISTER_PLUGINS_ACTION.equals(action)) {
            if (Config.DEBUG) {
                Log.d(Config.LOG_TAG, "Starting plugin registration for Telephony...");
            }
            serviceIntent.putExtra(ServiceIntentCmd.SERVICE_COMMAND_KEY,
                    ServiceIntentCmd.REGISTER_PLUGIN);
        } else if (EventStream.VIEW_EVENT_ACTION.equals(action)) {
            if (Config.DEBUG) {
                Log.d(Config.LOG_TAG, "Recieved view event request from Event Stream.");
            }
            serviceIntent.putExtra(ServiceIntentCmd.SERVICE_COMMAND_KEY,
                    ServiceIntentCmd.VIEW_EVENT);
            String eventId = intent.getStringExtra(EventStream.EVENTSTREAM_VIEW_INTENT_FRIEND_KEY_DATA);
            if (eventId == null) {
                return;
            }
            serviceIntent.putExtra(EventStream.EVENTSTREAM_VIEW_INTENT_FRIEND_KEY_DATA, eventId);
        } else {
            if (Config.DEBUG) {
                Log.d(Config.LOG_TAG, "Intent action was not valid");
            }
            return;
        }
        context.startService(serviceIntent);
    }
}
