/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.         *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

/**
 * @file
 *
 * @author Maria Ekström (maria.ekstrom@sonyericsson.com)
 */

package com.sonyericsson.simpleui.activity;

import com.sonyericsson.simpleui.R;
import com.sonyericsson.simpleui.provider.EventStreamContentProvider;
import com.sonyericsson.simpleui.utils.DBUtilities;
import com.sonyericsson.simpleui.utils.ImageManager;
import com.sonyericsson.simpleui.utils.ImageUtilities;

import android.app.Activity;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.Date;

public class SimpleUiPreviewActivity extends Activity {

    private Bitmap mDefaultSourceIconBitmap;
    private ImageManager mImageManager;
    protected static final String EVENT_ID_INTENT_DATA_KEY = "event_id";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.preview_mode);
        Intent launchIntent = getIntent();
        Long eventId = (Long)launchIntent.getExtras().get(EVENT_ID_INTENT_DATA_KEY);
        ImageView backgroundImage = (ImageView)findViewById(R.id.preview_background_image);
        ImageView sourceIconImage = (ImageView)findViewById(R.id.preview_source_icon);
        ImageView eventIconImage = (ImageView)findViewById(R.id.preview_event_icon);
        TextView eventMessage = (TextView)findViewById(R.id.preview_event_message);
        TextView friendName = (TextView)findViewById(R.id.preview_friend_name);
        TextView timestamp = (TextView)findViewById(R.id.preview_event_timestamp);

        mImageManager = ImageManager.getInstance(this);

        mDefaultSourceIconBitmap = BitmapFactory.decodeResource(
                getResources(), R.drawable.generic_service);
        Cursor cursor = null;
        try {
            cursor = DBUtilities.querySplineEventCursor(this, String.valueOf(eventId));
            if (cursor != null && cursor.moveToFirst()) {
                String mainMessageText = cursor.getString(cursor
                        .getColumnIndexOrThrow(EventStreamContentProvider.EventColumns.MESSAGE));
                eventMessage.setText(mainMessageText);

                String titleText = cursor.getString(cursor
                        .getColumnIndexOrThrow(EventStreamContentProvider.EventColumns.TITLE));
                if (titleText != null && !titleText.equals("")) {
                    friendName.setText(titleText);
                } else {
                    friendName.setText(cursor.getString(cursor
                        .getColumnIndex(EventStreamContentProvider.EventColumns.DISPLAY_NAME)));
                }

                mImageManager.getEventImage(backgroundImage, cursor);

                String sourceIconUriString = cursor.getString(cursor.getColumnIndex(
                        EventStreamContentProvider.SourceColumns.ICON_URI));
                Bitmap sourceIconBitmap = null;
                if (sourceIconBitmap != null) {
                    sourceIconBitmap = ImageUtilities.decodeImageFromUri(
                        this, Uri.parse(sourceIconUriString));
                }
                if (sourceIconBitmap == null) {
                    sourceIconBitmap = mDefaultSourceIconBitmap;
                }
                sourceIconImage.setImageBitmap(sourceIconBitmap);

                String eventIconUriString = cursor.getString(cursor.getColumnIndex(
                        EventStreamContentProvider.EventColumns.STATUS_ICON_URI));
                Bitmap eventIconBitmap = null;
                if (eventIconUriString != null) {
                    eventIconBitmap = ImageUtilities.decodeImageFromUri(
                        this, Uri.parse(eventIconUriString));
                }
                if (eventIconBitmap != null) {
                    eventIconImage.setImageBitmap(eventIconBitmap);
                }
                long publishedTime = cursor.getLong(cursor.getColumnIndex(
                        EventStreamContentProvider.EventColumns.PUBLISHED_TIME));
                Date publishedDate = new Date(publishedTime);
                String dateText = publishedDate.toLocaleString();
                timestamp.setText(dateText);
            }
        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

}

