/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.facebookplugin;

import static com.sonyericsson.eventstream.facebookplugin.Constants.EVENT_KEY_EXTRA;
import static com.sonyericsson.eventstream.facebookplugin.Constants.FRIEND_KEY_EXTRA;
import static com.sonyericsson.eventstream.facebookplugin.Constants.PLUGIN_KEY;
import static com.sonyericsson.eventstream.facebookplugin.Constants.PLUGIN_KEY_PARAMETER;

import com.sonyericsson.eventstream.facebookplugin.EventStreamConstants.Config;
import com.sonyericsson.eventstream.facebookplugin.EventStreamConstants.EventstreamIntentData;
import com.sonyericsson.eventstream.facebookplugin.EventStreamConstants.EventstreamIntents;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;


/**
 * Listen for broadcasts from Event Stream and launch the FacebookService accordingly.
 *
 *
 * @author Erik Hellman <erik.hellman@sonyericsson.com>
 */
public class EventStreamListener extends BroadcastReceiver {

    private static final String LOG_TAG = "Facebook-EventStreamListener";

    @Override
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        Intent serviceIntent = null;
        if (Config.DEBUG) {
            Log.d(LOG_TAG, "Received broadcast: " + action);
        }
        if (EventstreamIntents.REGISTER_PLUGINS_REQUEST_INTENT
                .equals(action)) {
            serviceIntent = new Intent(Constants.REGISTER_PLUGIN_INTENT);
        }
        else if (intent.hasExtra(PLUGIN_KEY_PARAMETER)
                && PLUGIN_KEY.equals(intent
                        .getStringExtra(PLUGIN_KEY_PARAMETER))) {
            if (Config.DEBUG) {
                Log.d(LOG_TAG, "Plugin key valid: " + intent
                        .getStringExtra(PLUGIN_KEY_PARAMETER));
            }
            if (EventstreamIntents.STATUS_UPDATE_INTENT.equals(action)) {
                if (intent.hasExtra(EventstreamIntentData.EXTRA_STATUS_UPDATE_MESSAGE)) {
                    serviceIntent = new Intent(Constants.SEND_STATUS_UPDATE_INTENT);
                    serviceIntent.putExtra(EventstreamIntentData.EXTRA_STATUS_UPDATE_MESSAGE, intent
                            .getStringExtra(EventstreamIntentData.EXTRA_STATUS_UPDATE_MESSAGE));
                }

            } else if (EventstreamIntents.REFRESH_REQUEST_INTENT.equals(action)) {
                serviceIntent = new Intent(Constants.REFRESH_REQUEST_INTENT);

            } else if (EventstreamIntents.VIEW_EVENT_INTENT.equals(action)) {
                String eventKey = intent.getStringExtra(EventStreamConstants.EventstreamIntentData.EXTRA_EVENT_KEY);
                String friendKey = intent.getStringExtra(EventStreamConstants.EventstreamIntentData.EXTRA_FRIEND_KEY);

                serviceIntent = new Intent(Constants.LAUNCH_BROWSER_INTENT);
                serviceIntent.putExtra(EVENT_KEY_EXTRA, eventKey);
                serviceIntent.putExtra(FRIEND_KEY_EXTRA, friendKey);
            }
        }
        else {
            if (Config.DEBUG) {
                Log.d(LOG_TAG, "Invalid plugin key, expected: " + PLUGIN_KEY + " but received :" + intent
                        .getStringExtra(PLUGIN_KEY_PARAMETER));
            }
        }
        if (serviceIntent != null) {
            serviceIntent.setClass(context, FacebookService.class);
            serviceIntent.putExtra(PLUGIN_KEY_PARAMETER, PLUGIN_KEY);
            context.startService(serviceIntent);
        }
    }
}
