/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2009 Sony Ericsson Mobile Communications AB.         *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

/**
 * @file
 * @author Mats Wilson (mats.wilson@sonyericsson.com)
 */

package com.sonyericsson.eventstream.telephonyplugin;

import android.content.Context;
import android.database.Cursor;
import android.test.InstrumentationTestCase;

public class UOriginatedSourceHelper extends InstrumentationTestCase {

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * Check that lookup do not throw exception, not using any mock objects,
     * check that contacts do not return null or throw exception.
     */
    public void testContactLookupAddressValid() {
        String address = "123456789";
        boolean exeptionThrown = false;
        String exceptionMessage = "";
        Cursor returnedCursor = null;
        OriginatedSourceHelper sourceHelper = new OriginatedSourceHelper();

        try {
            returnedCursor = sourceHelper.contactLookupAddress(
                    getInstrumentation().getTargetContext(), address);
        } catch(Exception e) {
            exeptionThrown = true;
            exceptionMessage = e.toString();
        }

        assertEquals("Exception should not be thrown, message: " + exceptionMessage, false, exeptionThrown);
        assertNotNull("Returned cursor should not be null", returnedCursor);
    }

    /**
     * Check if lookup can handle null arguments, should always return a null cursor.
     */
    public void testContactLookupAddressInparamNull() {
        String address = "123456789";
        boolean exeptionThrown = false;
        String exceptionMessage = "";
        Cursor returnedCursor = null;
        Context context = getInstrumentation().getTargetContext();

        OriginatedSourceHelper sourceHelper = new OriginatedSourceHelper();

        try {
            returnedCursor = sourceHelper.contactLookupAddress(context, null);
        } catch(Exception e) {
            exeptionThrown = true;
        }

        assertEquals("Exception should not be thrown", false, exeptionThrown);
        assertNull("Returned cursor should be null", returnedCursor);

        try {
            returnedCursor = sourceHelper.contactLookupAddress(null, address);
        } catch(Exception e) {
            exeptionThrown = true;
            exceptionMessage = e.toString();
        }

        assertEquals("Exception should not be thrown, message: " + exceptionMessage, false, exeptionThrown);
        assertNull("Returned cursor should be null", returnedCursor);
    }

    /**
     * Check if lookup can handle null arguments, should always return a null cursor.
     */
    public void testContactLookupAddressNoContent() {
        String address = "";
        boolean exeptionThrown = false;
        String exceptionMessage = "";
        Cursor returnedCursor = null;

        OriginatedSourceHelper sourceHelper = new OriginatedSourceHelper();

        try {
            returnedCursor = sourceHelper.contactLookupAddress(
                    getInstrumentation().getTargetContext(), address);
        } catch(Exception e) {
            exeptionThrown = true;
            exceptionMessage = e.toString();
        }

        assertEquals("Exception should not be thrown, message: " + exceptionMessage, false, exeptionThrown);
        assertNull("Returned cursor should be null", returnedCursor);
    }
}
