/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

/**
 * @file
 * @author Niklas Karlsson (niklas.karlsson@sonyericsson.com)
 */
package com.sonyericsson.eventstream.facebookplugin.util;

import com.sonyericsson.eventstream.facebookplugin.FacebookSecurity;

import org.apache.http.NameValuePair;

import android.content.Context;
import android.net.Uri;

import java.util.List;

public class MockFacebookSecurity extends FacebookSecurity {
    private final String MOCK_API_KEY = "11111111";
    private final String MOCK_SECURITY_KEY = "22222222";
    private final String DEEP_LINK_URI_STRING = "https://m.facebook.com";
    private final String AUTHENTICATION_SIGNATURE = "34234234234";

    public MockFacebookSecurity() {

    }

    public String generateAPIKey() {
        return MOCK_API_KEY;
    }

    public String generateSecretKey() {
        return MOCK_SECURITY_KEY;
    }

    public Uri generateDeepLink(Context context, String uid, String destUriString) {
        return Uri.parse(DEEP_LINK_URI_STRING);
    }

    public String generateAuthenticationSignature(List<NameValuePair> parameters) {
        return AUTHENTICATION_SIGNATURE;
    }
}