/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.facebookplugin;

import android.content.ComponentName;
import android.content.Intent;
import android.test.AndroidTestCase;
import android.test.mock.MockContext;

import com.sonyericsson.eventstream.facebookplugin.EventStreamConstants.EventstreamIntentData;
import com.sonyericsson.eventstream.facebookplugin.EventStreamConstants.EventstreamIntents;

public class UFacebookPluginTestListener extends AndroidTestCase {

    private DummyContext mDummyContext;

    private EventStreamListener mListener;


    @Override
    protected void setUp() throws Exception {
        super.setUp();
        mDummyContext = new DummyContext();
        mListener = new EventStreamListener();
    }

    @Override
    protected void tearDown() throws Exception {
        // TODO Auto-generated method stub
        super.tearDown();
    }

    public void testRegister() {
        Intent intent = new Intent(EventstreamIntents.REGISTER_PLUGINS_REQUEST_INTENT);
        mListener.onReceive(mDummyContext, intent);
        assertNotNull(mDummyContext.serviceIntent);
        assertEquals(Constants.REGISTER_PLUGIN_INTENT, mDummyContext.serviceIntent.getAction());
    }

    public void testRefresh() {
        Intent intent = new Intent(EventstreamIntents.REFRESH_REQUEST_INTENT);
        mListener.onReceive(mDummyContext, intent);
        assertNull(mDummyContext.serviceIntent);
        // Add the plugin key and try again
        intent.putExtra(Constants.PLUGIN_KEY_PARAMETER, Constants.PLUGIN_KEY);
        mListener.onReceive(mDummyContext, intent);
        assertNotNull(mDummyContext.serviceIntent);
        assertEquals(Constants.REFRESH_REQUEST_INTENT, mDummyContext.serviceIntent.getAction());
    }

    public void testStatusUpdate() {
        String testStatus = "Hello world, this is my new status!";
        Intent intent = new Intent(EventstreamIntents.STATUS_UPDATE_INTENT);
        mListener.onReceive(mDummyContext, intent);
        assertNull(mDummyContext.serviceIntent);
        // Add the plugin key and try again
        intent.putExtra(Constants.PLUGIN_KEY_PARAMETER, Constants.PLUGIN_KEY);
        mListener.onReceive(mDummyContext, intent);
        assertNull(mDummyContext.serviceIntent);
        // Finally add the status update message
        intent.putExtra(EventstreamIntentData.EXTRA_STATUS_UPDATE_MESSAGE, testStatus);
        mListener.onReceive(mDummyContext, intent);
        assertNotNull(mDummyContext.serviceIntent);
        assertEquals(Constants.SEND_STATUS_UPDATE_INTENT, mDummyContext.serviceIntent.getAction());
        assertEquals(testStatus, mDummyContext.serviceIntent.getStringExtra(EventstreamIntentData.EXTRA_STATUS_UPDATE_MESSAGE));
    }

    public void testViewEvent() {
        String friendId = "10001010101010";
        String eventId = "7492384761";
        Intent intent = new Intent(EventstreamIntents.VIEW_EVENT_INTENT);
        intent.putExtra(EventstreamIntentData.EXTRA_EVENT_KEY, eventId);
        intent.putExtra(EventstreamIntentData.EXTRA_FRIEND_KEY, friendId);
        mListener.onReceive(mDummyContext, intent);
        assertNull(mDummyContext.serviceIntent);
        // Add the plugin key and try again
        intent.putExtra(Constants.PLUGIN_KEY_PARAMETER, Constants.PLUGIN_KEY);
        mListener.onReceive(mDummyContext, intent);
        assertNotNull(mDummyContext.serviceIntent);
        assertEquals(Constants.LAUNCH_BROWSER_INTENT, mDummyContext.serviceIntent.getAction());
        assertEquals(eventId, mDummyContext.serviceIntent.getStringExtra(Constants.EVENT_KEY_EXTRA));
        assertEquals(friendId, mDummyContext.serviceIntent.getStringExtra(Constants.FRIEND_KEY_EXTRA));
    }

    public class DummyContext extends MockContext {

        public Intent serviceIntent = null;

        @Override
        public ComponentName startService(Intent service) {
            serviceIntent = service;
            return null;
        }

        @Override
        public String getPackageName() {
            return "com.sonyericsson.eventstream.facebookplugin";
        }
    }
}
